/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.site.CacheUtil;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class RemoteController
extends AbstractController {
    private static final String MODE_CACHE = "cache";
    private static final String MODE_CACHE_COMMAND_INVALIDATE = "invalidate";
    private static final String MODE_WEBSCRIPTS = "webscripts";
    private static final String MODE_WEBSCRIPTS_COMMAND_RESET = "reset";
    private FrameworkBean frameworkUtil;

    public void setFrameworkUtil(FrameworkBean frameworkUtil) {
        this.frameworkUtil = frameworkUtil;
    }

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        String uri = request.getRequestURI();
        uri = uri.substring(request.getContextPath().length());
        StringTokenizer t = new StringTokenizer(uri, "/");
        String servletName = t.nextToken();
        if (!t.hasMoreTokens()) {
            throw new ServletException("Invalid URL: " + uri);
        }
        String controller = t.nextToken();
        if (!t.hasMoreTokens()) {
            throw new ServletException("Invalid URL: " + uri);
        }
        String mode = t.nextToken();
        if (!t.hasMoreTokens()) {
            throw new ServletException("Invalid URL: " + uri);
        }
        String command = t.nextToken();
        ArrayList<String> args = new ArrayList<String>();
        if (t.hasMoreTokens()) {
            args.add(t.nextToken());
        }
        if (MODE_CACHE.equals(mode) && MODE_CACHE_COMMAND_INVALIDATE.equals(command)) {
            CacheUtil.invalidateModelObjectServiceCache(context);
        }
        if (MODE_WEBSCRIPTS.equals(mode) && MODE_WEBSCRIPTS_COMMAND_RESET.equals(command)) {
            this.frameworkUtil.resetWebScripts();
        }
        return null;
    }
}

