/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import jakarta.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkInterceptor;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Configuration;
import org.springframework.extensions.surf.types.Theme;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;

public class ThemeInterceptor
extends AbstractWebFrameworkInterceptor {
    private static Log logger = LogFactory.getLog(ThemeInterceptor.class);
    protected static final String SESSION_CURRENT_THEME = "alfTheme";
    private static final String _THEME_REQUEST_PARAMETER = "theme";
    private WebFrameworkConfigElement webFrameworkConfig;

    public void setWebFrameworkConfig(WebFrameworkConfigElement webFrameworkConfig) {
        this.webFrameworkConfig = webFrameworkConfig;
    }

    public void preHandle(WebRequest webRequest) throws Exception {
        HttpSession session;
        Theme theme = null;
        String themeId = webRequest.getParameter(_THEME_REQUEST_PARAMETER);
        if (themeId != null && (theme = this.getObjectService().getTheme(themeId)) == null) {
            logger.warn((Object)("Unable to locate theme specified as request parameter with ID: " + themeId));
        }
        if (theme == null && (session = ServletUtil.getSession(false)) != null) {
            theme = (Theme)session.getAttribute(SESSION_CURRENT_THEME);
        }
        if (theme == null) {
            Configuration siteConfiguration = ThreadLocalRequestContext.getRequestContext().getSiteConfiguration();
            if (siteConfiguration != null) {
                themeId = siteConfiguration.getProperty(_THEME_REQUEST_PARAMETER);
            }
            if (themeId == null) {
                themeId = this.getDefaultThemeId();
            }
            if (themeId != null && (theme = this.getObjectService().getTheme(themeId)) == null) {
                themeId = this.getDefaultThemeId();
                theme = this.getObjectService().getTheme(themeId);
            }
        }
        if (theme != null) {
            ThreadLocalRequestContext.getRequestContext().setTheme(theme);
        }
    }

    protected String getDefaultThemeId() {
        String themeId = this.webFrameworkConfig.getDefaultThemeId();
        if (themeId == null) {
            themeId = "default";
        }
        return themeId;
    }

    public void postHandle(WebRequest request, ModelMap model) throws Exception {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws Exception {
    }
}

