/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.persister;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelPersistenceContext;
import org.springframework.extensions.surf.cache.ContentCache;
import org.springframework.extensions.surf.persister.AbstractObjectPersister;
import org.springframework.extensions.surf.persister.CachedPersister;
import org.springframework.extensions.surf.util.CacheReport;
import org.springframework.extensions.surf.util.CacheReporter;

public abstract class AbstractCachedObjectPersister
extends AbstractObjectPersister
implements CachedPersister,
CacheReporter {
    private static final Log logger = LogFactory.getLog(AbstractCachedObjectPersister.class);
    protected static final String GLOBAL_STORE_ID_SUFFIX = ":_global";
    protected final Map<String, ContentCache<ModelObject>> caches = new HashMap<String, ContentCache<ModelObject>>(128);
    protected boolean useCache = true;
    protected long cacheDelay = -1L;
    protected int cacheMaxSize = 10240;

    protected abstract ContentCache<ModelObject> getCache(ModelPersistenceContext var1, String var2);

    protected abstract ContentCache<ModelObject> createCache();

    protected void cachePut(ModelPersistenceContext context, ModelObject obj) {
        if (this.useCache) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Put into cache: " + obj.getId()));
            }
            String typeId = obj.getTypeId();
            String objId = obj.getId();
            ContentCache<ModelObject> cache = this.getCache(context, typeId);
            cache.put(objId, obj);
        }
    }

    protected void cacheRemove(ModelPersistenceContext context, ModelObject obj) {
        if (this.useCache) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Remove from cache: " + obj.getId()));
            }
            this.getCache(context, obj.getTypeId()).remove(obj.getId());
        }
    }

    @Override
    public void setCache(boolean useCache) {
        this.useCache = useCache;
    }

    @Override
    public void setCacheCheckDelay(int cacheCheckDelay) {
        this.cacheDelay = (long)cacheCheckDelay * 1000L;
    }

    @Override
    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    @Override
    public synchronized void invalidateCache() {
        for (ContentCache<ModelObject> cache : this.caches.values()) {
            cache.invalidate();
        }
    }

    @Override
    public List<CacheReport> report() {
        ArrayList<CacheReport> reports = new ArrayList<CacheReport>(this.caches.size());
        for (String key : this.caches.keySet()) {
            ContentCache<ModelObject> cache = this.caches.get(key);
            if (!(cache instanceof CacheReporter)) continue;
            List<CacheReport> r = ((CacheReporter)((Object)cache)).report();
            for (CacheReport report : r) {
                reports.add(new CacheReport(key + ":" + report.getCacheName(), report.getEntryCount(), report.getValueSizeEstimate()));
            }
        }
        return reports;
    }

    @Override
    public void clearCaches() {
        this.invalidateCache();
    }
}

