/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.resource;

import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.cache.BasicCache;
import org.springframework.extensions.surf.exception.ResourceLoaderException;
import org.springframework.extensions.surf.resource.AbstractResourceLoader;
import org.springframework.extensions.surf.resource.Resource;

public abstract class AbstractCachingResourceLoader
extends AbstractResourceLoader {
    private BasicCache<Resource> cache = null;
    private long cacheTimeout = 300000L;

    public void setCacheTimeout(long cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public AbstractCachingResourceLoader(String protocolId, String endpointId, FrameworkBean frameworkUtil) {
        super(protocolId, endpointId, frameworkUtil);
    }

    @Override
    public synchronized Resource load(String objectId) throws ResourceLoaderException {
        Resource resource;
        if (this.cache == null) {
            this.cache = new BasicCache(this.cacheTimeout);
        }
        if ((resource = this.cache.get(objectId)) == null) {
            resource = this.buildResource(objectId);
            this.cache.put(objectId, resource);
        }
        return resource;
    }

    public abstract Resource buildResource(String var1) throws ResourceLoaderException;
}

