/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.site;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.types.Configuration;
import org.springframework.extensions.surf.types.Page;

public class SiteUtil {
    private static Log logger = LogFactory.getLog(FrameworkBean.class);
    private static final String DEFAULT_SITE_CONFIGURATION_ID = "default.site.configuration";

    public static Page getRootPage(RequestContext context) {
        return SiteUtil.getRootPage(context, SiteUtil.getSiteConfiguration(context));
    }

    public static Page getRootPage(RequestContext context, Configuration siteConfiguration) {
        Page page;
        String rootPageId;
        Page rootPage = null;
        if (siteConfiguration != null && (rootPageId = siteConfiguration.getProperty("root-page")) != null && (page = context.getObjectService().getPage(rootPageId)) != null) {
            rootPage = page;
        }
        return rootPage;
    }

    public static Configuration getSiteConfiguration(RequestContext context) {
        String siteConfigId = SiteUtil.getConfig().getDefaultSiteConfigurationId();
        Configuration configuration = context.getObjectService().getConfiguration(siteConfigId);
        if (configuration == null) {
            Map<String, ModelObject> configs;
            if (!DEFAULT_SITE_CONFIGURATION_ID.equals(siteConfigId)) {
                siteConfigId = DEFAULT_SITE_CONFIGURATION_ID;
                configuration = context.getObjectService().getConfiguration(siteConfigId);
            }
            if (configuration == null && (configs = context.getObjectService().findConfigurations("site")) != null && configs.size() > 0 && (configuration = (Configuration)configs.values().iterator().next()) != null && logger.isDebugEnabled()) {
                logger.debug((Object)("Site configuration '" + configuration.getId() + "' discovered via exhaustive lookup.  Please adjust configuration files to optimize performance."));
            }
        }
        return configuration;
    }

    protected static WebFrameworkConfigElement getConfig() {
        return FrameworkUtil.getConfig();
    }
}

