/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.site.servlet;

import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import java.util.StringTokenizer;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class BaseServlet
extends HttpServlet {
    public static void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
    }

    public static void setLanguageFromRequestHeader(HttpServletRequest req) {
        String acceptLang = req.getHeader("Accept-Language");
        if (acceptLang != null && acceptLang.length() != 0) {
            StringTokenizer t = new StringTokenizer(acceptLang, ",; ");
            String language = t.nextToken().replace('-', '_');
            I18NUtil.setLocale((Locale)I18NUtil.parseLocale((String)language));
        }
    }
}

