/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.support;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.LinkBuilder;
import org.springframework.extensions.surf.LinkBuilderFactory;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.RequestContextException;
import org.springframework.extensions.surf.extensibility.ExtensibilityModuleHandler;
import org.springframework.extensions.surf.support.AbstractRequestContextFactory;
import org.springframework.extensions.surf.support.ServletLinkBuilderFactory;
import org.springframework.extensions.surf.support.ServletRequestContext;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.handler.DispatcherServletWebRequest;

public class ServletRequestContextFactory
extends AbstractRequestContextFactory {
    private static final String SERVLET_LINKBUILDER_FACTORY_ID = "webframework.factory.linkbuilder.servlet";
    private LinkBuilderFactory linkBuilderFactory = null;
    private ExtensibilityModuleHandler extensibilityModuleHandler = null;
    private DependencyHandler dependencyHandler = null;
    private WebFrameworkConfigElement webFrameworkConfigElement;
    private ConfigService configService;

    public void setLinkBuilderFactory(LinkBuilderFactory linkBuilderFactory) {
        this.linkBuilderFactory = linkBuilderFactory;
    }

    public void setExtensibilityModuleHandler(ExtensibilityModuleHandler extensibilityModuleHandler) {
        this.extensibilityModuleHandler = extensibilityModuleHandler;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public void setWebFrameworkConfigElement(WebFrameworkConfigElement webFrameworkConfigElement) {
        this.webFrameworkConfigElement = webFrameworkConfigElement;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    @Override
    public boolean canHandle(WebRequest webRequest) {
        return webRequest instanceof DispatcherServletWebRequest;
    }

    public LinkBuilder createLinkBuilder() {
        ServletLinkBuilderFactory linkBuilderFactory = (ServletLinkBuilderFactory)this.getApplicationContext().getBean(SERVLET_LINKBUILDER_FACTORY_ID);
        LinkBuilder linkBuilder = linkBuilderFactory.newInstance();
        return linkBuilder;
    }

    @Override
    public RequestContext newInstance(WebRequest webRequest) throws RequestContextException {
        if (!(webRequest instanceof ServletWebRequest)) {
            throw new RequestContextException("ServletRequestContextFactory can only produce RequestContext instances for ServletWebRequest objects.");
        }
        ServletWebRequest dispatcherRequest = (ServletWebRequest)webRequest;
        HttpServletRequest request = dispatcherRequest.getRequest();
        try {
            request.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        LinkBuilder linkBuilder = this.linkBuilderFactory == null ? this.createLinkBuilder() : this.linkBuilderFactory.newInstance();
        ServletRequestContext context = this.buildServletRequestContext(linkBuilder);
        webRequest.setAttribute("requestContext", (Object)context, 0);
        context.method = request.getMethod();
        context.scheme = request.getScheme();
        context.contextPath = request.getContextPath();
        context.setServletContextPath(request.getServletPath());
        context.uri = request.getRequestURI();
        context.setExtensibilityModuleHandler(this.extensibilityModuleHandler);
        context.setDependencyHandler(this.dependencyHandler);
        context.setWebFrameworkConfigElement(this.webFrameworkConfigElement);
        context.setConfigService(this.configService);
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = request.getParameter(parameterName);
            if (parameterValue == null) continue;
            context.parametersMap.put(parameterName, parameterValue);
        }
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            Object attributeValue = request.getAttribute(attributeName);
            if (attributeValue == null || !(attributeValue instanceof Serializable)) continue;
            context.attributesMap.put(attributeName, (Serializable)attributeValue);
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            if (headerValue == null) continue;
            context.headersMap.put(headerName, headerValue);
        }
        return context;
    }

    protected ServletRequestContext buildServletRequestContext(LinkBuilder linkBuilder) {
        return new ServletRequestContext(this.webFrameworkServiceRegistry, this.frameworkUtils, linkBuilder);
    }
}

