/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.util;

import jakarta.el.ELContext;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.el.ExpressionEvaluator;
import jakarta.servlet.jsp.el.VariableResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.extensions.surf.site.RequestUtil;

public class FakeJspPageContext
extends PageContext {
    protected Exception exception;
    protected Map<String, Object> values;
    protected ServletContext context;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected JspWriter out;

    public FakeJspPageContext(ServletContext context, HttpServletRequest request, HttpServletResponse response, JspWriter out) {
        this.context = context;
        this.request = request;
        this.response = response;
        this.out = out;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public ServletConfig getServletConfig() {
        return null;
    }

    public JspWriter getOut() {
        return this.out;
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public Object findAttribute(String name) {
        Object ret = this.getAttribute(name, 1);
        if (ret != null) {
            return ret;
        }
        ret = this.getAttribute(name, 2);
        if (ret != null) {
            return ret;
        }
        ret = this.getAttribute(name, 3);
        if (ret != null) {
            return ret;
        }
        ret = this.getAttribute(name, 4);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    public Object getAttribute(String name) {
        return this.findAttribute(name);
    }

    public Object getAttribute(String name, int scope) {
        switch (scope) {
            case 4: {
                return this.getServletContext().getAttribute(name);
            }
            case 2: {
                Object ret = this.getRequest().getAttribute(name);
                if (ret == null) {
                    ret = this.getRequest().getParameter(name);
                }
                return ret;
            }
            case 3: {
                if (this.getSession() != null) {
                    return this.getSession().getAttribute(name);
                }
                return null;
            }
            case 1: {
                return this.getValue(name);
            }
        }
        return null;
    }

    public void setAttribute(String name, Object obj) {
        this.setValue(name, obj);
    }

    public void setAttribute(String name, Object obj, int scope) {
        switch (scope) {
            case 4: {
                this.getServletContext().setAttribute(name, obj);
                break;
            }
            case 2: {
                this.getRequest().setAttribute(name, obj);
                break;
            }
            case 3: {
                if (this.getSession() == null) break;
                this.getSession().setAttribute(name, obj);
                break;
            }
            case 1: {
                this.setValue(name, obj);
            }
        }
    }

    public void removeAttribute(String name) {
        this.removeValue(name);
    }

    public void removeAttribute(String name, int scope) {
        switch (scope) {
            case 4: {
                this.getServletContext().removeAttribute(name);
                break;
            }
            case 2: {
                this.getRequest().removeAttribute(name);
                break;
            }
            case 3: {
                if (this.getSession() == null) break;
                this.getSession().removeAttribute(name);
                break;
            }
            case 1: {
                this.removeValue(name);
            }
        }
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        switch (scope) {
            case 4: {
                return this.getServletContext().getAttributeNames();
            }
            case 2: {
                return this.getRequest().getAttributeNames();
            }
            case 3: {
                return this.getSession().getAttributeNames();
            }
            case 1: {
                return this.getValueNames();
            }
        }
        return null;
    }

    public int getAttributesScope(String name) {
        if (this.getValue(name) != null) {
            return 1;
        }
        if (this.getRequest().getAttribute(name) != null) {
            return 2;
        }
        if (this.getRequest().getParameter(name) != null) {
            return 2;
        }
        if (this.getSession().getAttribute(name) != null) {
            return 3;
        }
        if (this.getServletContext().getAttribute(name) != null) {
            return 4;
        }
        return 0;
    }

    public void forward(String url) throws ServletException, IOException {
        RequestUtil.forward(this.getServletContext(), this.getRequest(), this.getResponse(), url);
    }

    public void include(String url) throws ServletException, IOException {
        this.include(url, true);
    }

    public void include(String url, boolean b) throws ServletException, IOException {
        RequestUtil.include(this.getServletContext(), this.getRequest(), this.getResponse(), url);
        this.flushOut();
    }

    public void flushOut() throws IOException {
        this.out.flush();
    }

    public void release() {
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return null;
    }

    public VariableResolver getVariableResolver() {
        return null;
    }

    public void handlePageException(Throwable t) {
    }

    public void handlePageException(Exception e) {
        this.exception = e;
    }

    public Exception getException() {
        return this.exception;
    }

    public Object getPage() {
        return null;
    }

    public ELContext getELContext() {
        return null;
    }

    public void initialize(Servlet srv, ServletRequest req, ServletResponse res, String s1, boolean b1, int i1, boolean b2) {
    }

    protected Object getValue(String key) {
        if (this.values == null) {
            this.values = new HashMap<String, Object>();
        }
        return this.values.get(key);
    }

    protected void setValue(String key, Object value) {
        if (this.values == null) {
            this.values = new HashMap<String, Object>();
        }
        this.values.put(key, value);
    }

    protected void removeValue(String key) {
        if (this.values == null) {
            this.values = new HashMap<String, Object>();
        }
        this.values.remove(key);
    }

    protected Enumeration getValueNames() {
        ArrayList<String> array = new ArrayList<String>();
        Iterator<String> it = this.values.keySet().iterator();
        while (it.hasNext()) {
            array.add(it.next());
        }
        return Collections.enumeration(array);
    }
}

