/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.resource.Resource;
import org.springframework.extensions.surf.resource.ResourceService;
import org.springframework.extensions.webscripts.ScriptBase;
import org.springframework.extensions.webscripts.ScriptableMap;

public final class ScriptWebApplication
extends ScriptBase {
    private static final long serialVersionUID = -4449467261985787691L;
    private static Log logger = LogFactory.getLog(ScriptWebApplication.class);

    public ScriptWebApplication(RequestContext context) {
        super(context);
    }

    @Override
    protected ScriptableMap<String, Serializable> buildProperties() {
        return null;
    }

    public String getContext() {
        StringBuilder builder = new StringBuilder(512);
        builder.append(this.context.getContextPath());
        builder.append("/res");
        return builder.toString();
    }

    public String include(String relativePath) {
        String buffer = null;
        try {
            ResourceService resourceService = FrameworkUtil.getServiceRegistry().getResourceService();
            Resource resource = resourceService.getResource(relativePath);
            if (resource != null) {
                buffer = resource.getContent().getStringContent();
            }
            buffer = buffer.replace("${app.context}", this.getContext());
        }
        catch (Exception ex) {
            logger.warn((Object)("Unable to include: " + relativePath), (Throwable)ex);
        }
        return buffer;
    }
}

