/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Path;
import org.springframework.extensions.webscripts.PathImpl;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class IndexAll
extends DeclarativeWebScript {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        String packageFilter = req.getParameter("package") != null ? req.getParameter("package") : "/";
        String urlFilter = req.getParameter("url") != null ? req.getParameter("url") : "/";
        String familyFilter = req.getParameter("family") != null ? req.getParameter("family") : "/";
        String lifecycleFilter = req.getParameter("lifecycle") != null ? req.getParameter("lifecycle") : "/";
        Collection scripts = this.getContainer().getRegistry().getWebScripts();
        ArrayList<WebScript> filteredWebScripts = new ArrayList<WebScript>();
        for (WebScript script : scripts) {
            if (!this.includeWebScript(script, packageFilter, urlFilter, familyFilter)) continue;
            filteredWebScripts.add(script);
        }
        Path rootPackage = this.getContainer().getRegistry().getPackage("/");
        PathImpl filteredPackage = this.filterPath(null, rootPackage, packageFilter, urlFilter, familyFilter);
        HashMap<String, Object> model = new HashMap<String, Object>(7, 1.0f);
        model.put("description", req.getParameter("desc"));
        model.put("webscripts", filteredWebScripts);
        model.put("rootpackage", filteredPackage);
        model.put("packageFilter", packageFilter);
        model.put("urlFilter", urlFilter);
        model.put("familyFilter", familyFilter);
        return model;
    }

    private PathImpl filterPath(PathImpl filteredParent, Path path, String packageFilter, String urlFilter, String familyFilter) {
        PathImpl filteredPath = filteredParent == null ? new PathImpl(path.getPath()) : filteredParent.createChildPath(path.getName());
        for (WebScript webScript : path.getScripts()) {
            if (!this.includeWebScript(webScript, packageFilter, urlFilter, familyFilter)) continue;
            filteredPath.addScript(webScript);
        }
        for (WebScript webScript : path.getChildren()) {
            this.filterPath(filteredPath, (Path)webScript, packageFilter, urlFilter, familyFilter);
        }
        return filteredPath;
    }

    private boolean includeWebScript(WebScript script, String packageFilter, String urlFilter, String familyFilter) {
        String[] uris;
        if (script.getDescription().getPackage() == null || !script.getDescription().getPackage().toString().startsWith(packageFilter)) {
            return false;
        }
        if (!familyFilter.equals("/")) {
            Set familys = script.getDescription().getFamilys();
            if (familys == null || familys.size() == 0) {
                return false;
            }
            if (!familys.contains(familyFilter)) {
                return false;
            }
        }
        for (String uri : uris = script.getDescription().getURIs()) {
            if (uri.startsWith(urlFilter)) continue;
            return false;
        }
        return true;
    }
}

