/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.bean;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class ServiceDescription
extends AbstractWebScript {
    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String scriptId = req.getExtensionPath();
        if (scriptId == null || scriptId.length() == 0) {
            throw new WebScriptException("Web Script Id not provided");
        }
        WebScript script = this.getContainer().getRegistry().getWebScript(scriptId);
        if (script == null) {
            throw new WebScriptException("Web Script Id '" + scriptId + "' not found");
        }
        Description desc = script.getDescription();
        InputStream serviceDescIS = null;
        try {
            serviceDescIS = desc.getDescDocument();
            OutputStream out = res.getOutputStream();
            res.setContentType(Format.XML.mimetype() + ";charset=UTF-8");
            byte[] buffer = new byte[2048];
            int read = serviceDescIS.read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = serviceDescIS.read(buffer);
            }
        }
        catch (IOException e) {
            throw new WebScriptException("Failed to read Web Script description document for '" + scriptId + "'", (Throwable)e);
        }
        finally {
            try {
                if (serviceDescIS != null) {
                    serviceDescIS.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

