/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.junit.Ignore;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.ServerConfigElement;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRuntime;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Ignore
public class TestWebScriptServer
implements ApplicationContextAware,
InitializingBean {
    protected ApplicationContext applicationContext;
    protected ConfigService configService;
    protected RuntimeContainer container;
    protected ServletAuthenticatorFactory authenticatorFactory;
    protected ServerProperties serverProperties;
    protected BufferedReader fIn;
    protected String lastCommand = null;
    protected String username = null;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected MessageSource m_messages;

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public void setContainer(RuntimeContainer container) {
        this.container = container;
    }

    public void setServletAuthenticatorFactory(ServletAuthenticatorFactory authenticatorFactory) {
        this.authenticatorFactory = authenticatorFactory;
    }

    public void setMessages(MessageSource messages) throws IOException {
        this.m_messages = messages;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.username = this.getDefaultUserName();
    }

    protected String getDefaultUserName() {
        return "admin";
    }

    public ServerProperties getServerProperties() {
        if (this.serverProperties == null) {
            Config config = this.configService.getConfig((Object)"Server");
            this.serverProperties = (ServerConfigElement)config.getConfigElement("server");
        }
        return this.serverProperties;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            TestWebScriptServer testServer = TestWebScriptServer.getTestServer();
            testServer.rep();
        }
        catch (Throwable e) {
            StringWriter strWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(strWriter);
            e.printStackTrace(printWriter);
            System.out.println(strWriter.toString());
        }
        finally {
            System.exit(0);
        }
    }

    public static TestWebScriptServer getTestServer() {
        String[] CONFIG_LOCATIONS = new String[]{"classpath:org/springframework/extensions/webscripts/spring-webscripts-application-context.xml", "classpath:org/springframework/extensions/webscripts/spring-webscripts-application-context-test.xml"};
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(CONFIG_LOCATIONS);
        TestWebScriptServer testServer = (TestWebScriptServer)context.getBean("webscripts.test");
        return testServer;
    }

    public Response submitRequest(Request req) throws IOException {
        return this.submitRequest(req.getMethod(), req.getUri(), req.getHeaders(), req.getBody(), req.getEncoding(), req.getType());
    }

    public Response submitRequest(String method, String uri, Map<String, String> headers, byte[] body, String encoding, String contentType) throws IOException {
        MockHttpServletRequest req = this.createMockServletRequest(method, uri);
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                req.addHeader(header.getKey(), (Object)header.getValue());
            }
        }
        if (body != null) {
            req.setContent(body);
        }
        if (encoding != null) {
            req.setCharacterEncoding(encoding);
        }
        if (contentType != null && contentType.length() != 0) {
            req.setContentType(contentType);
            req.addHeader("Content-Type", (Object)contentType);
        }
        MockHttpServletResponse res = new MockHttpServletResponse();
        WebScriptServletRuntime runtime = new WebScriptServletRuntime(this.container, this.authenticatorFactory, (HttpServletRequest)req, (HttpServletResponse)res, this.getServerProperties());
        runtime.executeScript();
        return new MockHttpServletResponseResponse(res);
    }

    private MockHttpServletRequest createMockServletRequest(String method, String uri) throws UnsupportedEncodingException, MalformedURLException {
        URL url = new URL(new URL("http://localhost"), uri);
        Object path = url.getPath();
        if (!((String)path).startsWith("/alfresco/service") && !((String)path).startsWith("/a/s")) {
            path = "/alfresco/service" + (String)path;
        }
        MockHttpServletRequest req = new MockHttpServletRequest(method, uri);
        req.setContextPath("/alfresco");
        req.setServletPath("/service");
        if (uri != null) {
            String queryString = url.getQuery();
            if (queryString != null && queryString.length() > 0) {
                String[] args;
                for (String arg : args = queryString.split("&")) {
                    String[] parts = arg.split("=");
                    req.addParameter(parts[0], parts.length == 2 ? URLDecoder.decode((String)parts[1]) : null);
                }
                req.setQueryString(queryString);
            }
            Object requestURI = path;
            req.setRequestURI((String)requestURI);
        }
        return req;
    }

    public void rep() {
        this.fIn = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("ok> ");
            try {
                String line = this.fIn.readLine();
                if (line == null || line.equals("exit") || line.equals("quit")) {
                    return;
                }
                long startTime = System.nanoTime();
                System.out.print(this.interpretCommand(line));
                System.out.println((float)(System.nanoTime() - startTime) / 1000000.0f + "ms");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.out.println("");
                continue;
            }
            break;
        }
    }

    protected String interpretCommand(String line) throws IOException {
        return this.executeCommand(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String executeCommand(String line) throws IOException {
        String[] command = line.split(" ");
        if (command.length == 0) {
            command = new String[]{line};
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bout);
        if (command[0].equals("r")) {
            if (this.lastCommand == null) {
                return "No command entered yet.";
            }
            if (command.length <= 1 || !command[1].equals("show")) return "repeating command " + this.lastCommand + "\n\n" + this.interpretCommand(this.lastCommand);
            return this.lastCommand + "\n\n";
        }
        this.lastCommand = line;
        if (command[0].equals("help")) {
            String helpFile = this.m_messages.getMessage("testserver.help", null, null);
            ClassPathResource helpResource = new ClassPathResource(helpFile);
            byte[] helpBytes = new byte[500];
            try (InputStream helpStream = helpResource.getInputStream();){
                int read = helpStream.read(helpBytes);
                while (read != -1) {
                    bout.write(helpBytes, 0, read);
                    read = helpStream.read(helpBytes);
                }
            }
        } else if (command[0].equals("user")) {
            if (command.length == 2) {
                this.username = command[1];
            }
            out.println("using user " + this.username);
        } else if (command[0].equals("get") || command[0].equals("delete")) {
            uri = command.length > 1 ? command[1] : null;
            Response res = this.submitRequest(command[0], (String)uri, this.headers, null, null, null);
            bout.write(("Response status: " + res.getStatus()).getBytes());
            out.println();
            bout.write(res.getContentAsByteArray());
            out.println();
        } else if (command[0].equals("post")) {
            uri = command.length > 1 ? command[1] : null;
            String contentType = command.length > 2 ? command[2] : null;
            Object body = "";
            for (int i = 3; i < command.length; ++i) {
                body = (String)body + command[i] + " ";
            }
            Response res = this.submitRequest(command[0], (String)uri, this.headers, ((String)body).getBytes(), null, contentType);
            bout.write(("Response status: " + res.getStatus()).getBytes());
            out.println();
            bout.write(res.getContentAsByteArray());
            out.println();
        } else if (command[0].equals("put")) {
            uri = command.length > 1 ? command[1] : null;
            String contentType = command.length > 2 ? command[2] : null;
            Object body = "";
            for (int i = 3; i < command.length; ++i) {
                body = (String)body + command[i] + " ";
            }
            Response res = this.submitRequest(command[0], (String)uri, this.headers, ((String)body).getBytes(), null, contentType);
            bout.write(("Response status: " + res.getStatus()).getBytes());
            out.println();
            bout.write(res.getContentAsByteArray());
            out.println();
        } else if (command[0].equals("tunnel")) {
            if (command.length < 4) {
                return "Syntax Error.\n";
            }
            if (command[1].equals("param")) {
                uri = command[3];
                uri = ((String)uri).indexOf(63) == -1 ? (String)uri + "?alf:method=" + command[2] : (String)uri + "&alf:method=" + command[2];
                Response res = this.submitRequest("post", (String)uri, this.headers, null, null, null);
                bout.write(res.getContentAsByteArray());
                out.println();
            } else {
                if (!command[1].equals("header")) return "Syntax Error.\n";
                HashMap tunnelheaders = new HashMap();
                tunnelheaders.putAll(this.headers);
                tunnelheaders.put("X-HTTP-Method-Override", command[2]);
                Response res = this.submitRequest("post", command[3], tunnelheaders, null, null, null);
                bout.write(res.getContentAsByteArray());
                out.println();
            }
        } else if (command[0].equals("header")) {
            if (command.length == 1) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    out.println(entry.getKey() + " = " + entry.getValue());
                }
            } else {
                if (command.length != 2) return "Syntax Error.\n";
                String[] param = command[1].split("=");
                if (param.length == 0) {
                    return "Syntax Error.\n";
                }
                if (param.length == 1) {
                    this.headers.remove(param[0]);
                    out.println("deleted header " + param[0]);
                } else {
                    if (param.length != 2) return "Syntax Error.\n";
                    this.headers.put(param[0], param[1]);
                    out.println("set header " + param[0] + " = " + this.headers.get(param[0]));
                }
            }
        } else {
            if (!command[0].equals("reset")) return "Syntax Error.\n";
            this.container.reset();
            out.println("Runtime context '" + this.container.getName() + "' reset.");
        }
        out.flush();
        String retVal = new String(bout.toByteArray());
        out.close();
        return retVal;
    }

    public static class Request {
        private String method;
        private String uri;
        private Map<String, String> args;
        private Map<String, String> headers;
        private byte[] body;
        private String encoding = "UTF-8";
        private String contentType;

        public Request(Request req) {
            this.method = req.method;
            this.uri = req.uri;
            this.args = req.args;
            this.headers = req.headers;
            this.body = req.body;
            this.encoding = req.encoding;
            this.contentType = req.contentType;
        }

        public Request(String method, String uri) {
            this.method = method;
            this.uri = uri;
        }

        public String getMethod() {
            return this.method;
        }

        public String getUri() {
            return this.uri;
        }

        public String getFullUri() {
            Object fullUri;
            Object object = fullUri = this.uri == null ? "" : this.uri;
            if (this.args != null && this.args.size() > 0) {
                int prefix = this.uri.indexOf(63) == -1 ? 63 : 38;
                Iterator<Map.Entry<String, String>> iterator = this.args.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> arg;
                    fullUri = (String)fullUri + (char)prefix + arg.getKey() + "=" + ((arg = iterator.next()).getValue() == null ? "" : arg.getValue());
                    prefix = 38;
                }
            }
            return fullUri;
        }

        public Request setArgs(Map<String, String> args) {
            this.args = args;
            return this;
        }

        public Map<String, String> getArgs() {
            return this.args;
        }

        public Request setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Request setBody(byte[] body) {
            this.body = body;
            return this;
        }

        public byte[] getBody() {
            return this.body;
        }

        public Request setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public Request setType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public String getType() {
            return this.contentType;
        }
    }

    public static interface Response {
        public byte[] getContentAsByteArray();

        public String getContentAsString() throws UnsupportedEncodingException;

        public String getHeader(String var1);

        public String getContentType();

        public int getContentLength();

        public int getStatus();
    }

    public static class MockHttpServletResponseResponse
    implements Response {
        private MockHttpServletResponse res;

        public MockHttpServletResponseResponse(MockHttpServletResponse res) {
            this.res = res;
        }

        @Override
        public byte[] getContentAsByteArray() {
            return this.res.getContentAsByteArray();
        }

        @Override
        public String getContentAsString() throws UnsupportedEncodingException {
            return this.res.getContentAsString();
        }

        @Override
        public String getHeader(String name) {
            return this.res.getHeader(name);
        }

        @Override
        public String getContentType() {
            return this.res.getContentType();
        }

        @Override
        public int getContentLength() {
            return this.res.getContentLength();
        }

        @Override
        public int getStatus() {
            return this.res.getStatus();
        }
    }

    public static class PatchRequest
    extends Request {
        public PatchRequest(String uri, String put, String contentType) throws UnsupportedEncodingException {
            super("patch", uri);
            this.setBody(this.getEncoding() == null ? put.getBytes() : put.getBytes(this.getEncoding()));
            this.setType(contentType);
        }

        public PatchRequest(String uri, byte[] put, String contentType) {
            super("patch", uri);
            this.setBody(put);
            this.setType(contentType);
        }
    }

    public static class DeleteRequest
    extends Request {
        public DeleteRequest(String uri) {
            super("delete", uri);
        }
    }

    public static class PutRequest
    extends Request {
        public PutRequest(String uri, String put, String contentType) throws UnsupportedEncodingException {
            super("put", uri);
            this.setBody(this.getEncoding() == null ? put.getBytes() : put.getBytes(this.getEncoding()));
            this.setType(contentType);
        }

        public PutRequest(String uri, byte[] put, String contentType) {
            super("put", uri);
            this.setBody(put);
            this.setType(contentType);
        }
    }

    public static class PostRequest
    extends Request {
        public PostRequest(String uri, String post, String contentType) throws UnsupportedEncodingException {
            super("post", uri);
            this.setBody(this.getEncoding() == null ? post.getBytes() : post.getBytes(this.getEncoding()));
            this.setType(contentType);
        }

        public PostRequest(String uri, byte[] post, String contentType) {
            super("post", uri);
            this.setBody(post);
            this.setType(contentType);
        }
    }

    public static class GetRequest
    extends Request {
        public GetRequest(String uri) {
            super("get", uri);
        }
    }
}

