/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import junit.framework.TestCase;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class WebScriptExceptionTest
extends TestCase {
    private static final String URL_EXCEPTION = "/test/exception?a=1";
    private static final TestWebScriptServer TEST_SERVER = TestWebScriptServer.getTestServer();

    public void testScriptStatusTemplate() throws Exception {
        String res = "Failed /alfresco/service/test/exception - args 1";
        this.sendRequest(new TestWebScriptServer.GetRequest(URL_EXCEPTION), 500, res);
    }

    private TestWebScriptServer.Response sendRequest(TestWebScriptServer.Request req, int expectedStatus, String expectedResponse) throws IOException {
        System.out.println();
        System.out.println("* Request: " + req.getMethod() + " " + req.getFullUri() + (String)(req.getBody() == null ? "" : "\n" + String.valueOf(req.getBody())));
        TestWebScriptServer.Response res = TEST_SERVER.submitRequest(req);
        System.out.println();
        System.out.println("* Response: " + res.getStatus() + " " + req.getMethod() + " " + req.getFullUri() + "\n" + res.getContentAsString());
        if (expectedStatus > 0) {
            WebScriptExceptionTest.assertEquals((String)"Unexpected status code", (int)expectedStatus, (int)res.getStatus());
        }
        if (expectedResponse != null) {
            WebScriptExceptionTest.assertEquals((String)"Unexpected response", (String)expectedResponse, (String)res.getContentAsString());
        }
        return res;
    }
}

