/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import junit.framework.TestCase;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class WebScriptFormatReaderTest
extends TestCase {
    private static final String URL_REQUESTBODY = "/test/requestbody";
    private static final String URL_JSONECHO = "/test/jsonecho";
    private static final String URL_ENCODEDPOST = "/test/encodedpost";
    private static final String URL_BOGUS = "/test/bogus";
    private static final TestWebScriptServer TEST_SERVER = TestWebScriptServer.getTestServer();

    public void testRequestBody() throws Exception {
        String requestBody = "<html><head>Expected Result</head><body>Hello World</body></html>";
        this.sendRequest(new TestWebScriptServer.PutRequest(URL_REQUESTBODY, requestBody, "text/html"), 200, requestBody);
    }

    public void testJson() throws Exception {
        JSONObject json = new JSONObject();
        json.put("company", (Object)"Alfresco Software Inc.");
        json.put("building", (Object)"Park House");
        json.put("street", (Object)"Park Street");
        json.put("town", (Object)"Maidenhead");
        String postCode = "SL6 1SL";
        json.put("postCode", (Object)postCode);
        json.put("country", (Object)"United Kingdom");
        json.put("year", 2008);
        json.put("valid", true);
        String requestBody = json.toString();
        this.sendRequest(new TestWebScriptServer.PostRequest(URL_JSONECHO, requestBody, "application/json; charset=UTF-8"), 200, postCode);
    }

    public void testBogus() throws Exception {
        String requestBody = "I've got a lovely bunch of coconuts";
        this.sendRequest(new TestWebScriptServer.PostRequest(URL_BOGUS, requestBody, "application/bogus"), 500, null);
    }

    private TestWebScriptServer.Response sendRequest(TestWebScriptServer.Request req, int expectedStatus, String expectedResponse) throws IOException {
        System.out.println();
        System.out.println("* Request: " + req.getMethod() + " " + req.getFullUri() + (String)(req.getBody() == null ? "" : "\n" + String.valueOf(req.getBody())));
        TestWebScriptServer.Response res = TEST_SERVER.submitRequest(req);
        System.out.println();
        System.out.println("* Response: " + res.getStatus() + " " + req.getMethod() + " " + req.getFullUri() + "\n" + res.getContentAsString());
        if (expectedStatus > 0) {
            WebScriptFormatReaderTest.assertEquals((String)"Unexpected status code", (int)expectedStatus, (int)res.getStatus());
        }
        if (expectedResponse != null) {
            WebScriptFormatReaderTest.assertEquals((String)"Unexpected response", (String)expectedResponse, (String)res.getContentAsString());
        }
        return res;
    }
}

