/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.annotation;

import jakarta.servlet.ServletException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.junit.Test;
import org.springframework.extensions.webscripts.AbstractRuntimeContainer;
import org.springframework.extensions.webscripts.AbstractWebScriptServerTest;
import org.springframework.extensions.webscripts.ClassPathStore;
import org.springframework.extensions.webscripts.Registry;
import org.springframework.extensions.webscripts.annotation.ScriptClass;
import org.springframework.extensions.webscripts.annotation.ScriptClassType;
import org.springframework.extensions.webscripts.annotation.ScriptMethod;
import org.springframework.extensions.webscripts.annotation.ScriptMethodType;
import org.springframework.extensions.webscripts.annotation.ScriptParameter;
import org.springframework.extensions.webscripts.annotation.samples.Sample;

public class WebscriptAnnotationTest
extends AbstractWebScriptServerTest {
    @Override
    public void setUp() throws ServletException {
        super.setUp();
        this.getClassPathStore().init();
    }

    @Override
    public ArrayList<String> getConfigLocations() {
        ArrayList<String> list = super.getConfigLocations();
        list.add("classpath:org/springframework/extensions/webscripts/stores/spring-webscripts-stores-context.xml");
        list.add("classpath:org/springframework/extensions/webscripts/annotation/spring-webscripts-annotation-test-context.xml");
        return list;
    }

    public ClassPathStore getClassPathStore() {
        return (ClassPathStore)this.getTestServer().getApplicationContext().getBean("webscripts.store.test");
    }

    public AbstractRuntimeContainer getWebscriptContainer() {
        return (AbstractRuntimeContainer)this.getTestServer().getApplicationContext().getBean("webscripts.container.test");
    }

    public Registry getWebscriptRegistry() {
        return this.getWebscriptContainer().getRegistry();
    }

    @Test
    public void testAnnotatedJavaScriptRootObject() throws Exception {
        Map scriptObjs = this.getWebscriptContainer().getScriptParameters();
        WebscriptAnnotationTest.assertNotNull((Object)scriptObjs);
        Object sampleObj = scriptObjs.get("sample");
        WebscriptAnnotationTest.assertNotNull(sampleObj);
        WebscriptAnnotationTest.assertTrue((boolean)(sampleObj instanceof Sample));
        ScriptClass wsc = sampleObj.getClass().getAnnotation(ScriptClass.class);
        WebscriptAnnotationTest.assertNotNull((Object)wsc);
        WebscriptAnnotationTest.assertNotNull((Object)wsc.help());
        WebscriptAnnotationTest.assertNotNull((Object)wsc.code());
        HashSet<ScriptClassType> types = new HashSet<ScriptClassType>(Arrays.asList(wsc.types()));
        WebscriptAnnotationTest.assertTrue((boolean)types.contains(ScriptClassType.JavaScriptRootObject));
        WebscriptAnnotationTest.assertTrue((boolean)types.contains(ScriptClassType.TemplateRootObject));
        Class[] args = new Class[]{Integer.TYPE};
        Method m = sampleObj.getClass().getMethod("getMessages", args);
        WebscriptAnnotationTest.assertNotNull((Object)m);
        ScriptMethod wsm = m.getAnnotation(ScriptMethod.class);
        WebscriptAnnotationTest.assertNotNull((Object)wsm);
        WebscriptAnnotationTest.assertNotNull((Object)wsm.code());
        WebscriptAnnotationTest.assertNotNull((Object)wsm.help());
        WebscriptAnnotationTest.assertNotNull((Object)wsm.output());
        WebscriptAnnotationTest.assertTrue((boolean)wsm.type().equals((Object)ScriptMethodType.READ));
        Annotation[][] wsps = m.getParameterAnnotations();
        WebscriptAnnotationTest.assertNotNull((Object)wsps);
        Annotation[] wsps1 = wsps[0];
        WebscriptAnnotationTest.assertNotNull((Object)wsps1);
        Annotation wspObj = wsps1[0];
        WebscriptAnnotationTest.assertTrue((boolean)(wspObj instanceof ScriptParameter));
        ScriptParameter wsp = (ScriptParameter)wspObj;
        WebscriptAnnotationTest.assertNotNull((Object)wsp.help());
    }
}

