/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet;

import jakarta.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;
import org.springframework.mock.web.MockHttpServletResponse;

public class WebScriptServletResponseTest {
    @Test
    public void testWebScriptServletResponseReset() {
        MockHttpServletResponse mockedResponse = new MockHttpServletResponse();
        mockedResponse.addHeader("headerA", "valueA");
        WebScriptServletResponse response = new WebScriptServletResponse(null, (HttpServletResponse)mockedResponse);
        TestCase.assertEquals((String)"Mocked response has not headerA", (String)mockedResponse.getHeader("headerA"), (String)"valueA");
        response.reset(null);
        Assert.assertNull((String)"Header headerA should be deleted", (Object)mockedResponse.getHeader("headerA"));
        mockedResponse = new MockHttpServletResponse();
        mockedResponse.addHeader("headerA", "valueA");
        mockedResponse.addHeader("headerB", "valueB");
        mockedResponse.addHeader("headerC", "valueC");
        response = new WebScriptServletResponse(null, (HttpServletResponse)mockedResponse);
        response.reset("headerB");
        Assert.assertNull((String)"Header headerA should be deleted", (Object)mockedResponse.getHeader("headerA"));
        TestCase.assertEquals((String)"Header headerB should be not deleted", (String)"valueB", (String)mockedResponse.getHeader("headerB"));
        Assert.assertNull((String)"Header headerC should be deleted", (Object)mockedResponse.getHeader("headerC"));
        mockedResponse = new MockHttpServletResponse();
        mockedResponse.addHeader("headerA", "valueA");
        mockedResponse.addHeader("Access-Control-.*", "abc");
        mockedResponse.addHeader("Access-Control-Origin", "abcd");
        mockedResponse.addHeader("Access-Controll-Origin", "abcde");
        mockedResponse.addHeader("Access-Control-", "abcdef");
        response = new WebScriptServletResponse(null, (HttpServletResponse)mockedResponse);
        response.reset("Access-Control-.*");
        Assert.assertNull((String)"Header headerA should be deleted", (Object)mockedResponse.getHeader("headerA"));
        Assert.assertNull((String)"Header Access-Controll-Origin should be deleted", (Object)mockedResponse.getHeader("Access-Controll-Origin"));
        TestCase.assertEquals((String)"Header Access-Control-.* should be not deleted", (String)"abc", (String)mockedResponse.getHeader("Access-Control-.*"));
        TestCase.assertEquals((String)"Header Access-Control-Origin should be not deleted", (String)"abcd", (String)mockedResponse.getHeader("Access-Control-Origin"));
        TestCase.assertEquals((String)"Header Access-Control- should be not deleted", (String)"abcdef", (String)mockedResponse.getHeader("Access-Control-"));
    }
}

