/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.ui.common;

import junit.framework.TestCase;
import org.springframework.extensions.webscripts.ui.common.StringUtils;

public class StringUtilsTest
extends TestCase {
    private final String DOCTYPE_HTML = "<!DOCTYPE html>";
    private final String HTML_ELEM = "<html>";
    private final String BODY_ELEM = "<body>";
    private final String ONCLICK_ATTR = "onclick";
    private final String HTML_SNIPPET1 = "<p>a & ab <> c</p>";
    private final String HTML_SNIPPET2 = "<p>a &amp; ab &lt;&gt; c</p>";
    private final String HTML_SNIPPET3 = "<%<script>alert('XSS');//<%</script>";
    private final String HTML_SNIPPET4 = "<style>div { background-image: url('img.jpg'); }</style>";
    private final String HTML_SNIPPET5 = "<TABLE BACKGROUND=\"javascript:alert('XSS')\">";
    private final String HTML_SNIPPET6 = "<META HTTP-EQUIV=\"refresh\" CONTENT=\"0;url=javascript:alert('XSS');\">";
    private final String HTML_SNIPPET7 = "<IFRAME SRC=\"javascript:alert('XSS');\"></IFRAME>";
    private final String HTML_SNIPPET8 = "<STYLE>BODY{-moz-binding:url(\"http://xss.rocks/xssmoz.xml#xss\")}</STYLE>";
    private final String HTML_SNIPPET9 = "<a href=\"http://example.com/attack.html\" style=\"display: block; z-index: 100000; opacity: 0.5; position: fixed; top: 0px; left: 0; width: 1000000px; height: 100000px; background-color: red;\"> </a> ";
    private final String HTML_SNIPPET10 = "<DIV STYLE=\"this-is-js-property: alert 'XSS';\">";
    private final String HTML_SNIPPET11 = "<DIV STYLE=\"background-image: url(javascript:alert('XSS'))\">";
    private final String HTML_SNIPPET12 = "<DIV style=\"width: expression(alert('XSS'));\">";
    private final String HTML_SNIPPET13 = "<table><tbody><tr><td style=\"border:1px solid\">&amp;nbsp;text</td><td>&amp;nbsp;text</td></tr></tbody></table>";
    private final String HTML_SNIPPET14 = "<table><tbody><tr><td style=\"border:1px solid; background-image: url('img.jpg');\">&amp;nbsp;text</td><td>&amp;nbsp;text</td></tr></tbody></table>";
    private final String HTML_SNIPPET15 = "exp/*<A STYLE='no\\xss:noxss(\"*//*\");xss:ex/*XSS*//*/*/pression(alert(\"XSS\"))'>";
    private final String HTML_SNIPPET16 = "<XSS STYLE=\"xss:expression(alert('XSS'))\">";
    private final String HTML_SNIPPET17 = "<IMG style=\"xss:expr/*XSS*/ession(alert('XSS'))\">";
    private final String HTML_SNIPPET18 = "<table border=\"javascript:alert(10)\" cellpading=\"javascript:alert(10)\" cellspacing=\"10\"></table><pre>test</pre><hr />";
    private final String HTML_DOC1 = "<!DOCTYPE>\n<html>\n<body>\n        <p id=\"keep\"><button onclick=alert('CLICK')></p>\n</body>\n</html>";
    private final String HTML_DOC2 = "<html>\n<body>\n        <p id=\"keep\"><button onclick=alert('CLICK')></p>\n</body>\n</html>";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testStripHTML() throws Exception {
        String test1 = StringUtils.stripUnsafeHTMLDocument((String)"<!DOCTYPE>\n<html>\n<body>\n        <p id=\"keep\"><button onclick=alert('CLICK')></p>\n</body>\n</html>", (boolean)false);
        StringUtilsTest.assertTrue((boolean)test1.contains("<!DOCTYPE html>"));
        StringUtilsTest.assertTrue((boolean)test1.contains("<html>"));
        StringUtilsTest.assertTrue((boolean)test1.contains("<body>"));
        StringUtilsTest.assertFalse((boolean)test1.contains("onclick"));
        StringUtilsTest.assertTrue((boolean)test1.contains("id"));
        String test2 = StringUtils.stripUnsafeHTMLDocument((String)"<html>\n<body>\n        <p id=\"keep\"><button onclick=alert('CLICK')></p>\n</body>\n</html>", (boolean)false);
        StringUtilsTest.assertTrue((boolean)test2.contains("<!DOCTYPE html>"));
        StringUtilsTest.assertTrue((boolean)test2.contains("<html>"));
        StringUtilsTest.assertTrue((boolean)test2.contains("<body>"));
        StringUtilsTest.assertFalse((boolean)test2.contains("onclick"));
        StringUtilsTest.assertTrue((boolean)test2.contains("id"));
        String test3 = StringUtils.stripUnsafeHTMLTags((String)"<html>\n<body>\n        <p id=\"keep\"><button onclick=alert('CLICK')></p>\n</body>\n</html>", (boolean)false, (boolean)false);
        StringUtilsTest.assertFalse((boolean)test3.contains("<!DOCTYPE html>"));
        String test4 = StringUtils.stripUnsafeHTMLTags((String)"<p>a & ab <> c</p>");
        StringUtilsTest.assertTrue((boolean)test4.contains("&amp;"));
        StringUtilsTest.assertTrue((boolean)test4.contains("&lt;&gt;"));
        String test5 = StringUtils.stripUnsafeHTMLTags((String)"<p>a & ab <> c</p>", (boolean)false);
        StringUtilsTest.assertTrue((boolean)test5.equals("<p>a & ab <> c</p>"));
        String test6 = StringUtils.stripUnsafeHTMLTags((String)"<p>a &amp; ab &lt;&gt; c</p>");
        StringUtilsTest.assertTrue((boolean)test6.contains("&amp;amp;"));
        StringUtilsTest.assertTrue((boolean)test6.contains("&amp;lt;&amp;gt;"));
        String test7 = StringUtils.stripUnsafeHTMLTags((String)"<p>a &amp; ab &lt;&gt; c</p>", (boolean)false);
        StringUtilsTest.assertTrue((boolean)test7.equals("<p>a &amp; ab &lt;&gt; c</p>"));
        String test8 = StringUtils.stripUnsafeHTMLTags((String)"<%<script>alert('XSS');//<%</script>");
        StringUtilsTest.assertFalse((boolean)test8.contains("script"));
        StringUtilsTest.assertFalse((boolean)test8.contains("alert"));
        String test9 = StringUtils.stripUnsafeHTMLTags((String)"<style>div { background-image: url('img.jpg'); }</style>");
        StringUtilsTest.assertFalse((boolean)test9.contains("style"));
        StringUtilsTest.assertFalse((boolean)test9.contains("background-image"));
        StringUtilsTest.assertFalse((boolean)test9.contains("url"));
        StringUtilsTest.assertFalse((boolean)test9.contains("img.jpg"));
        String test10 = StringUtils.stripUnsafeHTMLTags((String)"<TABLE BACKGROUND=\"javascript:alert('XSS')\">");
        StringUtilsTest.assertFalse((boolean)test10.contains("BACKGROUND"));
        StringUtilsTest.assertFalse((boolean)test10.contains("javascript"));
        StringUtilsTest.assertFalse((boolean)test10.contains("alert"));
        String test11 = StringUtils.stripUnsafeHTMLTags((String)"<META HTTP-EQUIV=\"refresh\" CONTENT=\"0;url=javascript:alert('XSS');\">");
        StringUtilsTest.assertFalse((boolean)test11.contains("CONTENT"));
        StringUtilsTest.assertFalse((boolean)test11.contains("javascript"));
        StringUtilsTest.assertFalse((boolean)test11.contains("alert"));
        String test12 = StringUtils.stripUnsafeHTMLTags((String)"<IFRAME SRC=\"javascript:alert('XSS');\"></IFRAME>");
        StringUtilsTest.assertFalse((boolean)test12.contains("IFRAME"));
        StringUtilsTest.assertFalse((boolean)test12.contains("javascript"));
        StringUtilsTest.assertFalse((boolean)test12.contains("alert"));
        String test13 = StringUtils.stripUnsafeHTMLTags((String)"<table border=\"javascript:alert(10)\" cellpading=\"javascript:alert(10)\" cellspacing=\"10\"></table><pre>test</pre><hr />");
        StringUtilsTest.assertFalse((boolean)test13.contains("border"));
        StringUtilsTest.assertFalse((boolean)test13.contains("cellpading"));
        StringUtilsTest.assertTrue((boolean)test13.contains("cellspacing"));
        StringUtilsTest.assertTrue((boolean)test13.contains("cellspacing"));
        StringUtilsTest.assertTrue((boolean)test13.contains("<pre>"));
        StringUtilsTest.assertTrue((boolean)test13.contains("<hr />"));
    }

    public void testStripHTMLWithStyles() throws Exception {
        String test0 = StringUtils.stripUnsafeHTMLTags((String)"<STYLE>BODY{-moz-binding:url(\"http://xss.rocks/xssmoz.xml#xss\")}</STYLE>");
        StringUtilsTest.assertFalse((boolean)test0.contains("style"));
        StringUtilsTest.assertFalse((boolean)test0.contains("http"));
        StringUtilsTest.assertFalse((boolean)test0.contains("xss"));
        String test1 = StringUtils.stripUnsafeHTMLTags((String)"<a href=\"http://example.com/attack.html\" style=\"display: block; z-index: 100000; opacity: 0.5; position: fixed; top: 0px; left: 0; width: 1000000px; height: 100000px; background-color: red;\"> </a> ");
        StringUtilsTest.assertTrue((boolean)test1.contains("style"));
        String test2 = StringUtils.stripUnsafeHTMLTags((String)"<DIV STYLE=\"this-is-js-property: alert 'XSS';\">");
        StringUtilsTest.assertFalse((boolean)test2.contains("style"));
        StringUtilsTest.assertFalse((boolean)test2.contains("XSS"));
        String test3 = StringUtils.stripUnsafeHTMLTags((String)"<DIV STYLE=\"background-image: url(javascript:alert('XSS'))\">");
        StringUtilsTest.assertFalse((boolean)test3.contains("style"));
        StringUtilsTest.assertFalse((boolean)test3.contains("XSS"));
        StringUtilsTest.assertFalse((boolean)test3.contains("alert"));
        String test4 = StringUtils.stripUnsafeHTMLTags((String)"<DIV style=\"width: expression(alert('XSS'));\">");
        StringUtilsTest.assertFalse((boolean)test4.contains("style"));
        StringUtilsTest.assertFalse((boolean)test4.contains("XSS"));
        StringUtilsTest.assertFalse((boolean)test4.contains("alert"));
        String test5 = StringUtils.stripUnsafeHTMLTags((String)"<table><tbody><tr><td style=\"border:1px solid\">&amp;nbsp;text</td><td>&amp;nbsp;text</td></tr></tbody></table>");
        StringUtilsTest.assertEquals((String)test5, (String)"<table><tbody><tr><td style=\"border:1px solid\">&amp;nbsp;text</td><td>&amp;nbsp;text</td></tr></tbody></table>");
        String test6 = StringUtils.stripUnsafeHTMLTags((String)"<table><tbody><tr><td style=\"border:1px solid; background-image: url('img.jpg');\">&amp;nbsp;text</td><td>&amp;nbsp;text</td></tr></tbody></table>");
        StringUtilsTest.assertFalse((boolean)test6.contains("background-image"));
        StringUtilsTest.assertFalse((boolean)test6.contains("url"));
        StringUtilsTest.assertFalse((boolean)test6.contains("img.jpg"));
        String test7 = StringUtils.stripUnsafeHTMLTags((String)"exp/*<A STYLE='no\\xss:noxss(\"*//*\");xss:ex/*XSS*//*/*/pression(alert(\"XSS\"))'>");
        StringUtilsTest.assertFalse((boolean)test7.contains("<A"));
        StringUtilsTest.assertFalse((boolean)test7.contains("style"));
        StringUtilsTest.assertFalse((boolean)test7.contains("xss"));
        StringUtilsTest.assertFalse((boolean)test7.contains("alert"));
        String test8 = StringUtils.stripUnsafeHTMLTags((String)"<XSS STYLE=\"xss:expression(alert('XSS'))\">");
        StringUtilsTest.assertFalse((boolean)test8.contains("XSS"));
        StringUtilsTest.assertFalse((boolean)test8.contains("style"));
        StringUtilsTest.assertFalse((boolean)test8.contains("expression"));
        StringUtilsTest.assertFalse((boolean)test8.contains("alert"));
        String test9 = StringUtils.stripUnsafeHTMLTags((String)"<IMG style=\"xss:expr/*XSS*/ession(alert('XSS'))\">");
        StringUtilsTest.assertFalse((boolean)test9.contains("style"));
        StringUtilsTest.assertFalse((boolean)test9.contains("xss"));
        StringUtilsTest.assertFalse((boolean)test9.contains("expr"));
        StringUtilsTest.assertFalse((boolean)test9.contains("alert"));
    }
}

