/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExtensibilityDebugData {
    private Map<String, Map<String, Data>> dataMap = new HashMap<String, Map<String, Data>>();

    public void addData(String id, String directive, String path) {
        Data currData;
        Map<String, Data> currDirectiveData = this.dataMap.get(directive);
        if (currDirectiveData == null) {
            currDirectiveData = new HashMap<String, Data>();
            this.dataMap.put(directive, currDirectiveData);
        }
        if ((currData = currDirectiveData.get(id)) == null) {
            currData = new Data(id, directive, path);
            currDirectiveData.put(id, currData);
        } else {
            currData.addPath(path);
        }
    }

    public Set<String> getDirectives() {
        return this.dataMap.keySet();
    }

    public List<Data> getDirectiveData(String directive) {
        ArrayList<Data> data = new ArrayList<Data>();
        Map<String, Data> directiveData = this.dataMap.get(directive);
        if (directiveData != null) {
            data.addAll(directiveData.values());
        }
        return data;
    }

    public class Data {
        private String id = null;
        private String directive = null;
        private List<String> paths;

        private Data(String id, String directive, String path) {
            this.id = id;
            this.directive = directive;
            this.paths = new ArrayList<String>();
            this.paths.add(path);
        }

        public void addPath(String path) {
            this.paths.add(path);
        }

        public String getId() {
            return this.id;
        }

        public String getDirective() {
            return this.directive;
        }

        public List<String> getPaths() {
            return this.paths;
        }
    }
}

