/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ClassUtils;

public class ClassPathStoreResourceResolver
extends PathMatchingResourcePatternResolver {
    private static Log logger = LogFactory.getLog(ClassPathStoreResourceResolver.class);

    public ClassPathStoreResourceResolver(ApplicationContext applicationContext) {
        super((ResourceLoader)applicationContext);
    }

    public Resource getResource(String location) {
        Resource resource = null;
        Object r = super.getResource(location);
        if (r != null && r.exists()) {
            resource = r;
        } else {
            URL resourceUrl = ClassUtils.getDefaultClassLoader().getResource(location);
            if (resourceUrl != null && (r = new UrlInputStreamResource(resourceUrl)).exists()) {
                resource = r;
            }
        }
        return resource;
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        return super.getResources(locationPattern);
    }

    public static class UrlInputStreamResource
    extends UrlResource {
        public UrlInputStreamResource(String path) throws MalformedURLException {
            super(path);
        }

        public UrlInputStreamResource(URI uri) throws MalformedURLException {
            super(uri);
        }

        public UrlInputStreamResource(URL url) {
            super(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean exists() {
            if (!super.exists()) {
                InputStream stream = null;
                try {
                    stream = super.getInputStream();
                    boolean bl = stream != null;
                    return bl;
                }
                catch (IOException e) {
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return true;
        }
    }
}

