/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import freemarker.cache.TemplateLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.extensions.surf.exception.ConnectorProviderException;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.surf.util.Pair;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.AbstractStore;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.ScriptLoader;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.ConnectorProvider;
import org.springframework.extensions.webscripts.connector.ConnectorProviderImpl;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;

public class RemoteStore
extends AbstractStore {
    private static Log logger = LogFactory.getLog(RemoteStore.class);
    public static final String DEFAULT_API = "/remotestore";
    public static final String DEFAULT_ENDPOINT_ID = "alfresco";
    private static final String API_LISTPATTERN = "listpattern";
    private static final String API_LISTALL = "listall";
    private static final String API_GET = "get";
    private static final String API_CREATE = "create";
    private static final String API_CREATE_MULTI = "createmulti";
    private static final String API_DELETE = "delete";
    private static final String API_UPDATE = "update";
    private static final String API_LASTMODIFIED = "lastmodified";
    private static final String API_HAS = "has";
    private ConnectorService connectorService;
    private ConnectorProvider connectorProvider;
    private String storeId;
    private String endpoint;
    private String path;
    private String api;
    private String webappId;
    private String webappPathPrefix;

    public void setConnectorService(ConnectorService service) {
        this.connectorService = service;
    }

    public ConnectorService getConnectorService() {
        return this.connectorService;
    }

    public void setConnectorProvider(ConnectorProvider connectorProvider) {
        this.connectorProvider = connectorProvider;
    }

    public ConnectorProvider getConnectorProvider() {
        return this.connectorProvider;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public String getApi() {
        return this.api;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setWebappId(String webappId) {
        this.webappId = webappId;
    }

    public String getWebappPathPrefix() {
        return this.webappPathPrefix;
    }

    public void setWebappPathPrefix(String webappPathPrefix) {
        this.webappPathPrefix = webappPathPrefix;
    }

    public String getWebappId() {
        String value = this.webappId;
        if (value == null && this.getPreviewContext() != null) {
            value = this.getPreviewContext().getWebappId();
        }
        return value;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getStoreId() {
        String value = this.storeId;
        if (value == null && this.getPreviewContext() != null) {
            value = this.getPreviewContext().getStoreId();
        }
        return value;
    }

    public String getStorePath() {
        Object value = this.path;
        if (this.getStoreId() != null && this.getWebappId() != null && (value = this.getWebappPathPrefix()) != null) {
            if (!((String)value).endsWith("/")) {
                value = (String)value + "/";
            }
            value = this.path.startsWith("/") ? (String)value + this.path.substring(1) : (String)value + this.path;
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public void init() {
        if (this.connectorService == null) {
            throw new IllegalArgumentException("ConnectorService reference is mandatory for RemoteStore.");
        }
        if (this.getEndpoint() == null || this.getEndpoint().length() == 0) {
            throw new IllegalArgumentException("Endpoint ID is mandatory for RemoteStore.");
        }
        if (this.getApi() == null || this.getApi().length() == 0) {
            throw new IllegalArgumentException("API name is mandatory for RemoteStore.");
        }
        if (this.getStorePath() == null) {
            throw new IllegalArgumentException("Path prefix is mandatory for RemoteStore.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RemoteStore initialised with endpoint id '" + this.getEndpoint() + "' API path '" + this.getApi() + "' path prefix '" + this.getStorePath() + "'."));
        }
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean hasDocument(String documentPath) throws IOException {
        boolean hasDocument = false;
        Response res = this.callGet(this.buildEncodeCall(API_HAS, documentPath));
        if (200 != res.getStatus().getCode()) {
            throw new IOException("Unable to test document path: " + documentPath + " in remote store: " + this.getEndpoint() + " due to error: " + res.getStatus().getCode() + " " + res.getStatus().getMessage());
        }
        hasDocument = Boolean.parseBoolean(res.getResponse());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RemoteStore.hasDocument() " + documentPath + " = " + hasDocument));
        }
        return hasDocument;
    }

    @Override
    public long lastModified(String documentPath) throws IOException {
        Response res = this.callGet(this.buildEncodeCall(API_LASTMODIFIED, documentPath));
        if (200 == res.getStatus().getCode()) {
            try {
                long lastMod = Long.parseLong(res.getResponse());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RemoteStore.lastModified() " + documentPath + " = " + lastMod));
                }
                return lastMod;
            }
            catch (NumberFormatException ne) {
                throw new IOException("Failed to process lastModified response: " + ne.getMessage());
            }
        }
        throw new IOException("Unable to get lastModified date of document path: " + documentPath + " in remote store: " + this.getEndpoint() + " due to error: " + res.getStatus().getCode() + " " + res.getStatus().getMessage());
    }

    @Override
    public void updateDocument(String documentPath, String content) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes("UTF-8"));
        Response res = this.callPost(this.buildEncodeCall(API_UPDATE, documentPath), in);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RemoteStore.updateDocument() " + documentPath + " = " + res.getStatus().getCode()));
        }
        if (200 != res.getStatus().getCode()) {
            throw new IOException("Unable to update document path: " + documentPath + " in remote store: " + this.getEndpoint() + " due to error: " + res.getStatus().getCode() + " " + res.getStatus().getMessage());
        }
    }

    @Override
    public boolean removeDocument(String documentPath) throws IOException {
        boolean removed;
        Response res = this.callDelete(this.buildEncodeCall(API_DELETE, documentPath));
        boolean bl = removed = 200 == res.getStatus().getCode();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RemoteStore.removeDocument() " + documentPath + " = " + res.getStatus().getCode() + " (removed = " + removed + ")"));
        }
        return removed;
    }

    @Override
    public void createDocument(String documentPath, String content) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes("UTF-8"));
        Response res = this.callPost(this.buildEncodeCall(API_CREATE, documentPath), in);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RemoteStore.createDocument() " + documentPath + " = " + res.getStatus().getCode()));
        }
        if (200 != res.getStatus().getCode()) {
            throw new IOException("Unable to create document path: " + documentPath + " in remote store: " + this.getEndpoint() + " due to error: " + res.getStatus().getCode() + " " + res.getStatus().getMessage());
        }
    }

    @Override
    public void createDocuments(List<Pair<String, Document>> pathContents) throws IOException {
        Document master = DocumentHelper.createDocument();
        Element docEl = master.addElement("master");
        for (Pair<String, Document> pathContent : pathContents) {
            Element document = docEl.addElement("document");
            String storePath = this.getStorePath();
            document.addAttribute("path", (String)(storePath.equals("/") ? storePath : "/" + storePath) + (String)pathContent.getFirst());
            document.add(((Document)pathContent.getSecond()).getRootElement().createCopy());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setSuppressDeclaration(false);
        XMLWriter xmlWriter = new XMLWriter((OutputStream)out, format);
        xmlWriter.write(master);
        xmlWriter.flush();
        out.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Response res = this.callPost(this.buildEncodeCall(API_CREATE_MULTI, ""), in);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RemoteStore.createDocuments() " + pathContents.size() + " = " + res.getStatus().getCode()));
        }
        if (200 != res.getStatus().getCode()) {
            throw new IOException("Unable to create documents in remote store: " + this.getEndpoint() + " due to error: " + res.getStatus().getCode() + " " + res.getStatus().getMessage());
        }
    }

    @Override
    public InputStream getDocument(String documentPath) throws IOException {
        return this.getDocumentResponse(documentPath).getResponseStream();
    }

    private Response getDocumentResponse(String path) throws IOException {
        Response res = this.callGet(this.buildEncodeCall(API_GET, path));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RemoteStore.getDocument() " + path + " = " + res.getStatus().getCode()));
        }
        if (200 == res.getStatus().getCode()) {
            return res;
        }
        throw new IOException("Unable to retrieve document path: " + path + " in remote store: " + this.getEndpoint() + " due to error: " + res.getStatus().getCode() + " " + res.getStatus().getMessage());
    }

    @Override
    public String[] getAllDocumentPaths() {
        Response res = this.callGet(this.buildEncodeCall(API_LISTALL, ""));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RemoteStore.getAllDocumentPaths() " + res.getStatus().getCode()));
        }
        if (200 == res.getStatus().getCode()) {
            ArrayList<String> list = new ArrayList<String>(128);
            StringTokenizer t = new StringTokenizer(res.getResponse(), "\n");
            while (t.hasMoreTokens()) {
                list.add(t.nextToken());
            }
            String[] paths = list.toArray(new String[list.size()]);
            this.convertToRelativePaths(paths);
            return paths;
        }
        return new String[0];
    }

    @Override
    public String[] getDocumentPaths(String path, boolean includeSubPaths, String documentPattern) {
        String fullPath = path + documentPattern;
        int lastSeparator = fullPath.lastIndexOf(47);
        if (lastSeparator != -1) {
            path = fullPath.substring(0, lastSeparator);
            documentPattern = fullPath.substring(lastSeparator + 1);
        }
        HashMap<String, String> args = new HashMap<String, String>(1, 1.0f);
        args.put("m", documentPattern);
        Response res = this.callGet(this.buildEncodeCall(API_LISTPATTERN, path, args));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RemoteStore.getDocumentPaths() " + path + " subpaths: " + includeSubPaths + " pattern: " + documentPattern + " = " + res.getStatus().getCode() + " " + res.getStatus().getMessage()));
        }
        if (200 == res.getStatus().getCode()) {
            ArrayList<String> list = new ArrayList<String>(128);
            StringTokenizer t = new StringTokenizer(res.getResponse(), "\n");
            while (t.hasMoreTokens()) {
                list.add(t.nextToken());
            }
            String[] paths = list.toArray(new String[list.size()]);
            this.convertToRelativePaths(paths);
            return paths;
        }
        return new String[0];
    }

    @Override
    public String[] getDescriptionDocumentPaths() {
        return this.getDocumentPaths("", true, "*.desc.xml");
    }

    @Override
    public String[] getScriptDocumentPaths(WebScript script) {
        String scriptPaths = script.getDescription().getId() + ".*";
        return this.getDocumentPaths("", false, scriptPaths);
    }

    @Override
    public ScriptLoader getScriptLoader() {
        return new RemoteStoreScriptLoader();
    }

    @Override
    public TemplateLoader getTemplateLoader() {
        return new RemoteStoreTemplateLoader();
    }

    @Override
    public String getBasePath() {
        return this.getStorePath();
    }

    private String buildEncodeCall(String method, String documentPath) {
        return this.buildEncodeCall(method, documentPath, null);
    }

    private String buildEncodeCall(String method, String documentPath, Map<String, String> args) {
        String webappId;
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getApi());
        buf.append('/');
        buf.append(method);
        String fullPath = this.getStorePath() + "/" + documentPath;
        StringTokenizer t = new StringTokenizer(fullPath, "/");
        while (t.hasMoreTokens()) {
            buf.append('/').append(URLEncoder.encode((String)t.nextToken()));
        }
        String storeId = this.getStoreId();
        if (storeId != null) {
            if (args == null) {
                args = new HashMap<String, String>(1, 1.0f);
            }
            args.put("s", storeId);
        }
        if ((webappId = this.getWebappId()) != null) {
            if (args == null) {
                args = new HashMap<String, String>(1, 1.0f);
            }
            args.put("w", webappId);
        }
        if (args != null && args.size() != 0) {
            buf.append('?');
            int count = 0;
            for (Map.Entry<String, String> entry : args.entrySet()) {
                if (count++ != 0) {
                    buf.append('&');
                }
                buf.append(entry.getKey()).append('=').append(URLEncoder.encode((String)entry.getValue()));
            }
        }
        return buf.toString();
    }

    protected String buildUri(String uri) {
        return uri;
    }

    protected Response callPost(String uri, InputStream in) {
        try {
            Connector con = this.getConnector();
            return con.call(this.buildUri(uri), null, in);
        }
        catch (ConnectorProviderException cpe) {
            throw new WebScriptsPlatformException("Unable to find config for remote store.", cpe);
        }
    }

    protected Response callGet(String uri) {
        try {
            Connector con = this.getConnector();
            return con.call(this.buildUri(uri));
        }
        catch (ConnectorProviderException cpe) {
            throw new WebScriptsPlatformException("Unable to find config for remote store.", cpe);
        }
    }

    protected Response callDelete(String uri) {
        try {
            Connector con = this.getConnector();
            ConnectorContext context = new ConnectorContext(HttpMethod.DELETE, null, null);
            return con.call(this.buildUri(uri), context);
        }
        catch (ConnectorProviderException cpe) {
            throw new WebScriptsPlatformException("Unable to find config for remote store.", cpe);
        }
    }

    protected Connector getConnector() throws ConnectorProviderException {
        Connector conn = null;
        if (this.connectorProvider == null) {
            this.connectorProvider = new ConnectorProviderImpl();
        }
        conn = this.getConnectorProvider().provide(this.getEndpoint());
        return conn;
    }

    private void convertToRelativePaths(String[] fullPaths) {
        Object truncationString = "";
        if (this.getStoreId() != null && this.getWebappId() != null) {
            truncationString = "www/avm_webapps/" + this.getWebappId();
            if (this.getStorePath() != null && this.getStorePath().length() > 0) {
                truncationString = (String)truncationString + this.getStorePath();
            }
        }
        if (truncationString != null && ((String)truncationString).length() > 0) {
            for (int i = 0; i < fullPaths.length; ++i) {
                Object fullPath = fullPaths[i];
                int x = ((String)fullPath).indexOf((String)truncationString);
                if (x != -1) {
                    fullPath = ((String)fullPath).substring(x + ((String)truncationString).length());
                }
                if (!((String)fullPath).startsWith("/")) {
                    fullPath = "/" + (String)fullPath;
                }
                fullPaths[i] = fullPath;
            }
        }
    }

    protected class RemoteStoreScriptLoader
    implements ScriptLoader {
        protected RemoteStoreScriptLoader() {
        }

        @Override
        public ScriptContent getScript(String path) {
            RemoteScriptContent sc = null;
            try {
                if (RemoteStore.this.hasDocument(path)) {
                    sc = new RemoteScriptContent(path);
                }
            }
            catch (IOException e) {
                throw new WebScriptException("Error locating script " + path, e);
            }
            return sc;
        }
    }

    private class RemoteStoreTemplateLoader
    implements TemplateLoader {
        private RemoteStoreTemplateLoader() {
        }

        public void closeTemplateSource(Object templateSource) throws IOException {
        }

        public Object findTemplateSource(String name) throws IOException {
            RemoteStoreTemplateSource source = null;
            if (RemoteStore.this.hasDocument(name)) {
                source = new RemoteStoreTemplateSource(name);
            }
            return source;
        }

        public long getLastModified(Object templateSource) {
            return ((RemoteStoreTemplateSource)templateSource).lastModified();
        }

        public Reader getReader(Object templateSource, String encoding) throws IOException {
            return ((RemoteStoreTemplateSource)templateSource).getReader(encoding);
        }
    }

    private class RemoteScriptContent
    implements ScriptContent {
        private String scriptPath;

        private RemoteScriptContent(String path) {
            this.scriptPath = path;
        }

        @Override
        public String getPath() {
            return RemoteStore.this.getStorePath() + "/" + this.scriptPath;
        }

        @Override
        public String getPathDescription() {
            return RemoteStore.this.getStorePath() + "/" + this.scriptPath + " loaded from endpoint: " + RemoteStore.this.getEndpoint();
        }

        @Override
        public InputStream getInputStream() {
            try {
                return RemoteStore.this.getDocumentResponse(this.scriptPath).getResponseStream();
            }
            catch (IOException e) {
                throw new WebScriptsPlatformException("Unable to load script: " + this.scriptPath, e);
            }
        }

        @Override
        public Reader getReader() {
            try {
                Response res = RemoteStore.this.getDocumentResponse(this.scriptPath);
                if (res.getEncoding() != null) {
                    return new InputStreamReader(res.getResponseStream(), res.getEncoding());
                }
                return new InputStreamReader(res.getResponseStream());
            }
            catch (IOException e) {
                throw new WebScriptsPlatformException("Unable to load script: " + this.scriptPath, e);
            }
        }

        @Override
        public boolean isCachable() {
            return false;
        }

        @Override
        public boolean isSecure() {
            return false;
        }
    }

    private class RemoteStoreTemplateSource {
        private String templatePath;

        private RemoteStoreTemplateSource(String path) {
            this.templatePath = path;
        }

        private long lastModified() {
            try {
                return RemoteStore.this.lastModified(this.templatePath);
            }
            catch (IOException e) {
                return -1L;
            }
        }

        private Reader getReader(String encoding) throws IOException {
            Response res = RemoteStore.this.getDocumentResponse(this.templatePath);
            if (encoding == null || encoding.equals(res.getEncoding())) {
                return new StringReader(res.getResponse());
            }
            return new InputStreamReader(res.getResponseStream(), encoding);
        }
    }
}

