/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;
import org.springframework.extensions.webscripts.AbstractBaseDescriptionDocument;
import org.springframework.extensions.webscripts.TypeDescription;

public class SchemaDescriptionDocument
extends AbstractBaseDescriptionDocument {
    public static final String ROOT_ELEMENT_NAME = "schema";
    public static final String DESC_NAME_POSTFIX = "schema-desc.xml";
    public static final String DESC_NAME_PATTERN = "*.schema-desc.xml";
    public ArrayList<TypeDescription> typeDescriptionList = new ArrayList();

    public ArrayList<TypeDescription> getTypeDescriptionList() {
        return this.typeDescriptionList;
    }

    public void setTypeDescriptionList(ArrayList<TypeDescription> typeDescriptionList) {
        this.typeDescriptionList = typeDescriptionList;
    }

    public TypeDescription[] getTypeDescriptions() {
        return this.typeDescriptionList.toArray(new TypeDescription[this.typeDescriptionList.size()]);
    }

    public void setTypeDescriptions(TypeDescription[] typeDescriptions) {
        this.typeDescriptionList = new ArrayList();
        Collections.addAll(this.typeDescriptionList, typeDescriptions);
    }

    public void addTypeDescription(TypeDescription typeDescription) {
        this.typeDescriptionList.add(typeDescription);
    }

    @Override
    public void parse(Element elem) {
        if (this.validateRootElement(elem, ROOT_ELEMENT_NAME)) {
            super.parse(elem);
            TypeDescription[] typeDescriptions = null;
            Element typesElement = elem.element("types");
            if (typesElement != null) {
                List typeElements = typesElement.elements("type");
                typeDescriptions = new TypeDescription[typeElements.size()];
                int iType = 0;
                for (Element typeElement : typeElements) {
                    TypeDescription typeDescription = new TypeDescription();
                    typeDescription.parse(typeElement);
                    String typeDescriptionId = typeDescription.getId();
                    if (typeDescriptionId != null && !typeDescriptionId.startsWith(this.getId())) {
                        typeDescription.setId(this.getId() + "." + typeDescription.getId());
                    }
                    typeDescriptions[iType++] = typeDescription;
                }
            }
            this.setTypeDescriptions(typeDescriptions);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n");
        sb.append("<").append(ROOT_ELEMENT_NAME).append(" ").append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://www.springsurf.org/schemas/DescriptionXMLSchema.xsd\"").append(">").append("\n");
        sb.append("    ").append("<shortname>").append(this.getShortName()).append("</shortname>").append("\n");
        sb.append("    ").append("<description>").append(this.getDescription()).append("</description>").append("\n");
        sb.append("    ").append("<types>").append("\n");
        if (this.getTypeDescriptions() != null) {
            for (TypeDescription td : this.getTypeDescriptions()) {
                sb.append(td.toString()).append("\n");
            }
        }
        sb.append("    ").append("</types>").append("\n");
        sb.append("</").append(ROOT_ELEMENT_NAME).append(">");
        return sb.toString();
    }

    public static SchemaDescriptionDocument newInstance() {
        SchemaDescriptionDocument newSchemaDescriptionDocument = new SchemaDescriptionDocument("id", "shortname", "description");
        return newSchemaDescriptionDocument;
    }

    public SchemaDescriptionDocument(String id, String shortName, String description) {
        super(id, shortName, description);
    }

    public SchemaDescriptionDocument() {
    }
}

