/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import freemarker.ext.dom.NodeModel;
import java.io.StringReader;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.annotation.ScriptClass;
import org.springframework.extensions.webscripts.annotation.ScriptClassType;
import org.springframework.extensions.webscripts.annotation.ScriptMethod;
import org.springframework.extensions.webscripts.annotation.ScriptParameter;
import org.springframework.extensions.webscripts.ui.common.StringUtils;
import org.xml.sax.InputSource;

@ScriptClass(help="Collection of script utility methods for working with strings etc.", code="//JavaScript Sample Code\nmodel.biohtml = stringUtils.replaceLineBreaks(bio);\n\n//Freemarker Template Sample Code\n${stringUtils.stripUnsafeHTML(item.node.content)?substring(0, contentLength)}", types={ScriptClassType.JavaScriptRootObject, ScriptClassType.TemplateRootObject})
public class ScriptableUtils {
    @ScriptMethod(help="Strips encode unsafe HTML tags from the input string", output="Processed string")
    public String stripEncodeUnsafeHTML(@ScriptParameter(help="Input string") String s) {
        return StringUtils.stripUnsafeHTMLTags(s, true);
    }

    @ScriptMethod(help="Strips unsafe HTML tags from the input string", output="Processed string")
    public String stripUnsafeHTML(@ScriptParameter(help="Input string") String s) {
        return StringUtils.stripUnsafeHTMLTags(s, false);
    }

    @ScriptMethod(help="Replaces line breaks in the input string", output="Processed string")
    public String replaceLineBreaks(@ScriptParameter(help="Input string") String s) {
        return StringUtils.replaceLineBreaks(s, true);
    }

    @ScriptMethod(help="Encodes input HTML string", output="Processed string")
    public String encodeHTML(@ScriptParameter(help="Input string") String s) {
        return StringUtils.encode(s);
    }

    @ScriptMethod(help="Encodes input JavaScript string", output="Processed string")
    public String encodeJavaScript(@ScriptParameter(help="Input string") String s) {
        return StringUtils.encodeJavascript(s);
    }

    @ScriptMethod(help="Encodes input string using URLEncoder", output="Processed string")
    public String urlEncode(@ScriptParameter(help="Input string") String s) {
        return URLEncoder.encode((String)s);
    }

    @ScriptMethod(help="Encode input URL string", output="Processed string")
    public String urlEncodeComponent(@ScriptParameter(help="Input string") String s) {
        return URLEncoder.encodeUri((String)s);
    }

    @ScriptMethod(help="Decodes input URL string", output="Processed string")
    public String urlDecode(@ScriptParameter(help="Input string") String s) {
        return URLDecoder.decode((String)s);
    }

    @ScriptMethod(help="Converts an xml string to a freemarker node model", output="Freemarker node model")
    public NodeModel parseXMLNodeModel(@ScriptParameter(help="Input XML string") String xml) {
        try {
            return NodeModel.parse((InputSource)new InputSource(new StringReader(xml)));
        }
        catch (Throwable err) {
            err.printStackTrace();
            return null;
        }
    }
}

