/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorSession;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.RemoteClient;
import org.springframework.extensions.webscripts.connector.Response;

public abstract class AbstractConnector
implements Connector,
ApplicationContextAware {
    private Credentials credentials;
    private ApplicationContext applicationContext;
    protected String endpoint;
    protected RemoteConfigElement.ConnectorDescriptor descriptor;
    protected ConnectorSession connectorSession;
    private static ThreadLocal<RemoteClient> remoteClientBase = new ThreadLocal();

    protected AbstractConnector(RemoteConfigElement.ConnectorDescriptor descriptor, String endpoint) {
        this.descriptor = descriptor;
        this.endpoint = endpoint;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected RemoteClient buildRemoteClient(String endpoint) {
        RemoteClient client = remoteClientBase.get();
        if (client == null) {
            if (this.applicationContext == null) {
                throw new IllegalStateException("Application Context must be set programatically for Connector.");
            }
            client = (RemoteClient)this.applicationContext.getBean("connector.remoteclient");
            if (client == null) {
                throw new IllegalStateException("The 'connector.remoteclient' bean is required by the WebScript framework.");
            }
            remoteClientBase.set(client);
        }
        try {
            client = (RemoteClient)client.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("RemoteClient must support clone() method.");
        }
        client.setEndpoint(endpoint);
        return client;
    }

    @Override
    public Response call(String uri) {
        return this.call(uri, null);
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setConnectorSession(ConnectorSession connectorSession) {
        this.connectorSession = connectorSession;
    }

    @Override
    public ConnectorSession getConnectorSession() {
        return this.connectorSession;
    }

    public String toString() {
        return this.endpoint + (String)(this.credentials != null ? " - " + this.credentials.toString() : "");
    }
}

