/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.annotation.ScriptClass;
import org.springframework.extensions.webscripts.annotation.ScriptClassType;
import org.springframework.extensions.webscripts.annotation.ScriptMethod;
import org.springframework.extensions.webscripts.annotation.ScriptParameter;
import org.springframework.extensions.webscripts.json.JSONWriter;

@ScriptClass(help="Collection of JSON Utility methods.", code="//JavaScript Sample Code\nvar myObj = {'name':'Test Object','size':100};\nvar myObjAsString = jsonUtils.toJSONString(myObj);\n\n//Freemarker Template Sample Code\n[\n    <#list tags as tag>\n        ${jsonUtils.encodeJSONString(tag)}<#if tag_has_next>,</#if>\n    </#list>\n]", types={ScriptClassType.JavaScriptRootObject, ScriptClassType.TemplateRootObject})
public class JSONUtils {
    private static final String TYPE_DATE = "Date";

    @ScriptMethod(help="Converts a given JavaScript native object and converts it to the relevant JSON string.", code="//JavaScript Sample Code\nvar myObj = {'name':'Test Object','size':100};\nvar myObjAsString = jsonUtils.toJSONString(myObj);", output="JSON string")
    public String toJSONString(@ScriptParameter(help="JavaScript object") Object object) throws IOException {
        StringBuilderWriter buffer = new StringBuilderWriter(128);
        this.valueToJSONString(object, new JSONWriter((Writer)buffer));
        return buffer.toString();
    }

    @ScriptMethod(help="Converts the given JavaScript native object to a org.json.simple.JSONObject Java Object.", output="the created org.json.simple.JSONObject Java Object")
    public JSONObject toJSONObject(Object object) throws IOException {
        StringBuilderWriter buffer = new StringBuilderWriter(128);
        this.valueToJSONString(object, new JSONWriter((Writer)buffer));
        return (JSONObject)JSONValue.parse((String)buffer.toString());
    }

    @ScriptMethod(help="Takes a JSON string and converts it to a native java script object or array", code="//JavaScript Sample Code\nmodel.postCode = jsonUtils.toObject(json).postCode;", output="the created native JS object that represents the JSON object or array")
    public ScriptableObject toObject(@ScriptParameter(help="A valid json string") String jsonString) {
        NativeObject result = null;
        Object jsonObject = JSONValue.parse((String)jsonString);
        if (jsonObject != null) {
            if (jsonObject instanceof JSONObject) {
                result = this.toObject((JSONObject)jsonObject);
            } else if (jsonObject instanceof JSONArray) {
                result = this.toObject((JSONArray)jsonObject);
            }
        }
        return result;
    }

    @ScriptMethod(help="Takes a JSON object and converts it to a native java script object", code="//JavaScript Sample Code\nmodel.postCode = jsonUtils.toObject(json).postCode;", output="the created native object")
    public NativeObject toObject(@ScriptParameter(help="The json object") JSONObject jsonObject) {
        NativeObject object = new NativeObject();
        for (Object key : jsonObject.keySet()) {
            Object value = jsonObject.get(key);
            if (value instanceof JSONObject) {
                object.put((String)key, (Scriptable)object, (Object)this.toObject((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                object.put((String)key, (Scriptable)object, (Object)this.toObject((JSONArray)value));
                continue;
            }
            object.put((String)key, (Scriptable)object, value);
        }
        return object;
    }

    @ScriptMethod(help="Takes a JSON object and converts it to a native java script array", code="//JavaScript Sample Code\nmodel.postCode = jsonUtils.toObject(json).postCode;", output="the created native array")
    public NativeArray toObject(@ScriptParameter(help="The json array") JSONArray jsonArray) {
        Object[] array = new Object[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object value = jsonArray.get(i);
            array[i] = value instanceof JSONObject ? this.toObject((JSONObject)value) : (value instanceof JSONArray ? this.toObject((JSONArray)value) : value);
        }
        return new NativeArray(array);
    }

    private void nativeObjectToJSONString(NativeObject nativeObject, JSONWriter writer) throws IOException {
        Object[] ids;
        writer.startObject();
        for (Object id : ids = nativeObject.getIds()) {
            String key = id.toString();
            writer.startValue(key);
            Object value = nativeObject.get(key, (Scriptable)nativeObject);
            this.valueToJSONString(value, writer);
        }
        writer.endObject();
    }

    private void nativeArrayToJSONString(NativeArray nativeArray, JSONWriter writer) throws IOException {
        Object[] propIds = nativeArray.getIds();
        if (this.isArray(propIds)) {
            writer.startArray();
            for (int i = 0; i < propIds.length; ++i) {
                Object propId = propIds[i];
                Object value = nativeArray.get(((Integer)propId).intValue(), (Scriptable)nativeArray);
                this.valueToJSONString(value, writer);
            }
            writer.endArray();
        } else {
            writer.startObject();
            for (Object propId : propIds) {
                Object value = nativeArray.get(propId.toString(), (Scriptable)nativeArray);
                writer.startValue(propId.toString());
                this.valueToJSONString(value, writer);
            }
            writer.endObject();
        }
    }

    private boolean isArray(Object[] ids) {
        boolean result = true;
        for (Object id : ids) {
            if (id instanceof Integer) continue;
            result = false;
            break;
        }
        return result;
    }

    private void valueToJSONString(Object value, JSONWriter writer) throws IOException {
        if (value instanceof IdScriptableObject && TYPE_DATE.equals(((IdScriptableObject)value).getClassName())) {
            Date date = (Date)Context.jsToJava((Object)value, Date.class);
            writer.startObject().writeValue("zone", "UTC").writeValue("year", date.getYear()).writeValue("month", date.getMonth()).writeValue("date", date.getDate()).writeValue("hours", date.getHours()).writeValue("minutes", date.getMinutes()).writeValue("seconds", date.getSeconds()).writeValue("milliseconds", date.getTime()).endObject();
        } else if (value instanceof NativeJavaObject) {
            Object javaValue = Context.jsToJava((Object)value, Object.class);
            this.valueToJSONString(javaValue, writer);
        } else if (value instanceof NativeArray) {
            this.nativeArrayToJSONString((NativeArray)value, writer);
        } else if (value instanceof NativeObject) {
            this.nativeObjectToJSONString((NativeObject)value, writer);
        } else if (value instanceof Number) {
            if (value instanceof Integer || value instanceof Long) {
                writer.writeValue(((Number)value).longValue());
            } else if (value instanceof Double) {
                writer.writeValue(((Number)value).doubleValue());
            } else if (value instanceof Float) {
                writer.writeValue(((Number)value).floatValue());
            } else {
                writer.writeValue(((Number)value).doubleValue());
            }
        } else if (value instanceof Boolean) {
            writer.writeValue((Boolean)value);
        } else if (value instanceof Map) {
            writer.startObject();
            for (Object key : ((Map)value).keySet()) {
                writer.startValue(key.toString());
                this.valueToJSONString(((Map)value).get(key), writer);
                writer.endValue();
            }
            writer.endObject();
        } else if (value instanceof List) {
            writer.startArray();
            for (Object val : (List)value) {
                this.valueToJSONString(val, writer);
            }
            writer.endArray();
        } else if (value != null) {
            writer.writeValue(value.toString());
        } else {
            writer.writeNullValue();
        }
    }

    @ScriptMethod(help="Encodes a JSON string value", output="Encoded value")
    public Object encodeJSONString(@ScriptParameter(help="Value to encode") Object value) {
        if (value instanceof String) {
            return JSONWriter.encodeJSONString((String)value);
        }
        return value;
    }
}

