/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.processor;

import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.extensions.surf.core.processor.ProcessorExtension;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.Store;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.extensions.webscripts.processor.BaseRegisterableTemplateProcessor;

public abstract class AbstractTemplateProcessor
extends BaseRegisterableTemplateProcessor
implements ApplicationContextAware,
TemplateProcessor {
    private static Log logger = LogFactory.getLog(AbstractTemplateProcessor.class);
    private ApplicationContext applicationContext;
    private SearchPath searchPath;
    private List<TemplateLoader> loaders = new ArrayList<TemplateLoader>();
    private TemplateLoader templateLoader;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setSearchPath(SearchPath searchPath) {
        this.searchPath = searchPath;
    }

    protected TemplateLoader getTemplateLoader() {
        return this.templateLoader;
    }

    protected SearchPath getSearchPath() {
        return this.searchPath;
    }

    protected void initLoaders() {
        if (this.searchPath != null) {
            for (Store apiStore : this.searchPath.getStores()) {
                TemplateLoader loader = apiStore.getTemplateLoader();
                if (loader == null) {
                    logger.error((Object)("Unable to retrieve template loader for Web Script store " + apiStore.getBasePath()));
                }
                this.loaders.add(loader);
            }
        }
        this.templateLoader = new MultiTemplateLoader(this.loaders.toArray(new TemplateLoader[this.loaders.size()]));
    }

    protected void addProcessorModelExtensions(Object model) {
        if (model == null) {
            model = new HashMap();
        }
        if (model instanceof Map) {
            for (ProcessorExtension ex : this.processorExtensions.values()) {
                ((Map)model).put(ex.getExtensionName(), ex);
            }
        }
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        ContextRefreshedEvent refreshEvent;
        ApplicationContext refreshContext;
        if (event instanceof ContextRefreshedEvent && (refreshContext = (refreshEvent = (ContextRefreshedEvent)event).getApplicationContext()) != null && refreshContext.equals(this.applicationContext)) {
            this.init();
            this.register();
        }
    }

    @Override
    public void init() {
        this.initLoaders();
    }

    @Override
    public void register() {
        this.getTemplateProcessorRegistry().registerTemplateProcessor(this);
    }
}

