/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaFileCleaner;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.surf.util.InputStreamContent;
import org.springframework.extensions.webscripts.WebScriptException;

public class FormData
implements Serializable {
    private static final long serialVersionUID = 1832644544828452385L;
    private static Log logger = LogFactory.getLog(FormData.class);
    private HttpServletRequest req;
    private Charset encoding = null;
    private JakartaServletFileUpload upload;
    private FormField[] fields = null;
    private Map<String, String[]> parameters = null;

    public FormData(HttpServletRequest req) {
        this.req = req;
    }

    public boolean getIsMultiPart() {
        return JakartaServletFileUpload.isMultipartContent((HttpServletRequest)this.req);
    }

    public boolean hasField(String name) {
        for (FormField field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public FormField[] getFields() {
        if (this.fields == null) {
            FileItemFactory factory = this.getFileItemFactory();
            this.upload = new JakartaServletFileUpload(factory);
            this.encoding = this.getRequestCharsetEncoding();
            this.upload.setHeaderCharset(this.encoding);
            try {
                List fileItems = this.upload.parseRequest(this.req);
                this.fields = new FormField[fileItems.size()];
                for (int i = 0; i < fileItems.size(); ++i) {
                    FormField formField;
                    this.fields[i] = formField = new FormField((FileItem)fileItems.get(i));
                }
            }
            catch (FileUploadException e) {
                if (e.getMessage().contains("no multipart boundary was found")) {
                    throw new WebScriptException(415, e.getMessage(), e);
                }
                throw new WebScriptException(507, e.getMessage(), e);
            }
        }
        return this.fields;
    }

    private FileItemFactory getFileItemFactory() {
        FileCleaningTracker fileCleaningTracker = JakartaFileCleaner.getFileCleaningTracker((ServletContext)this.req.getServletContext());
        return DiskFileItemFactory.builder().setFileCleaningTracker(fileCleaningTracker).get();
    }

    private Charset getRequestCharsetEncoding() {
        String enc = this.req.getCharacterEncoding();
        if (enc == null || enc.isBlank()) {
            return null;
        }
        try {
            return Charset.forName(enc);
        }
        catch (UnsupportedCharsetException e) {
            logger.warn((Object)("Failed to obtain request encoding for `" + enc + "`."));
            return null;
        }
    }

    public void cleanup() {
        if (this.fields == null) {
            return;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].cleanup();
        }
    }

    public Map<String, String[]> getParameters() {
        if (this.parameters == null) {
            FormField[] fields = null;
            try {
                fields = this.getFields();
            }
            catch (WebScriptException e) {
                fields = new FormField[]{};
            }
            this.parameters = new HashMap<String, String[]>(fields.length);
            for (FormField field : fields) {
                String[] vals = this.parameters.get(field.getName());
                if (vals == null) {
                    this.parameters.put(field.getName(), new String[]{field.getValue()});
                    continue;
                }
                String[] valsNew = new String[vals.length + 1];
                System.arraycopy(vals, 0, valsNew, 0, vals.length);
                valsNew[vals.length] = field.getValue();
                this.parameters.put(field.getName(), valsNew);
            }
        }
        return this.parameters;
    }

    public class FormField
    implements Serializable {
        private static final long serialVersionUID = -6061565518843862346L;
        private FileItem file;

        public FormField(FileItem file) {
            this.file = file;
        }

        public String getName() {
            return this.file.getFieldName();
        }

        public boolean getIsFile() {
            return !this.file.isFormField();
        }

        public String getValue() {
            try {
                String value = this.file.isFormField() ? (FormData.this.encoding != null ? this.file.getString(FormData.this.encoding) : this.file.getString()) : this.file.getName();
                return value;
            }
            catch (IOException e) {
                throw new WebScriptsPlatformException("Unable to decode form field", e);
            }
        }

        public Content getContent() {
            try {
                return new InputStreamContent(this.file.getInputStream(), this.getMimetype(), null);
            }
            catch (IOException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Failed to get content: " + e.getMessage()));
                }
                return null;
            }
        }

        public InputStream getInputStream() {
            try {
                return this.file.getInputStream();
            }
            catch (IOException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Failed to get input stream: " + e.getMessage()));
                }
                return null;
            }
        }

        public String getMimetype() {
            return this.file.getContentType();
        }

        public String getFilename() {
            return FilenameUtils.getName((String)this.file.getName());
        }

        public void cleanup() {
            if (this.getIsFile()) {
                try {
                    this.file.delete();
                }
                catch (IOException e) {
                    throw new WebScriptsPlatformException("Unable to cleanup form field", e);
                }
            }
        }
    }
}

