/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import jakarta.mail.FolderNotFoundException;
import jakarta.mail.MessagingException;
import org.alfresco.email.EmailTest;
import org.alfresco.email.ImapWrapper;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ImapSitesTests
extends EmailTest {
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can unsubscribe from a folder")
    @Test(groups={"protocols", "imap", "core"})
    public void siteManagerCanUnSubscribeFromAFolder() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).assertThat().isSubscribed().usingResource((ContentModel)this.testFolder).assertThat().isSubscribed().unsubscribe().assertThat().isNotSubscribed().usingSite(this.testSite).assertThat().isSubscribed();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager is subscribed to folders created by self")
    @Test(groups={"protocols", "imap", "core"})
    public void siteManagerIsSubscribedToFoldersCreatedBySelf() throws Exception {
        this.testFolder = new FolderModel("newFolder");
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).assertThat().isSubscribed().createFolder(this.testFolder).assertThat().existsInRepo()).assertThat().existsInImap().assertThat().isSubscribed();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that operations on a private site are not permitted")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={MessagingException.class}, expectedExceptionsMessageRegExp=".* Access Denied.*You do not have the appropriate permissions to perform this operation.*")
    public void verifyOperationsOnPrivateSiteAreNotPermitted() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.adminSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.testFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(this.adminSite)).createFolder();
        ((DataSite)((DataSite)this.dataSite.usingUser(this.testUser)).usingSite(this.testSite)).setIMAPFavorite();
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.adminSite).assertThat().contains(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that operations on a moderated site are not permitted")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={FolderNotFoundException.class})
    public void verifyOperationsOnModeratedSiteAreNotPermitted() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.adminSite = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        this.testFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(this.adminSite)).createFolder();
        ((DataSite)((DataSite)this.dataSite.usingUser(this.testUser)).usingSite(this.testSite)).setIMAPFavorite();
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.adminSite).assertThat().contains(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify site cannot be accessed in IMAP client if it is no longer an IMAP site or marked as IMAP favorite")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={FolderNotFoundException.class})
    public void userCannotAccessSiteThatIsNoLongerAnImapSiteOrMarkedAsImapFavorite() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).assertThat().contains(new FolderModel[]{this.testFolder});
        ((DataSite)((DataSite)this.dataSite.usingUser(this.testUser)).usingSite(this.testSite)).unsetIMAPFavorite();
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).assertThat().contains(new FolderModel[]{this.testFolder});
    }
}

