/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import jakarta.mail.FolderNotFoundException;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.email.EmailTest;
import org.alfresco.email.ImapWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ImapDeleteFolderTests
extends EmailTest {
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.testUser = this.dataUser.createRandomTestUser();
        this.adminSite = ((DataSite)this.dataSite.usingAdmin()).createIMAPSite();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify admin can delete folder")
    @Test(groups={"protocols", "imap", "sanity"})
    public void adminShouldDeleteFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.adminUser).usingSite(this.adminSite).createFolder(this.testFolder).assertThat().existsInRepo()).assertThat().existsInImap().delete().assertThat().doesNotExistInRepo()).usingSite(this.adminSite).assertThat().doesNotContain(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify site Manager can delete a folder with a message(file)")
    @Test(groups={"protocols", "imap", "sanity"})
    public void siteManagerShouldDeleteNonEmptyFolder() throws Exception {
        UserModel user = this.dataUser.createRandomTestUser();
        SiteModel site = ((DataSite)this.dataSite.usingUser(user)).createIMAPSite();
        FolderModel folder = FolderModel.getRandomFolderModel();
        this.imapProtocol.authenticateUser(user).usingSite(site).createFolder(folder).assertThat().existsInImap().assertThat().existsInRepo();
        ((DataContent)((DataContent)this.dataContent.usingUser(user).usingSite(site)).usingResource((ContentModel)folder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)this.imapProtocol.usingSite(site).usingResource((ContentModel)folder).assertThat().countMessagesIs(1).delete().assertThat().doesNotExistInRepo()).usingSite(site).assertThat().doesNotContain(new FolderModel[]{folder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can delete a empty folder")
    @Test(groups={"protocols", "imap", "core"})
    public void siteManagerShouldDeleteFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInRepo()).assertThat().existsInImap().delete().assertThat().doesNotExistInRepo()).usingSite(this.testSite).assertThat().doesNotContain(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can delete a folder that contains collaborator user messages")
    @Test(groups={"protocols", "imap", "core"}, enabled=false)
    public void siteManagerShouldDeleteFolderWithCollaboratorMessages() throws Exception {
        UserModel collaboratorUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(collaboratorUser, this.testSite, UserRole.SiteCollaborator);
        this.testFolder = FolderModel.getRandomFolderModel();
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInImap().assertThat().existsInRepo();
        this.testFile = ((DataContent)this.dataContent.usingUser(collaboratorUser).usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)this.imapProtocol.usingSite(this.testSite).usingResource((ContentModel)this.testFolder).assertThat().countMessagesIs(1).delete().assertThat().doesNotExistInRepo()).usingSite(this.testSite).assertThat().doesNotContain(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can delete a folder that contains contributor user messages")
    @Test(groups={"protocols", "imap", "core"}, enabled=false)
    public void siteManagerShouldDeleteFolderWithContributorMessages() throws Exception {
        UserModel contributorUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(contributorUser, this.testSite, UserRole.SiteContributor);
        this.testFolder = FolderModel.getRandomFolderModel();
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInImap().assertThat().existsInRepo();
        ((DataContent)((DataContent)this.dataContent.usingUser(contributorUser).usingSite(this.testSite)).usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)this.imapProtocol.usingSite(this.testSite).usingResource((ContentModel)this.testFolder).assertThat().countMessagesIs(1).delete().assertThat().doesNotExistInRepo()).usingSite(this.testSite).assertThat().doesNotContain(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that an unauthorized user can not delete folder")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={FolderNotFoundException.class})
    public void unauthorizedUserShouldNotDeleteFolder() throws Exception {
        UserModel unauthorizedUser = this.dataUser.createRandomTestUser();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        this.imapProtocol.authenticateUser(unauthorizedUser).usingResource((ContentModel)this.testFolder).delete();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can delete a folder that contains consumer user messages")
    @Test(groups={"protocols", "imap", "full"})
    public void siteManagerShouldDeleteFolderWithConsumerMessages() throws Exception {
        UserModel consumerUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(consumerUser, this.testSite, UserRole.SiteContributor);
        this.testFolder = FolderModel.getRandomFolderModel();
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInImap().assertThat().existsInRepo();
        ((DataContent)((DataContent)this.dataContent.usingUser(consumerUser).usingSite(this.testSite)).usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataUser)this.dataUser.usingUser(this.testUser)).removeUserFromSite(consumerUser, this.testSite);
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(consumerUser, this.testSite, UserRole.SiteConsumer);
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).assertThat().countMessagesIs(1).delete().assertThat().doesNotExistInRepo()).usingSite(this.testSite).assertThat().doesNotContain(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot delete folder that no longer exists")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={FolderNotFoundException.class})
    public void userCannotDeleteFolderThatNoLongerExists() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInImap().assertThat().existsInRepo()).delete().assertThat().doesNotExistInRepo()).usingSite(this.testSite).assertThat().doesNotContain(new FolderModel[]{this.testFolder}).usingResource((ContentModel)this.testFolder).delete();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify deleting folder that contains messages by COLLABORATOR user")
    @Test(groups={"protocols", "imap", "full"})
    public void collaboratorTriesToDeleteFolderContainingMessagesByCollaborator() throws Exception {
        UserModel collaboratorUser1 = this.dataUser.createRandomTestUser();
        UserModel collaboratorUser2 = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(collaboratorUser1, this.testSite, UserRole.SiteCollaborator);
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(collaboratorUser2, this.testSite, UserRole.SiteCollaborator);
        this.testFolder = FolderModel.getRandomFolderModel();
        ((DataSite)((DataSite)this.dataSite.usingUser(collaboratorUser1)).usingSite(this.testSite)).setIMAPFavorite();
        ((ImapWrapper)this.imapProtocol.authenticateUser(collaboratorUser1).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInImap().assertThat().existsInRepo()).disconnect();
        this.testFile = ((DataContent)((DataContent)this.dataContent.usingUser(collaboratorUser1).usingSite(this.testSite)).usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataSite)((DataSite)this.dataSite.usingUser(collaboratorUser2)).usingSite(this.testSite)).setIMAPFavorite();
        ((ImapWrapper)this.imapProtocol.authenticateUser(collaboratorUser2).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).delete().assertThat().existsInRepo()).usingSite(this.testSite).assertThat().contains(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify deleting folder that contains messages by CONTRIBUTOR user")
    @Test(groups={"protocols", "imap", "full"})
    public void contributorTriesToDeleteFolderContainingMessagesByContributor() throws Exception {
        UserModel contributorUser1 = this.dataUser.createRandomTestUser();
        UserModel contributorUser2 = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(contributorUser1, this.testSite, UserRole.SiteContributor);
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(contributorUser2, this.testSite, UserRole.SiteContributor);
        this.testFolder = FolderModel.getRandomFolderModel();
        ((DataSite)((DataSite)this.dataSite.usingUser(contributorUser1)).usingSite(this.testSite)).setIMAPFavorite();
        ((ImapWrapper)this.imapProtocol.authenticateUser(contributorUser1).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInImap().assertThat().existsInRepo()).disconnect();
        this.testFile = ((DataContent)((DataContent)this.dataContent.usingUser(contributorUser1).usingSite(this.testSite)).usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataSite)((DataSite)this.dataSite.usingUser(contributorUser2)).usingSite(this.testSite)).setIMAPFavorite();
        ((ImapWrapper)this.imapProtocol.authenticateUser(contributorUser2).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).delete().assertThat().existsInRepo()).usingSite(this.testSite).assertThat().contains(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify deleting folder that contains messages by CONSUMER user")
    @Test(groups={"protocols", "imap", "full"})
    public void consumerTriesToDeleteFolderContainingMessagesByConsumer() throws Exception {
        UserModel consumerUser1 = this.dataUser.createRandomTestUser();
        UserModel consumerUser2 = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(consumerUser1, this.testSite, UserRole.SiteCollaborator);
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(consumerUser2, this.testSite, UserRole.SiteConsumer);
        this.testFolder = FolderModel.getRandomFolderModel();
        ((DataSite)((DataSite)this.dataSite.usingUser(consumerUser1)).usingSite(this.testSite)).setIMAPFavorite();
        ((ImapWrapper)this.imapProtocol.authenticateUser(consumerUser1).usingSite(this.testSite).createFolder(this.testFolder).assertThat().existsInImap().assertThat().existsInRepo()).disconnect();
        this.testFile = ((DataContent)((DataContent)this.dataContent.usingUser(consumerUser1).usingSite(this.testSite)).usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataUser)this.dataUser.usingUser(this.testUser)).removeUserFromSite(consumerUser1, this.testSite);
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(consumerUser1, this.testSite, UserRole.SiteConsumer);
        ((DataSite)((DataSite)this.dataSite.usingUser(consumerUser2)).usingSite(this.testSite)).setIMAPFavorite();
        ((ImapWrapper)this.imapProtocol.authenticateUser(consumerUser2).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).delete().assertThat().existsInRepo()).usingSite(this.testSite).assertThat().contains(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify delete folder from a location where you don't have permission")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={FolderNotFoundException.class})
    public void userTriesToDeleteFolderFromALocationToWhichHeDoesNotHavePermissionToDelete() throws Exception {
        UserModel userModel = this.dataUser.createRandomTestUser();
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createIMAPSite();
        this.testFolder = FolderModel.getRandomFolderModel();
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.dataUser.getAdminUser()).usingSite(privateSite).createFolder(this.testFolder).assertThat().existsInImap().assertThat().existsInRepo()).disconnect();
        ((DataSite)((DataSite)this.dataSite.usingUser(userModel)).usingSite(privateSite)).setIMAPFavorite();
        this.imapProtocol.authenticateUser(userModel).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).delete();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify admin cannot delete a open folder")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="This operation is not allowed on an open folder")
    public void adminTriesToDeleteOpenFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.adminUser).usingSite(this.adminSite).createFolder(this.testFolder).assertThat().existsInRepo()).assertThat().existsInImap().attemptToDeleteOpenFolder();
    }
}

