/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email;

import java.lang.reflect.Method;
import org.alfresco.email.EmailProperties;
import org.alfresco.email.ImapWrapper;
import org.alfresco.email.SmtpWrapper;
import org.alfresco.email.dsl.JmxUtil;
import org.alfresco.email.dsl.ServerConfiguration;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.data.DataCalendarEvent;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataGroup;
import org.alfresco.utility.data.DataLink;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.DataWiki;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.network.ServerHealth;
import org.alfresco.utility.network.TenantConsole;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

@ContextConfiguration(value={"classpath:alfresco-email-context.xml"})
public abstract class EmailTest
extends AbstractTestNGSpringContextTests {
    private static Logger LOG = LogFactory.getLogger();
    @Autowired
    protected EmailProperties emailProperties;
    @Autowired
    ServerHealth serverHealth;
    @Autowired
    protected ImapWrapper imapProtocol;
    @Autowired
    protected SmtpWrapper smtpProtocol;
    @Autowired
    public DataUser dataUser;
    @Autowired
    public DataGroup dataGroup;
    @Autowired
    public DataSite dataSite;
    @Autowired
    public DataContent dataContent;
    @Autowired
    public DataLink dataLink;
    @Autowired
    public DataCalendarEvent dataCalendarEvent;
    @Autowired
    public DataWiki dataWiki;
    @Autowired
    public TenantConsole tenantConsole;
    protected UserModel adminUser;
    protected UserModel testUser;
    protected SiteModel adminSite;
    protected SiteModel testSite;
    protected FolderModel testFolder;
    protected FileModel testFile;
    protected ContentModel contentModel;

    @BeforeSuite(alwaysRun=true)
    public void checkServerHealth() throws Exception {
        super.springTestContextPrepareTestInstance();
        this.serverHealth.assertServerIsOnline();
        UserModel anonymousUser = new UserModel("anonymous", DataUser.PASSWORD);
        if (!this.dataUser.isUserInRepo(anonymousUser.getUsername())) {
            this.dataUser.createUser(anonymousUser);
            ((DataGroup)this.dataGroup.usingUser(anonymousUser)).addUserToGroup(GroupModel.getEmailContributorsGroup());
        }
        if (this.emailProperties.getUseJolokiaAgent()) {
            this.imapProtocol.assertThat().protocolIsEnabled();
            this.smtpProtocol.assertThat().protocolIsEnabled();
            ServerConfiguration.save((JmxUtil)this.smtpProtocol.withJMX(), (EmailProperties)this.smtpProtocol.emailProperties);
        } else {
            LOG.warn("*** Jolokia is not used! To use jolokia, please add next system property when running the tests: jmx.useJolokiaAgent=true ***");
        }
    }

    @BeforeMethod(alwaysRun=true)
    public void showStartTestInfo(Method method) {
        LOG.info(String.format("*** STARTING Test: [%s] ***", method.getName()));
    }

    @AfterMethod(alwaysRun=true)
    public void showEndTestInfo(Method method) {
        LOG.info(String.format("*** ENDING Test: [%s] ***", method.getName()));
    }
}

