/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import org.alfresco.email.EmailTest;
import org.alfresco.email.ImapWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ImapCreateFolderTests
extends EmailTest {
    private UserModel adminUser;
    private SiteModel imapSite;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.testUser = this.dataUser.createRandomTestUser();
        this.imapSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify admin can create a folder in Afresco IMAP root folder")
    @Test(groups={"protocols", "imap", "sanity"})
    public void adminCanCreateFolderInAlfrescoImapRoot() throws Exception {
        FolderModel folderToCreate = FolderModel.getRandomFolderModel();
        this.imapProtocol.authenticateUser(this.adminUser).usingAlfrescoImap().createFolder(folderToCreate).assertThat().existsInImap().assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify user can create a folder in Afresco IMAP root folder, but it is not displayed in Alfresco Repository")
    @Test(groups={"protocols", "imap", "sanity"})
    public void userCanCreateFolderInAlfrescoImapRootButNotDisplayedInRepo() throws Exception {
        FolderModel folderToCreate = FolderModel.getRandomFolderModel();
        this.imapProtocol.authenticateUser(this.testUser).usingAlfrescoImap().createFolder(folderToCreate).assertThat().existsInImap().assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify admin can create a folder in Sites folder and it will be displayed in Alfresco Repository/Sites")
    @Test(groups={"protocols", "imap", "sanity"})
    public void adminCanCreateFolderInSitesFolder() throws Exception {
        FolderModel folderToCreate = FolderModel.getRandomFolderModel();
        this.imapProtocol.authenticateUser(this.adminUser).usingSites().createFolder(folderToCreate).assertThat().existsInImap().assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify manager can create a folder in IMAP Site > documentLibrary")
    @Test(groups={"protocols", "imap", "sanity"})
    public void managerCanCreateFolderInIMAPSite() throws Exception {
        UserModel managerUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(managerUser, this.imapSite, UserRole.SiteManager);
        FolderModel folderToCreate = FolderModel.getRandomFolderModel();
        this.imapProtocol.authenticateUser(managerUser).usingSite(this.imapSite).createFolder(folderToCreate).assertThat().existsInImap().assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify manager can create a folder  with spaces in name in IMAP Site > documentLibrary")
    @Test(groups={"protocols", "imap", "core"})
    public void managerCanCreateFolderWithSpacesInIMAPSite() throws Exception {
        UserModel managerUser = this.dataUser.createRandomTestUser();
        this.imapSite = ((DataSite)this.dataSite.usingUser(managerUser)).createIMAPSite();
        FolderModel folderToCreate = new FolderModel("Folder with spaces in name");
        this.imapProtocol.authenticateUser(managerUser).usingSite(this.imapSite).createFolder(folderToCreate).assertThat().existsInImap().assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator can create a folder in IMAP Site > documentLibrary")
    @Test(groups={"protocols", "imap", "core"})
    public void collaboratorCanCreateFolderInImapSite() throws Exception {
        UserModel collaboratorUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(collaboratorUser, this.imapSite, UserRole.SiteCollaborator);
        FolderModel folderToCreate = FolderModel.getRandomFolderModel();
        this.imapProtocol.authenticateUser(collaboratorUser).usingSite(this.imapSite).createFolder(folderToCreate).assertThat().existsInImap().assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor can create a folder in IMAP Site > documentLibrary")
    @Test(groups={"protocols", "imap", "core"})
    public void contributorCanCreateFolderInImapSite() throws Exception {
        UserModel contributorUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(contributorUser, this.imapSite, UserRole.SiteCollaborator);
        FolderModel folderToCreate = FolderModel.getRandomFolderModel();
        this.imapProtocol.authenticateUser(contributorUser).usingSite(this.imapSite).createFolder(folderToCreate).assertThat().existsInImap().assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer cannot create a folder in IMAP Site > documentLibrary")
    @Test(groups={"protocols", "imap", "full"})
    public void consumerCannotCreateFolderInImapSite() throws Exception {
        UserModel consumerUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(consumerUser, this.imapSite, UserRole.SiteConsumer);
        ((DataSite)((DataSite)this.dataSite.usingUser(consumerUser)).usingSite(this.imapSite)).setIMAPFavorite();
        FolderModel folderToCreate = FolderModel.getRandomFolderModel();
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(consumerUser).usingSite(this.imapSite).createFolder(folderToCreate).and()).assertThat().doesNotExistInRepo()).then()).usingSite(this.imapSite).assertThat().doesNotContain(new FolderModel[]{folderToCreate});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user can create folder successfully with name that contains special characters")
    @Test(groups={"protocols", "imap", "full"})
    public void userCanCreateFolderWithSpecialCharacters() throws Exception {
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        FolderModel folderToCreate = new FolderModel("(a)[b]!#%^");
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(folderToCreate).then()).assertThat().existsInImap().assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user can create folder successfully with name that contains symbols")
    @Test(groups={"protocols", "imap", "full"})
    public void userCanCreateFolderWithSymbols() throws Exception {
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        FolderModel folderToCreate = new FolderModel("a\u00a3\u00a5\u20ac$\u264a\u264e \u264f \u2650 \u2651 \u2652 \u2653");
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(folderToCreate).then()).assertThat().existsInImap().assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot create folder with name omega\u03a9_<>./?")
    @Test(groups={"protocols", "imap", "full"})
    public void userCannotCreateFolderWithNameThatContainsRestrictedCharacters() throws Exception {
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        FolderModel folderToCreate = new FolderModel("omega\u03a9_<>./?");
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).createFolder(folderToCreate).and()).assertThat().doesNotExistInRepo()).then()).usingSite(this.testSite).assertThat().doesNotContain(new FolderModel[]{folderToCreate});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify create folder using an user and check folder can be view by another user with access to the same location/site")
    @Test(groups={"protocols", "imap", "full"})
    public void verifyUserCanViewTheFolderCreatedByAnotherUser() throws Exception {
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        UserModel collaboratorUser = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(collaboratorUser, this.testSite, UserRole.SiteCollaborator);
        FolderModel folderToCreate = FolderModel.getRandomFolderModel();
        this.imapProtocol.authenticateUser(collaboratorUser).usingSite(this.testSite).createFolder(folderToCreate).disconnect();
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)folderToCreate).assertThat().existsInImap().assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify error is returned for unauthenticated user on creating folder")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Not connected")
    public void verifyErrorIsReturnedForUnauthenticatedUserTryingToCreateFolder() throws Exception {
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.imapSite).disconnect().then()).createFolder(FolderModel.getRandomFolderModel());
    }
}

