/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import jakarta.mail.FolderNotFoundException;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.email.EmailTest;
import org.alfresco.email.ImapWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ImapMoveFolderTests
extends EmailTest {
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.testUser = this.dataUser.createRandomTestUser();
        this.adminSite = ((DataSite)this.dataSite.usingAdmin()).createIMAPSite();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify move non-empty folder to a different location by admin user")
    @Test(groups={"protocols", "imap", "sanity"})
    public void adminShouldMoveNonEmptyFolder() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(this.adminSite)).createFolder();
        FolderModel moveToFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(this.adminSite)).createFolder();
        ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.adminUser).usingSite(this.adminSite).usingResource((ContentModel)this.testFolder).moveTo((ContentModel)moveToFolder).and()).usingResource((ContentModel)this.testFolder).assertThat().doesNotExistInRepo()).then()).usingResource((ContentModel)moveToFolder).assertThat().contains(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify move folder with Manager")
    @Test(groups={"protocols", "imap", "sanity"})
    public void siteManagerShouldMoveFolder() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FolderModel moveToFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).moveTo((ContentModel)moveToFolder).and()).usingResource((ContentModel)this.testFolder).assertThat().doesNotExistInRepo()).then()).usingResource((ContentModel)moveToFolder).assertThat().contains(new FolderModel[]{this.testFolder});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify move folder at location where the folder already exists is successful")
    @Test(groups={"protocols", "imap", "core"})
    public void userShouldMoveFolderWhereAlreadyExists() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FolderModel moveToFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        ((DataContent)((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).usingResource((ContentModel)moveToFolder)).createFolder(this.testFolder);
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).moveTo((ContentModel)moveToFolder).and()).usingResource((ContentModel)this.testFolder).assertThat().doesNotExistInRepo()).then()).usingResource((ContentModel)moveToFolder).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify move folder with Contributor will create the new folder, but is NOT able to delete the current one")
    @Test(groups={"protocols", "imap", "core"})
    public void siteContributorCannotMoveFolder() throws Exception {
        UserModel siteContributor = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(siteContributor, this.testSite, UserRole.SiteContributor);
        ((DataSite)((DataSite)this.dataSite.usingUser(siteContributor)).usingSite(this.testSite)).setIMAPFavorite();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FolderModel moveToFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        ((ImapWrapper)this.imapProtocol.authenticateUser(siteContributor).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).moveTo((ContentModel)moveToFolder).usingResource((ContentModel)moveToFolder).assertThat().contains(new FolderModel[]{this.testFolder}).and()).usingResource((ContentModel)this.testFolder).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify move folder with Collaborator will create the new folder, but is NOT able to delete the current one")
    @Test(groups={"protocols", "imap", "core"})
    public void siteCollaboratorCannotMoveFolder() throws Exception {
        UserModel siteCollaborator = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(siteCollaborator, this.testSite, UserRole.SiteContributor);
        ((DataSite)((DataSite)this.dataSite.usingUser(siteCollaborator)).usingSite(this.testSite)).setIMAPFavorite();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FolderModel moveToFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        ((ImapWrapper)this.imapProtocol.authenticateUser(siteCollaborator).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).moveTo((ContentModel)moveToFolder).usingResource((ContentModel)moveToFolder).assertThat().contains(new FolderModel[]{this.testFolder}).and()).usingResource((ContentModel)this.testFolder).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify move folder with Consumer will create the new folder, but is NOT able to delete the current one")
    @Test(groups={"protocols", "imap", "core"})
    public void siteConsumerCannotMoveFolder() throws Exception {
        UserModel siteConsumer = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(siteConsumer, this.testSite, UserRole.SiteContributor);
        ((DataSite)((DataSite)this.dataSite.usingUser(siteConsumer)).usingSite(this.testSite)).setIMAPFavorite();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FolderModel moveToFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        ((ImapWrapper)this.imapProtocol.authenticateUser(siteConsumer).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).moveTo((ContentModel)moveToFolder).usingResource((ContentModel)moveToFolder).assertThat().contains(new FolderModel[]{this.testFolder}).and()).usingResource((ContentModel)this.testFolder).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify move folder fails using user that doesn't have permission to the IMAP site")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={FolderNotFoundException.class})
    public void unauthorizedUserCannotMoveFolder() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FolderModel moveToFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        UserModel unauthorizedUser = this.dataUser.createRandomTestUser();
        ((DataSite)((DataSite)this.dataSite.usingUser(unauthorizedUser)).usingSite(this.testSite)).setIMAPFavorite();
        ((ImapWrapper)this.imapProtocol.authenticateUser(unauthorizedUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).moveTo((ContentModel)moveToFolder).usingResource((ContentModel)moveToFolder).assertThat().doesNotContain(new FolderModel[]{this.testFolder}).and()).usingResource((ContentModel)this.testFolder).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify move folder with Manager")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={FolderNotFoundException.class})
    public void siteManagerShouldNotMoveDeletedFolder() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FolderModel moveToFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)this.testFolder).assertThat().existsInImap().assertThat().existsInRepo()).delete().moveTo((ContentModel)moveToFolder);
    }
}

