/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import jakarta.mail.MessagingException;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.email.EmailTest;
import org.alfresco.email.ImapWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ImapDeleteMessagesTests
extends EmailTest {
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        this.adminSite = ((DataSite)this.dataSite.usingAdmin()).createIMAPSite();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify deleting message via IMAP client by user with MANAGER role")
    @Test(groups={"protocols", "imap", "sanity"})
    public void siteManagerShouldDeleteMessage() throws Exception {
        this.testFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingResource((ContentModel)this.testFile).assertThat().existsInRepo()).and()).usingSite(this.testSite).assertThat().containsMessages(new FileModel[]{this.testFile}).deleteMessage(new String[]{this.testFile.getName()}).and()).assertThat().doesNotContainMessages(new FileModel[]{this.testFile});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify message has been deleted via REPOSITORU by user with MANAGER role")
    @Test(groups={"protocols", "imap", "core"})
    public void siteManagerVerifyMessageHasBeenDeletedFromRepository() throws Exception {
        this.testFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataContent)this.dataContent.usingUser(this.testUser).usingResource((ContentModel)this.testFile)).deleteContent();
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo()).and()).usingSite(this.testSite).assertThat().doesNotContainMessages(new FileModel[]{this.testFile});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify deleting message via IMAP client by user with CONTRIBUTOR role")
    @Test(groups={"protocols", "imap", "core"})
    public void siteContributorShouldDeleteMessage() throws Exception {
        UserModel contributorUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(contributorUser, this.testSite, UserRole.SiteContributor);
        this.testFile = ((DataContent)this.dataContent.usingUser(contributorUser).usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(contributorUser).usingResource((ContentModel)this.testFile).deleteMessage().usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo()).and()).usingSite(this.testSite).assertThat().doesNotContainMessages(new FileModel[]{this.testFile});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify deleting message via IMAP client by user with COLLABORATOR role")
    @Test(groups={"protocols", "imap", "core"})
    public void siteCollaboratorShouldDeleteMessage() throws Exception {
        UserModel collaboratorUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(collaboratorUser, this.testSite, UserRole.SiteCollaborator);
        this.testFile = ((DataContent)this.dataContent.usingUser(collaboratorUser).usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(collaboratorUser).usingResource((ContentModel)this.testFile).deleteMessage().usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo()).and()).usingSite(this.testSite).assertThat().doesNotContainMessages(new FileModel[]{this.testFile});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify deleting message via IMAP client by user with CONSUMER role is not permitted")
    @Test(groups={"protocols", "imap", "core"}, expectedExceptions={MessagingException.class}, expectedExceptionsMessageRegExp=".*No permission to set DELETED flag")
    public void siteConsumerShouldNotDeleteMessage() throws Exception {
        UserModel consumerUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.testUser)).addUserToSite(consumerUser, this.testSite, UserRole.SiteConsumer);
        this.testFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.imapProtocol.authenticateUser(consumerUser).usingResource((ContentModel)this.testFile).deleteMessage();
    }
}

