/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tas.integration;

import io.restassured.RestAssured;
import java.io.File;
import javax.json.JsonObject;
import javax.mail.Flags;
import javax.mail.MessagingException;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.dataprep.SiteService;
import org.alfresco.email.ImapWrapper;
import org.alfresco.ftp.FTPWrapper;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestItemModelsCollection;
import org.alfresco.rest.model.RestPreferenceModel;
import org.alfresco.rest.model.RestPreferenceModelsCollection;
import org.alfresco.rest.model.RestProcessDefinitionModelsCollection;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessVariableCollection;
import org.alfresco.rest.model.RestProcessVariableModel;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.rest.model.RestTaskModelsCollection;
import org.alfresco.tas.integration.IntegrationTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.PreferenceName;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavWrapper;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class IntegrationFullTests
extends IntegrationTest {
    private UserModel admin;
    private UserModel testUser1;
    private UserModel testUser2;
    private UserModel userToAssign;
    private SiteModel publicSite;
    private SiteModel moderatedSite;
    private SiteModel privateSite;
    private FileModel testFile1;
    private FileModel testFile2;
    private FolderModel parentFolder;
    private RestTaskModelsCollection processTasks;
    private RestProcessModel processModel;
    private RestItemModelsCollection taskItems;
    private TaskModel taskModel;
    private RestTaskModel restTaskModel;

    @BeforeClass(alwaysRun=true)
    public void setup() throws Exception {
        this.admin = this.dataUser.getAdminUser();
    }

    @Test(groups={"integration", "full"}, expectedExceptions={CmisObjectNotFoundException.class})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify the file cannot be renamed in repository if it is deleted from IMAP client")
    public void verifyFileCannotBeRenamedInRepoIfItWasAlreadyDeletedViaIMAP() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser();
        SiteModel testSite = ((DataSite)this.dataSite.usingUser(testUser)).createIMAPSite();
        FileModel testFile = ((DataContent)this.dataContent.usingUser(testUser).usingSite(testSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.imapProtocol.authenticateUser(testUser).usingSite(testSite).usingResource((ContentModel)testFile).deleteMessage();
        this.cmisAPI.authenticateUser(testUser).usingSite(testSite).usingResource((ContentModel)testFile).rename("new file name");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify a 1MB file is uploaded in a private site")
    public void userShouldUploadFileInPrivateSite() throws Exception {
        Step.STEP((String)"1. Using CMIS create a test user: u1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a private site using CMIS");
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPrivateRandomSite();
        Step.STEP((String)"3. U1 creates a folder in site's document library using WebDav");
        this.parentFolder = FolderModel.getRandomFolderModel();
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.privateSite).createFolder(this.parentFolder).assertThat().existsInWebdav();
        Step.STEP((String)"4. U1 uploads a document with size > x MB in folder1 using FTP");
        File fileForUpload = Utility.getTestResourceFile((String)"shared-resources/testdata/flower.jpg");
        ((FTPWrapper)((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.parentFolder).uploadFile(fileForUpload).assertThat().existsInRepo()).and()).assertThat().existsInFtp();
        this.testFile1 = new FileModel(fileForUpload.getName());
        this.testFile1.setCmisLocation(this.ftpProtocol.getLastResourceWithoutPrefix());
        Step.STEP((String)"5. Verify file is present in folder1 using WebDAV");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.parentFolder).assertThat().hasFiles(new FileModel[]{this.testFile1});
        Step.STEP((String)"6. Verify size of the document from folder1 is exact as the size of the uploaded document CMIS");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).assertThat().contentLengthIs(fileForUpload.length());
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to access files from a private site, even if they are attached to a task assigned to him.")
    public void assigneeCantAccessFilesFromPrivateSiteIfHeIsNotAMember() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a private site using CMIS");
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPrivateRandomSite();
        Step.STEP((String)"3. U1 creates 2 documents in his site using WebDav");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.testFile2 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file2 content");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.privateSite).createFile(this.testFile1).assertThat().existsInWebdav().assertThat().existsInRepo()).createFile(this.testFile2).assertThat().existsInWebdav().assertThat().existsInRepo();
        Step.STEP((String)"4. U1 creates a new task with the documents created above and assigns the task to U2 using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", this.testUser2, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile2);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. Verify that U2 doesn't have access to te documents attached to the task using FTP");
        ((FTPWrapper)((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFile1).assertThat().hasReplyCode(550).and()).assertThat().doesNotExistInFtp().usingResource((ContentModel)this.testFile2).assertThat().hasReplyCode(550).and()).assertThat().doesNotExistInFtp();
    }

    @Test(groups={"integration", "full"}, expectedExceptionsMessageRegExp="^Access is denied.$")
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to access files from a moderated site, even if they are attached to a task assigned to him.")
    public void assigneeCantAccessFilesFromModeratedSiteIfHeIsNotAMember() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a moderated site using CMIS");
        this.moderatedSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createModeratedRandomSite();
        Step.STEP((String)"3. U1 creates 2 documents in his site using WebDAV");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.testFile2 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file2 content");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.moderatedSite).createFile(this.testFile1).assertThat().existsInWebdav().assertThat().existsInRepo()).createFile(this.testFile2).assertThat().existsInWebdav().assertThat().existsInRepo();
        Step.STEP((String)"4. U1 creates a new task with the documents created above and assigns the task to U2 using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", this.testUser2, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile2);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. Verify that U2 doesn't have access to te documents attached to the task using WebDav");
        this.webDavProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFile1).assertThat().doesNotExistInWebdav().usingResource((ContentModel)this.testFile2).assertThat().doesNotExistInWebdav();
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able to access files from a public site, even if they are attached to a task assigned to him.")
    public void assigneeCanAccessFilesFromPublicSiteIfHeIsNotAMember() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public site using CMIS");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. U1 creates 2 documents in his site using CMIS");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)"file1 content");
        this.testFile2 = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)"file2 content");
        this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInRepo().usingSite(this.publicSite).createFile(this.testFile2).assertThat().existsInRepo();
        Step.STEP((String)"4. U1 creates a new task with the documents created above and assigns the task to U2 using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", this.testUser2, false, CMISUtil.Priority.Normal);
        this.testFile1.setNodeRef(((DataContent)this.dataContent.usingResource((ContentModel)this.testFile1)).getNodeRef());
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        this.testFile2.setNodeRef(((DataContent)this.dataContent.usingResource((ContentModel)this.testFile2)).getNodeRef());
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile2);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. Verify that U2 have access to te documents attached to the task using WebDAV");
        this.webDavProtocol.authenticateUser(this.testUser2).usingSite(this.publicSite).assertThat().hasFiles(new FileModel[]{this.testFile1, this.testFile2});
    }

    @Test(groups={"integration", "full"}, expectedExceptions={CmisPermissionDeniedException.class, CmisUnauthorizedException.class})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to access files from another user User Home repo, even if they are attached to a task assigned to him.")
    public void assigneeCantAccessFilesFromAnotherUserHome() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates 2 documents in User Home with CMIS");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)"file1 content");
        this.testFile2 = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)"file2 content");
        this.cmisAPI.authenticateUser(this.testUser1).usingUserHome().createFile(this.testFile1).assertThat().existsInRepo().createFile(this.testFile2).assertThat().existsInRepo();
        Step.STEP((String)"3. U1 creates a new task with the documents created above and assigns the task to U2 using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", this.testUser2, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile2);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"4. Verify that U2 doesn't have access to te documents attached to the task using CMIS");
        this.cmisAPI.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFile1).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Check that user can't delete/update a file that is renamed/deleted by another user.")
    public void deleteFileAfterItIsRenamedByAnotherUser() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates document1 in a public site using CMIS");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"3. U2 is added to that public site with manager role using REST");
        this.testUser2.setUserRole(UserRole.SiteManager);
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingSite(this.publicSite).addPerson(this.testUser2);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"4. U2 opens the document and renames it to document2 using WebDAV");
        FileModel oldFile = new FileModel(this.testFile1);
        this.webDavProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFile1).rename("new" + this.testFile1.getName()).assertThat().existsInRepo();
        Step.STEP((String)"5. Verify that U1 can't delete anymore document1 using FTP");
        this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)oldFile).delete().assertThat().hasReplyCode(550);
        Step.STEP((String)"6. U1 deletes document2 using WebDAV");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).delete().assertThat().doesNotExistInWebdav().assertThat().doesNotExistInRepo();
        Step.STEP((String)"7. Verify U2 can't update document2 using WebDAV");
        this.webDavProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFile1).update("file2 content").assertThat().hasStatus(404);
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content", "comments"}, executionType={ExecutionType.REGRESSION}, description="Check that user can't get a comment that is deleted by another user.")
    public void getCommentAfterItIsDeleted() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates document1 in a public site using FTP");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"3. U2 is added to that public site with manager role using REST");
        this.testUser2.setUserRole(UserRole.SiteManager);
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingSite(this.publicSite).addPerson(this.testUser2);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"4. U1 adds comment to document1 using REST");
        RestCommentModel user1Comment = this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingResource((RepoTestModel)this.testFile1).addComment("user1 comment");
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. U2 gets document1 comments using REST");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingResource((RepoTestModel)this.testFile1).getNodeComments().assertThat().entriesListContains("content", "user1 comment");
        Step.STEP((String)"6. U1 renames document1 using CMIS");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).rename("new" + this.testFile1.getName()).assertThat().existsInRepo().assertThat().contentPropertyHasValue("cmis:name", "new" + this.testFile1.getName()).usingResource((ContentModel)this.testFile1).assertThat().doesNotExistInRepo();
        Step.STEP((String)"7. U2 deletes comment using REST");
        this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile1).deleteComment(user1Comment);
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"8. Verify U1 cannot get comment using REST");
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingResource((RepoTestModel)this.testFile1).getNodeComments().assertThat().entriesListIsEmpty();
    }

    @Test(groups={"integration", "full"}, expectedExceptions={MessagingException.class})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to move a renamed file using its initial name.")
    public void moveRenamedFileUsingInitialFilename() throws Exception {
        Step.STEP((String)"1. Using CMIS create one test user: u1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public site using CMIS");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createIMAPSite();
        Step.STEP((String)"3. Admin creates a folder with a document (doc1.txt) in the public site using WebDav");
        this.parentFolder = FolderModel.getRandomFolderModel();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file 1 content");
        this.webDavProtocol.authenticateUser(this.admin).usingSite(this.publicSite).createFolder(this.parentFolder).assertThat().existsInWebdav().usingResource((ContentModel)this.parentFolder).createFile(this.testFile1).assertThat().existsInWebdav();
        Step.STEP((String)"4. Admin renames document1 (doc1-edited.txt) using WebDAV");
        FileModel oldFile = new FileModel(this.testFile1);
        this.webDavProtocol.authenticateUser(this.admin).usingResource((ContentModel)this.testFile1).rename("new" + this.testFile1.getName()).assertThat().existsInRepo();
        Step.STEP((String)"5. U1 tries to move doc1.txt to another location using IMAP");
        FolderModel destination = new FolderModel(Utility.buildPath((String)"Sites", (String[])new String[]{this.publicSite.getId(), "documentLibrary"}));
        destination.setProtocolLocation(this.imapProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).getLastResourceWithoutPrefix());
        this.imapProtocol.usingResource((ContentModel)oldFile).moveMessageTo((ContentModel)destination);
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Find files and flag files.")
    public void findFilesAndFlagFiles() throws Exception {
        Step.STEP((String)"1. Using CMIS create an user and a site.");
        UserModel testUser = this.dataUser.createRandomTestUser();
        SiteModel testSitePublic = ((DataSite)this.dataSite.usingUser(testUser)).createIMAPSite();
        Step.STEP((String)"2. Using FTP create two folders.");
        FolderModel folder1 = FolderModel.getRandomFolderModel();
        FolderModel folder2 = FolderModel.getRandomFolderModel();
        ((FTPWrapper)this.ftpProtocol.authenticateUser(testUser).usingSite(testSitePublic).createFolder(folder1).and()).createFolder(folder2);
        Step.STEP((String)"3. Using CMIS create documents in folder1: a-childDoc1, childDoc11, child21.");
        FileModel file11 = ((DataContent)((DataContent)this.dataContent.usingUser(testUser).usingSite(testSitePublic)).usingResource((ContentModel)folder1)).createContent(new FileModel("a-childDoc1", FileType.TEXT_PLAIN, "content"));
        FileModel file12 = ((DataContent)((DataContent)this.dataContent.usingUser(testUser).usingSite(testSitePublic)).usingResource((ContentModel)folder1)).createContent(new FileModel("childDoc11", FileType.TEXT_PLAIN, "content"));
        FileModel file13 = ((DataContent)((DataContent)this.dataContent.usingUser(testUser).usingSite(testSitePublic)).usingResource((ContentModel)folder1)).createContent(new FileModel("child21", FileType.TEXT_PLAIN, "content"));
        Step.STEP((String)"4. Using CMIS create documents in folder2: childDoc112, childDoc2, achild2.");
        FileModel file21 = ((DataContent)((DataContent)this.dataContent.usingUser(testUser).usingSite(testSitePublic)).usingResource((ContentModel)folder2)).createContent(new FileModel("childDoc112", FileType.TEXT_PLAIN, "content"));
        FileModel file22 = ((DataContent)((DataContent)this.dataContent.usingUser(testUser).usingSite(testSitePublic)).usingResource((ContentModel)folder2)).createContent(new FileModel("childDoc2", FileType.TEXT_PLAIN, "content"));
        FileModel file23 = ((DataContent)((DataContent)this.dataContent.usingUser(testUser).usingSite(testSitePublic)).usingResource((ContentModel)folder2)).createContent(new FileModel("achild2", FileType.TEXT_PLAIN, "content"));
        Step.STEP((String)"5. Using IMAP client flag content 'childDoc112'.");
        this.imapProtocol.authenticateUser(testUser).usingResource((ContentModel)file21).withMessage().setFlags(new Flags.Flag[]{Flags.Flag.ANSWERED, Flags.Flag.SEEN}).updateFlags();
        Step.STEP((String)"6. Using IMAP find documents after search term 'child'.");
        this.imapProtocol.usingResource((ContentModel)folder1).searchSubjectFor("child").assertThat().resultsContainMessage(new FileModel[]{file11, file12, file13}).usingResource((ContentModel)folder2).searchSubjectFor("child").assertThat().resultsContainMessage(new FileModel[]{file21, file22, file23});
        Step.STEP((String)"7. Using IMAP find documents after search term '.*child2.*'.");
        this.imapProtocol.usingResource((ContentModel)folder2).searchSubjectWithWildcardsFor(".*child2.*").assertThat().resultsContainMessage(new FileModel[]{file23}).assertThat().resultsDoNotContainMessage(new FileModel[]{file21, file22});
        Step.STEP((String)"8. Using IMAP find documents after search term 'childa'. No results should be displayed.");
        this.imapProtocol.usingResource((ContentModel)folder1).searchSubjectFor("childa").assertThat().resultsDoNotContainMessage(new FileModel[]{file11, file12, file13}).usingResource((ContentModel)folder2).searchSubjectFor("childa").assertThat().resultsDoNotContainMessage(new FileModel[]{file21, file22, file23});
        Step.STEP((String)"9. Using IMAP find documents after search term 'child*2'.");
        this.imapProtocol.usingResource((ContentModel)folder1).searchSubjectWithWildcardsFor("child.*2.*").assertThat().resultsContainMessage(new FileModel[]{file13}).assertThat().resultsDoNotContainMessage(new FileModel[]{file11, file12}).usingResource((ContentModel)folder2).searchSubjectWithWildcardsFor("child.*2.*").assertThat().resultsContainMessage(new FileModel[]{file21, file22}).assertThat().resultsDoNotContainMessage(new FileModel[]{file23});
        Step.STEP((String)"10. Using IMAP verify that 'childDoc112' is flagged.");
        this.imapProtocol.usingResource((ContentModel)file21).assertThat().messageContainsFlags(new Flags.Flag[]{Flags.Flag.ANSWERED, Flags.Flag.SEEN});
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify assigner user is able to add and remove items from task.")
    public void assignerIsAbleToAddAndRemoveItemsFromTask() throws Exception {
        Step.STEP((String)"1. Using CMIS create two test users: u1 and userToAssign");
        this.testUser1 = this.dataUser.createRandomTestUser();
        UserModel userToAssign = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public site using CMIS: publicSite");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. U1 creates a document in public site using WebDAV: documentTest");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().webDavWrapper().assertThat().existsInRepo();
        Step.STEP((String)"4. U1 creates a new task with the documents created above and assigns the task to userToAssign using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", userToAssign, false, CMISUtil.Priority.Normal);
        this.processTasks = this.restAPI.authenticateUser(userToAssign).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks();
        this.restAPI.withWorkflowAPI().usingTask((TaskModel)this.processTasks.getTaskModelByAssignee(userToAssign)).addTaskItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. Verify that userToAssign receives the task using REST");
        this.processTasks = this.restAPI.authenticateUser(userToAssign).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks();
        ((RestModels)((RestModels)this.processTasks.assertThat().entriesListContains("assignee", userToAssign.getUsername())).and().entriesListContains("state", "claimed")).and().paginationField("count").is("1");
        Step.STEP((String)"6. U1 adds items to task using REST");
        this.testFile2 = ((DataContent)this.dataContent.usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.HTML);
        FileModel testFile3 = ((DataContent)this.dataContent.usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.PDF);
        this.taskItems = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().usingTask((TaskModel)this.processTasks.getTaskModelByAssignee(userToAssign)).addTaskItems(new FileModel[]{this.testFile2, testFile3});
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"7. U1 removes items from task using REST");
        this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().usingTask((TaskModel)this.processTasks.getTaskModelByAssignee(userToAssign)).deleteTaskItem(((RestItemModel)this.taskItems.getEntries().get(0)).onModel());
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"8. userToAssign gets the list of the updated items using REST");
        ((RestModels)((RestModels)this.restAPI.authenticateUser(userToAssign).withWorkflowAPI().usingTask((TaskModel)this.processTasks.getTaskModelByAssignee(userToAssign)).getTaskItems().assertThat().entriesListContains("name", this.testFile1.getName())).assertThat().entriesListContains("name", testFile3.getName())).and().paginationField("count").is("2");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify assignee user is to add and remove items from task.")
    public void assigneeIsAbleToAddAndRemoveItemsFromTask() throws Exception {
        Step.STEP((String)"1. Using CMIS create two test users: u1 and userToAssign");
        this.testUser1 = this.dataUser.createRandomTestUser();
        UserModel userToAssign = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public site using CMIS: publicSite");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. U1 creates a document in public site using webDAV: documentTest");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInWebdav().assertThat().existsInRepo();
        Step.STEP((String)"4. U1 creates a new task with the documents created above and assigns the task to userToAssign using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", userToAssign, false, CMISUtil.Priority.Normal);
        this.processTasks = this.restAPI.authenticateUser(userToAssign).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks();
        this.restAPI.withWorkflowAPI().usingTask((TaskModel)this.processTasks.getTaskModelByAssignee(userToAssign)).addTaskItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. Verify that userToAssign receives the task using REST");
        this.processTasks = this.restAPI.authenticateUser(userToAssign).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks();
        ((RestModels)((RestModels)this.processTasks.assertThat().entriesListContains("assignee", userToAssign.getUsername())).and().entriesListContains("state", "claimed")).and().paginationField("count").is("1");
        Step.STEP((String)"6. userToAssign adds items to task using REST");
        this.testFile2 = ((DataContent)this.dataContent.usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.HTML);
        FileModel testFile3 = ((DataContent)this.dataContent.usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.PDF);
        this.taskItems = this.restAPI.withWorkflowAPI().usingTask((TaskModel)this.processTasks.getTaskModelByAssignee(userToAssign)).addTaskItems(new FileModel[]{this.testFile2, testFile3});
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"7. userToAssign removes items from task using REST");
        this.restAPI.withWorkflowAPI().usingTask((TaskModel)this.processTasks.getTaskModelByAssignee(userToAssign)).deleteTaskItem(((RestItemModel)this.taskItems.getEntries().get(1)).onModel());
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"8. U1 gets the list of the updated items using REST");
        ((RestModels)((RestModels)this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().usingTask((TaskModel)this.processTasks.getTaskModelByAssignee(userToAssign)).getTaskItems().assertThat().entriesListContains("name", this.testFile2.getName())).assertThat().entriesListContains("name", this.testFile1.getName())).and().paginationField("count").is("2");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify assignee user is able to update task.")
    public void assigneeIsAbleToUpdateTask() throws Exception {
        Step.STEP((String)"1. Using CMIS create two test users: u1 and userToAssign");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.userToAssign = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public site using CMIS: publicSite");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. U1 creates a document in public site using webDavProtocol: documentTest");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"4. U1 creates a new task with the documents created above and assigns the task to userToAssign using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", this.userToAssign, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. Verify that userToAssign receives the task using REST");
        this.taskModel = (TaskModel)this.restAPI.authenticateUser(this.userToAssign).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks().getTaskModelByAssignee(this.userToAssign).assertThat().field("assignee").is((Object)this.userToAssign.getUsername());
        Step.STEP((String)"6. Status is changed by userToAssign using REST");
        this.restTaskModel = this.restAPI.authenticateUser(this.userToAssign).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
        Step.STEP((String)"7. U1 gets the modified values from the task using REST");
        ((RestTaskModel)this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().usingTask((TaskModel)this.restTaskModel).getTask().assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
        Step.STEP((String)"8. userToAssign marks the task as 'Resolved' using REST");
        this.restTaskModel = this.restAPI.authenticateUser(this.userToAssign).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed")).and().field("assignee").is((Object)this.userToAssign.getUsername());
        Step.STEP((String)"9. U1 receives the task using REST");
        this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().usingTask((TaskModel)this.restTaskModel).getTask().assertThat().field("state").is((Object)"completed");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify assigner user is able to update task.")
    public void assignerIsAbleToUpdateTask() throws Exception {
        Step.STEP((String)"1. Using CMIS create two test users: u1 and userToAssign");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.userToAssign = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public site using CMIS: publicSite");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. U1 creates a document in public site using webDavProtocol: documentTest");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"4. U1 creates a new task with the documents created above and assigns the task to userToAssign using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", this.userToAssign, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. Verify that userToAssign receives the task using REST");
        this.taskModel = (TaskModel)((RestTaskModel)this.restAPI.authenticateUser(this.userToAssign).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks().getEntryByIndex(0)).assertThat().field("assignee").is((Object)this.userToAssign.getUsername());
        Step.STEP((String)"6. Status is changed by U1 using REST");
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.userToAssign.getUsername()).build();
        this.restTaskModel = this.restAPI.authenticateUser(this.testUser1).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)((RestTaskModel)((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated")).and().field("owner").is((Object)this.testUser1.getUsername())).and().field("assignee").is((Object)this.userToAssign.getUsername());
        Step.STEP((String)"7. userToAssign gets the modified values from the task using REST");
        ((RestTaskModel)this.restAPI.authenticateUser(this.userToAssign).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks().getTaskModelByAssignee(this.userToAssign).assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated");
        Step.STEP((String)"8. userToAssign marks the task as 'Resolved' using REST");
        this.restTaskModel = this.restAPI.withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"resolved");
        Step.STEP((String)"9. U1 receives the task using REST");
        ((RestTaskModel)((RestTaskModel)((RestTaskModel)this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks().getEntryByIndex(0)).assertThat().field("state").is((Object)"resolved")).assertThat().field("id").is((Object)this.taskModel.getId())).assertThat().field("assignee").is((Object)this.testUser1.getUsername());
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify assigner user is able to cancel an workflow.")
    public void assignerIsAbleToCancelWorkflow() throws Exception {
        Step.STEP((String)"1. Using CMIS create two test users: u1 and userToAssign");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.userToAssign = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public site using CMIS: publicSite");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. U1 creates a document in public site using webDavProtocol: documentTest");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"4. U1 creates a new task with the documents created above and assigns the task to userToAssign using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", this.userToAssign, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestModels)this.restAPI.withWorkflowAPI().getProcesses().assertThat().entriesListContains("startActivityId", "start")).and().paginationField("count").is("1");
        Step.STEP((String)"5. Verify that userToAssign receives the task using REST");
        this.restAPI.authenticateUser(this.userToAssign).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks().getTaskModelByAssignee(this.userToAssign).assertThat().field("assignee").is((Object)this.userToAssign.getUsername());
        Step.STEP((String)"6. U1 cancels workflow using REST");
        Assert.assertTrue((boolean)((DataWorkflow)this.dataWorkflow.usingUser(this.testUser1)).cancelProcess((ProcessModel)this.processModel), (String)"User is able to cancel the workflow");
        ((RestModels)this.restAPI.withWorkflowAPI().getProcesses().assertThat().entriesListDoesNotContain("id", this.processModel.getId())).and().paginationField("count").is("0");
        Step.STEP((String)"7. Verify task is no longer present for userToAssign: MyTasks");
        this.restAPI.authenticateUser(this.userToAssign).withWorkflowAPI().getProcesses().assertThat().entriesListDoesNotContain("id", this.processModel.getId());
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify assignee user is able to cancel an workflow.")
    public void assigneeIsNotAbleToCancelWorkflow() throws Exception {
        Step.STEP((String)"1. Using CMIS create two test users: u1 and userToAssign");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.userToAssign = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public site using CMIS: publicSite");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. U1 creates a document in public site using webDavProtocol: documentTest");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"4. U1 creates a new task with the documents created above and assigns the task to userToAssign using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", this.userToAssign, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestModels)this.restAPI.withWorkflowAPI().getProcesses().assertThat().entriesListContains("startActivityId", "start")).and().paginationField("count").is("1");
        Step.STEP((String)"5. Verify that userToAssign receives the task using REST");
        this.restAPI.authenticateUser(this.userToAssign).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks().getTaskModelByAssignee(this.userToAssign).assertThat().field("assignee").is((Object)this.userToAssign.getUsername());
        Step.STEP((String)"6. userToAssign is not able to cancel workflow using REST");
        Assert.assertFalse((boolean)((DataWorkflow)this.dataWorkflow.usingUser(this.userToAssign)).cancelProcess((ProcessModel)this.processModel), (String)"User is unable to cancel workflow.");
        ((RestModels)this.restAPI.withWorkflowAPI().getProcesses().assertThat().entriesListContains("id", this.processModel.getId())).and().paginationField("count").is("1");
        Step.STEP((String)"7. Verify U1 still has the workflow");
        ((RestModels)this.restAPI.authenticateUser(this.userToAssign).withWorkflowAPI().getProcesses().assertThat().entriesListContains("id", this.processModel.getId())).and().paginationField("count").is("1");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify assigner user is able to rename items from a task.")
    public void assignerIsAbleToRenameItemsFromTask() throws Exception {
        Step.STEP((String)"1. Using CMIS create two test users: u1 and userToAssign");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.userToAssign = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public site using CMIS: publicSite");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. U1 creates a document in public site using webDavProtocol: documentTest");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"4. U1 creates a new task with the documents created above and assigns the task to userToAssign using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", this.userToAssign, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. Verify that userToAssign receives the task using REST");
        this.taskModel = (TaskModel)this.restAPI.authenticateUser(this.userToAssign).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks().getTaskModelByAssignee(this.userToAssign).assertThat().field("assignee").is((Object)this.userToAssign.getUsername());
        Step.STEP((String)"6. U1 renames the document using webDAV");
        FileModel originalFileModel = new FileModel(this.testFile1);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).usingResource((ContentModel)this.testFile1).and()).assertThat().existsInRepo()).when()).rename(this.testFile1.getName() + "-edit").assertThat().existsInRepo()).and()).assertThat().hasStatus(201).then()).usingSite(this.publicSite).usingResource((ContentModel)originalFileModel).assertThat().doesNotExistInRepo();
        Step.STEP((String)"7. Verify renamed document with users: U1 and userToAssign using RestAPI");
        this.processTasks = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks();
        ((RestModels)((RestModels)this.restAPI.withWorkflowAPI().usingTask((TaskModel)this.processTasks.getTaskModelByAssignee(this.userToAssign)).getTaskItems().assertThat().entriesListContains("name", this.testFile1.getName() + "-edit")).assertThat().entriesListDoesNotContain("name", originalFileModel.getName())).and().paginationField("count").is("1");
        this.processTasks = this.restAPI.authenticateUser(this.userToAssign).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks();
        ((RestModels)((RestModels)this.restAPI.authenticateUser(this.userToAssign).withWorkflowAPI().usingTask((TaskModel)this.processTasks.getTaskModelByAssignee(this.userToAssign)).getTaskItems().assertThat().entriesListContains("name", this.testFile1.getName() + "-edit")).assertThat().entriesListDoesNotContain("name", originalFileModel.getName())).and().paginationField("count").is("1");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify assigner user is able to delete items from a task.")
    public void assignerIsAbleToDeleteItemsFromTask() throws Exception {
        Step.STEP((String)"1. Using CMIS create two test users: u1 and userToAssign");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.userToAssign = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public site using CMIS: publicSite");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. U1 creates a document in public site using webDavProtocol: documentTest");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"4. U1 creates a new task with the documents created above and assigns the task to userToAssign using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", this.userToAssign, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. Verify that userToAssign receives the task using REST");
        this.taskModel = (TaskModel)this.restAPI.authenticateUser(this.userToAssign).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks().getTaskModelByAssignee(this.userToAssign).assertThat().field("assignee").is((Object)this.userToAssign.getUsername());
        Step.STEP((String)"6. U1 deletes the document using webDAV");
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).usingResource((ContentModel)this.testFile1).delete().assertThat().hasStatus(200).and()).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInWebdav().and()).assertThat().hasStatus(404);
        Step.STEP((String)"7. Verify no documents are present with users: U1 and userToAssign using RestAPI");
        this.processTasks = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks();
        ((RestModels)this.restAPI.withWorkflowAPI().usingTask((TaskModel)this.processTasks.getTaskModelByAssignee(this.userToAssign)).getTaskItems().assertThat().entriesListDoesNotContain("name", this.testFile1.getName())).and().paginationField("count").is("0");
        this.processTasks = this.restAPI.authenticateUser(this.userToAssign).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks();
        ((RestModels)this.restAPI.authenticateUser(this.userToAssign).withWorkflowAPI().usingTask((TaskModel)this.processTasks.getTaskModelByAssignee(this.userToAssign)).getTaskItems().assertThat().entriesListDoesNotContain("name", this.testFile1.getName())).and().paginationField("count").is("0");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able to create, rename, update content, delete a file with special symbols in its name.")
    public void userIsAbleToDoCRUDActionsOnFileWithSpecialName() throws Exception {
        Step.STEP((String)"1. Using CMIS create 1 test user: u1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates folder1 in a public site using IMAP");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createIMAPSite();
        this.parentFolder = FolderModel.getRandomFolderModel();
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFolder(this.parentFolder).assertThat().existsInImap().and()).assertThat().existsInRepo();
        Step.STEP((String)"3. U1 creates file with special symbols in its name using FTP inside the public site");
        String fileName = RandomData.getRandomAlphanumeric();
        this.testFile1 = new FileModel(fileName + "\ufeff\u6768\u6728\u91d1.doc");
        ((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).then()).usingSite(this.publicSite).createFile(this.testFile1).and()).assertThat().existsInRepo()).and()).assertThat().existsInFtp();
        Step.STEP((String)"4. U1 adds some special characters in document content using CMIS");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).update("!@#$%^&()-_+={}[].,").assertThat().contentIs("!@#$%^&()-_+={}[].,");
        Step.STEP((String)"5. U1 renames document to a different name using special chars using FTP");
        this.ftpProtocol.usingResource((ContentModel)this.testFile1).rename(fileName + "!@#$%^&()-_+={}[].,").assertThat().existsInRepo();
        this.testFile2 = new FileModel(this.testFile1);
        Step.STEP((String)"6. U1 copy document to the folder created above using IMAP");
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).usingResource((ContentModel)this.testFile1).assertThat().existsInRepo()).assertThat().existsInImap().copyMessageTo((ContentModel)this.parentFolder).assertThat().containsMessages(new FileModel[]{this.testFile1});
        Step.STEP((String)"7. U1 deletes document from initial location using CMIS");
        this.cmisAPI.usingResource((ContentModel)this.testFile2).delete().assertThat().doesNotExistInRepo().usingResource((ContentModel)this.parentFolder).assertThat().hasFiles(new FileModel[]{this.testFile1});
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify users ability to update files when site visibility is changed.")
    public void updateFileByRegularUserAndSiteMemberWhenSiteVisibilityIsChanged() throws Exception {
        Step.STEP((String)"1. Using CMIS create 3 test users: u1, u2 and u3");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        UserModel testUser3 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates document1 in a public site using WebDAV");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"3. U1 adds U3  to his site as Site manager using REST");
        testUser3.setUserRole(UserRole.SiteManager);
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingSite(this.publicSite).addPerson(testUser3);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"4. Check that U2 is able to update document using FTP.");
        this.ftpProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFile1).update("u2 update when site visibility is public").assertThat().contentIs("file1 content");
        Step.STEP((String)"5. Check that U3 is able to update document using WebDav.");
        this.webDavProtocol.authenticateUser(testUser3).usingResource((ContentModel)this.testFile1).update("u3 update when site visibility is public").assertThat().contentIs("u3 update when site visibility is public");
        Step.STEP((String)"6. U1 changes site visibility to moderated using REST");
        ((DataSite)this.dataSite.usingUser(this.testUser1)).updateSiteVisibility(this.publicSite, SiteService.Visibility.MODERATED);
        Step.STEP((String)"7. Check that U2 is not able to update document using FTP.");
        this.ftpProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFile1).update("u2 update when site visibility is moderated").assertThat().hasReplyCode(451);
        Step.STEP((String)"8. Check that U3 is able to update document WebDAV.");
        this.webDavProtocol.authenticateUser(testUser3).usingResource((ContentModel)this.testFile1).update("u3 update when site visibility is moderated").assertThat().contentIs("u3 update when site visibility is moderated");
        Step.STEP((String)"9. U1 changes site visibility to private using REST");
        ((DataSite)this.dataSite.usingUser(this.testUser1)).updateSiteVisibility(this.publicSite, SiteService.Visibility.PRIVATE);
        Step.STEP((String)"10. Check that U2 is not able to update document using FTP.");
        this.ftpProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFile1).update("u2 update when site visibility is private").assertThat().hasReplyCode(451);
        Step.STEP((String)"11. Check that U3 is able to update document WebDAV.");
        this.webDavProtocol.authenticateUser(testUser3).usingResource((ContentModel)this.testFile1).update("u3 update when site visibility is private").assertThat().contentIs("u3 update when site visibility is private");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify initiator is able to delete a process after its task is updated by assignee as resolved.")
    public void deleteWorkflowByInitiator() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates document1 in a public site using FTP");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"3. U1 creates a New Task with the document created above and assigns it to U2 using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", this.testUser2, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"4. U2 updates the task as Done using REST");
        this.processTasks = this.restAPI.authenticateUser(this.testUser2).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        RestTaskModel processTask = this.processTasks.getTaskModelByAssignee(this.testUser2);
        this.restAPI.withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask((TaskModel)processTask).updateTask("resolved");
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"5. U1 deletes the task process using REST. Assert that process is deleted successfully among with its tasks.");
        this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).deleteProcess();
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restAPI.withWorkflowAPI().getProcesses().assertThat().entriesListDoesNotContain("id", this.processModel.getId());
        this.restAPI.withWorkflowAPI().getTasks().assertThat().entriesListDoesNotContain("id", processTask.getId());
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify assignee is not able to delete a process after its task is completed.")
    public void deleteWorkflowByAssignee() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates document1 in a public site using WebDAV");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"3. U1 creates a New Task with the document created above and assigns it to U2 using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", this.testUser2, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"4. U2 updates the task as resolved using REST");
        this.processTasks = this.restAPI.authenticateUser(this.testUser2).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        RestTaskModel processTask = this.processTasks.getTaskModelByAssignee(this.testUser2);
        this.restAPI.withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask((TaskModel)processTask).updateTask("resolved");
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"5. U1 updates the task as completed using REST");
        this.restAPI.authenticateUser(this.testUser1).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask((TaskModel)processTask).updateTask("completed");
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"6. U2 deletes the task process using REST. Assert that process is not deleted. ");
        this.restAPI.authenticateUser(this.testUser2).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).deleteProcess();
        this.restAPI.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(String.format(RestErrorModel.ACCESS_INFORMATION_NOT_ALLOWED, this.processModel.getId()));
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify initiator is able to delete a process even if its task is not completed.")
    public void deleteWorkflowWithoutCompletingIt() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates document1 in a public site using CMIS");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"3. U1 creates a New Task with the document created above and assigns it to U2 using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", this.testUser2, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"4. U1 deletes the task process using REST. Assert that process is deleted.");
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).deleteProcess();
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restAPI.withWorkflowAPI().getProcesses().assertThat().entriesListDoesNotContain("id", this.processModel.getId());
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify that document is not created in unauthorized folder (Data Dictonary)")
    public void createUserMakeUnathorizedAction() throws Exception {
        Step.STEP((String)"1. Using CMIS creates one test user: u1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. Using FTP create file in unauthorized folder (Data Dictionary). 3. Verify that document is not created");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.ftpProtocol.authenticateUser(this.testUser1).changeWorkingDirectory(this.ftpProtocol.getDataDictionaryPath()).assertThat().currentFolderIs(this.ftpProtocol.getDataDictionaryPath()).createFile(this.testFile1).assertThat().doesNotExistInFtp();
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify assignee user is able to get a process variable added by another user.")
    public void createWorkflowProcessWithNewProcessVariable() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates 2 documents in User Homes using CMIS");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.testFile2 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file2 content");
        this.cmisAPI.authenticateUser(this.testUser1).usingUserHome().createFile(this.testFile1).assertThat().existsInRepo().createFile(this.testFile2).assertThat().existsInRepo();
        Step.STEP((String)"3. U1 verifies the list of available process definitions using REST");
        RestProcessDefinitionModelsCollection procDefinitions = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().getAllProcessDefinitions();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        procDefinitions.assertThat().entriesListContains("key", "activitiAdhoc");
        Step.STEP((String)"4. U1 creates a workflow of type 'activitiAdhoc' with the documents created above and assign it to u2 using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiAdhoc", this.testUser2, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile2);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. U1 adds a new process variable using REST");
        RestProcessVariableModel variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        RestProcessVariableModel processVariable = this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariable(variableModel);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestProcessVariableModel)((RestProcessVariableModel)processVariable.assertThat().field("name").is((Object)variableModel.getName())).and().field("type").is((Object)variableModel.getType())).and().field("value").is((Object)variableModel.getValue());
        Step.STEP((String)"6. U2 gets the process variables using REST");
        RestProcessVariableCollection processVariables = this.restAPI.authenticateUser(this.testUser2).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables();
        ((RestProcessVariableModel)processVariables.getProcessVariableByName(processVariable.getName()).assertThat().field("type").is((Object)processVariable.getType())).assertThat().field("value").is((Object)processVariable.getValue());
        ((RestProcessVariableModel)processVariables.getProcessVariableByName("bpm_assignee").assertThat().field("type").is((Object)"cm:person")).assertThat().field("value").is((Object)this.testUser2.getUsername());
        ((RestProcessVariableModel)processVariables.getProcessVariableByName("bpm_priority").assertThat().field("type").is((Object)"d:int")).assertThat().field("value").is((Object)CMISUtil.Priority.Normal.getLevel());
        ((RestProcessVariableModel)processVariables.getProcessVariableByName("bpm_sendEMailNotifications").assertThat().field("type").is((Object)"d:boolean")).assertThat().field("value").is((Object)false);
        ((RestProcessVariableModel)processVariables.getProcessVariableByName("initiator").assertThat().field("type").is((Object)"d:noderef")).assertThat().field("value").is((Object)this.testUser1.getUsername());
        ((RestProcessVariableModel)processVariables.getProcessVariableByName("bpm_percentComplete").assertThat().field("type").is((Object)"d:int")).assertThat().field("value").is((Object)0);
        Step.STEP((String)"7. U2 closes the task using REST");
        RestTaskModel processTask = this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks().getTaskModelByAssignee(this.testUser2);
        this.restAPI.withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask((TaskModel)processTask).updateTask("completed");
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"8. Verify that user2 doesn't have access to the documents attached to the task using FTP");
        ((FTPWrapper)((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFile1).assertThat().hasReplyCode(550).and()).assertThat().doesNotExistInFtp().usingResource((ContentModel)this.testFile2).assertThat().hasReplyCode(550).and()).assertThat().doesNotExistInFtp();
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "workflow"}, executionType={ExecutionType.REGRESSION}, description="Verify process variable is process specific, not process definition.")
    public void createWorkflowProcessAndDeleteProcessVariable() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2.");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates 2 documents in User Homes using CMIS");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.testFile2 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file2 content");
        this.cmisAPI.authenticateUser(this.testUser1).usingUserHome().createFile(this.testFile1).assertThat().existsInRepo().createFile(this.testFile2).assertThat().existsInRepo();
        Step.STEP((String)"3. U1 verifies the list of available process definitions using REST");
        RestProcessDefinitionModelsCollection procDefinitions = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().getAllProcessDefinitions();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        procDefinitions.assertThat().entriesListContains("key", "activitiReview");
        Step.STEP((String)"4. U1 creates a workflow of type 'activitiParallelGroupReview' with the documents created above and assign it to u2 using REST");
        this.processModel = this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().addProcess("activitiReview", this.testUser2, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessItem(this.testFile2);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. U1 adds a new process variable using REST");
        RestProcessVariableModel variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        RestProcessVariableModel processVariable = this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariable(variableModel);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestProcessVariableModel)((RestProcessVariableModel)processVariable.assertThat().field("name").is((Object)variableModel.getName())).and().field("type").is((Object)variableModel.getType())).and().field("value").is((Object)variableModel.getValue());
        Step.STEP((String)"6. U2 gets the process variables using REST");
        RestProcessVariableCollection processVariables = this.restAPI.authenticateUser(this.testUser2).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables();
        ((RestProcessVariableModel)processVariables.getProcessVariableByName(processVariable.getName()).assertThat().field("type").is((Object)processVariable.getType())).assertThat().field("value").is((Object)processVariable.getValue());
        ((RestProcessVariableModel)processVariables.getProcessVariableByName("bpm_assignee").assertThat().field("type").is((Object)"cm:person")).assertThat().field("value").is((Object)this.testUser2.getUsername());
        ((RestProcessVariableModel)processVariables.getProcessVariableByName("bpm_priority").assertThat().field("type").is((Object)"d:int")).assertThat().field("value").is((Object)CMISUtil.Priority.Normal.getLevel());
        ((RestProcessVariableModel)processVariables.getProcessVariableByName("bpm_sendEMailNotifications").assertThat().field("type").is((Object)"d:boolean")).assertThat().field("value").is((Object)false);
        ((RestProcessVariableModel)processVariables.getProcessVariableByName("initiator").assertThat().field("type").is((Object)"d:noderef")).assertThat().field("value").is((Object)this.testUser1.getUsername());
        ((RestProcessVariableModel)processVariables.getProcessVariableByName("wf_reviewOutcome").assertThat().field("type").is((Object)"d:text")).assertThat().field("value").is((Object)"Reject");
        Step.STEP((String)"7. U2 closes the task using REST");
        RestTaskModel processTask = this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessTasks().getTaskModelByAssignee(this.testUser2);
        this.restAPI.withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask((TaskModel)processTask).updateTask("completed");
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"8. U1 deletes the new added process variable");
        this.restAPI.authenticateUser(this.testUser1).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).deleteProcessVariable(processVariable);
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"9. U1 starts new 'activitiReview' process. Verify the process doesn't have the process variable added above.");
        this.processModel = this.restAPI.withWorkflowAPI().addProcess("activitiReview", this.testUser2, false, CMISUtil.Priority.Normal);
        this.restAPI.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables().assertThat().entriesListDoesNotContain("name", processVariable.getName());
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify user can get preferences of sites and documents which were updated or deleted")
    @Bug(id="ACE-5769")
    public void getUserPreferencesForSitesAndFiles() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 public sites: s1, s2.");
        SiteModel testSitePublic1 = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        SiteModel testSitePublic2 = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"2. Using CMIS create test users: u1 and u2.");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"3. Using RestAPI add u1 to s1 and s2, u2 to s2.");
        this.dataUser.addUserToSite(this.testUser1, testSitePublic1, UserRole.SiteManager);
        this.dataUser.addUserToSite(this.testUser1, testSitePublic2, UserRole.SiteCollaborator);
        this.dataUser.addUserToSite(this.testUser2, testSitePublic2, UserRole.SiteManager);
        Step.STEP((String)"4. Using RestAPI add all sites to favorites for every user.");
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().addSiteToFavorites(testSitePublic1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        this.restAPI.withCoreAPI().usingAuthUser().addSiteToFavorites(testSitePublic2);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addSiteToFavorites(testSitePublic1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        this.restAPI.withCoreAPI().usingAuthUser().addSiteToFavorites(testSitePublic2);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. Using RestAPI get preferences and check that favorited sites are listed.");
        RestPreferenceModelsCollection restPreferenceModelsCollection = this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().getPersonPreferences();
        restPreferenceModelsCollection.assertThat().paginationField("count").is("4");
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", String.format(PreferenceName.EXT_SITES_FAVORITES_PREFIX.toString(), testSitePublic1.getId()))).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic1.getId()))).and().entriesListContains("id", String.format(PreferenceName.EXT_SITES_FAVORITES_PREFIX.toString(), testSitePublic2.getId()))).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic2.getId()))).and().entriesListContains("value", "true");
        restPreferenceModelsCollection = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().getPersonPreferences();
        restPreferenceModelsCollection.assertThat().paginationField("count").is("4");
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", String.format(PreferenceName.EXT_SITES_FAVORITES_PREFIX.toString(), testSitePublic1.getId()))).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic1.getId()))).and().entriesListContains("id", String.format(PreferenceName.EXT_SITES_FAVORITES_PREFIX.toString(), testSitePublic2.getId()))).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic2.getId()))).and().entriesListContains("value", "true");
        Step.STEP((String)"6. Using RestAPI, u1 removes site1 from favorites, u2 removes site2 from favorites.");
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().removeFavoriteSite(testSitePublic1);
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().removeFavoriteSite(testSitePublic2);
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"7. Using RestAPI get preferences and check that favorited sites are listed. Removed sites are not listed.");
        restPreferenceModelsCollection = this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().getPersonPreferences();
        restPreferenceModelsCollection.assertThat().paginationField("count").is("3");
        ((RestModels)((RestModels)((RestModels)restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", String.format(PreferenceName.EXT_SITES_FAVORITES_PREFIX.toString(), testSitePublic2.getId()))).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic2.getId()))).and().entriesListContains("value", "true");
        restPreferenceModelsCollection = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().getPersonPreferences();
        restPreferenceModelsCollection.assertThat().paginationField("count").is("3");
        ((RestModels)((RestModels)((RestModels)restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", String.format(PreferenceName.EXT_SITES_FAVORITES_PREFIX.toString(), testSitePublic1.getId()))).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic1.getId()))).and().entriesListContains("value", "true");
        Step.STEP((String)"8. Using FTP U1 creates file1 in s1 document library and adds it to favorites using RestAPI. Same for u2 and s2");
        FileModel file1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel file2 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.ftpProtocol.authenticateUser(this.testUser1).usingSite(testSitePublic1).createFile(file1);
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().addFileToFavorites(file1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        this.ftpProtocol.authenticateUser(this.testUser2).usingSite(testSitePublic2).createFile(file2);
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addFileToFavorites(file2);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"9. Using RestAPI U1 and U2 get preferences. Files added to favorites are listed.");
        restPreferenceModelsCollection = this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().getPersonPreferences();
        restPreferenceModelsCollection.assertThat().paginationField("count").is("5");
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", String.format(PreferenceName.EXT_SITES_FAVORITES_PREFIX.toString(), testSitePublic2.getId()))).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic2.getId()))).and().entriesListContains("id", "org.alfresco.ext.documents.favourites.workspace://SpacesStore/" + file1.getNodeRef() + ".createdAt")).and().entriesListContains("value", "workspace://SpacesStore/" + file1.getNodeRef())).and().entriesListContains("value", "true");
        restPreferenceModelsCollection = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().getPersonPreferences();
        restPreferenceModelsCollection.assertThat().paginationField("count").is("5");
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", String.format(PreferenceName.EXT_SITES_FAVORITES_PREFIX.toString(), testSitePublic1.getId()))).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic1.getId()))).and().entriesListContains("id", "org.alfresco.ext.documents.favourites.workspace://SpacesStore/" + file2.getNodeRef() + ".createdAt")).and().entriesListContains("value", "workspace://SpacesStore/" + file2.getNodeRef())).and().entriesListContains("value", "true");
        Step.STEP((String)"10. Using WebDAV rename file1 and file2.");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)file1).rename(file1.getName() + "-updated-file1");
        this.webDavProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)file2).rename(file2.getName() + "-updated-file2");
        Step.STEP((String)"11. Using RestAPI U1 and U2 get preferences. Files renamed are listed.");
        restPreferenceModelsCollection = this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().getPersonPreferences();
        restPreferenceModelsCollection.assertThat().paginationField("count").is("5");
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", String.format(PreferenceName.EXT_SITES_FAVORITES_PREFIX.toString(), testSitePublic2.getId()))).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic2.getId()))).and().entriesListContains("id", "org.alfresco.ext.documents.favourites.workspace://SpacesStore/" + file1.getNodeRef() + ".createdAt")).and().entriesListContains("value", "workspace://SpacesStore/" + file1.getNodeRef())).and().entriesListContains("value", "true");
        restPreferenceModelsCollection = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().getPersonPreferences();
        restPreferenceModelsCollection.assertThat().paginationField("count").is("5");
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", String.format(PreferenceName.EXT_SITES_FAVORITES_PREFIX.toString(), testSitePublic1.getId()))).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic1.getId()))).and().entriesListContains("id", "org.alfresco.ext.documents.favourites.workspace://SpacesStore/" + file2.getNodeRef() + ".createdAt")).and().entriesListContains("value", "workspace://SpacesStore/" + file2.getNodeRef())).and().entriesListContains("value", "true");
        Step.STEP((String)"12. Using FTP delete files.");
        this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)file1).delete();
        this.ftpProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)file2).delete();
        Step.STEP((String)"13. Using CMIS delete site1.");
        ((DataSite)this.dataSite.usingUser(this.admin)).deleteSite(testSitePublic1);
        Step.STEP((String)"14. Using RestAPI get preferences. Files and sites deleted are not listed anymore as favorites.");
        restPreferenceModelsCollection = this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().getPersonPreferences();
        restPreferenceModelsCollection.assertThat().paginationField("count").is("2");
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", String.format(PreferenceName.EXT_SITES_FAVORITES_PREFIX.toString(), testSitePublic2.getId()))).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic2.getId()))).and().entriesListDoesNotContain("id", "org.alfresco.ext.documents.favourites.workspace://SpacesStore/" + file1.getNodeRef() + ".createdAt")).and().entriesListDoesNotContain("value", "workspace://SpacesStore/" + file1.getNodeRef())).and().entriesListContains("value", "true");
        restPreferenceModelsCollection = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().getPersonPreferences();
        restPreferenceModelsCollection.assertThat().paginationField("count").is("2");
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListDoesNotContain("id", String.format(PreferenceName.EXT_SITES_FAVORITES_PREFIX.toString(), testSitePublic1.getId()))).and().entriesListDoesNotContain("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic1.getId()))).and().entriesListDoesNotContain("id", "org.alfresco.ext.documents.favourites.workspace://SpacesStore/" + file2.getNodeRef() + ".createdAt")).and().entriesListDoesNotContain("value", "workspace://SpacesStore/" + file2.getNodeRef())).and().entriesListContains("value", "true");
    }

    @Bug(id="ACE-5769")
    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify user can get preference of sites and documents which were updated or deleted")
    public void getPreferenceForSiteAndFiles() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates public test site U1 creates a public test site using CMIS");
        SiteModel testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. U1 adds U2 as site member with manager role using RestAPI");
        ((DataUser)this.dataUser.usingUser(this.testUser1)).addUserToSite(this.testUser2, testSitePublic, UserRole.SiteManager);
        this.testUser2.setUserRole(UserRole.SiteManager);
        Step.STEP((String)"4. U2 adds site to favorites using RestAPI");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addSiteToFavorites(testSitePublic);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. U2 gets preference 'org.alfresco.ext.sites.favourites.testsite.createdAt' using RestAPI");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic.getId()));
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"6. U2 remove site from favorites using RestAPI");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().removeFavoriteSite(testSitePublic);
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"7. U2 gets preference 'org.alfresco.ext.sites.favourites.testsite.createdAt' using RestAPI");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic.getId()));
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        Step.STEP((String)"8. U2 creates file1 in test site's document library using FTP and adds it to favorites using RestAPI");
        FileModel file1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.ftpProtocol.authenticateUser(this.testUser2).usingSite(testSitePublic).createFile(file1);
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addFileToFavorites(file1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"9. U2 gets preference 'org.alfresco.ext.documents.favourites.workspace://SpacesStore/<guid>.createdAt' using RestAPI");
        RestPreferenceModel preference = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(PreferenceName.DOCUMENTS_FAVORITES_PREFIX.toString());
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        preference.assertThat().field("value").is((Object)("workspace://SpacesStore/" + file1.getNodeRefWithoutVersion()));
        Step.STEP((String)"10. U2 removes file1 from favorites using RestAPI");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().deleteFileFromFavorites(file1);
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"11. U2 gets preference 'org.alfresco.share.documents.favourite' using RestAPI");
        preference = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(PreferenceName.DOCUMENTS_FAVORITES_PREFIX.toString());
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        preference.assertThat().field("value").isNull();
        Step.STEP((String)"12. U2 adds file1 to favorites using RestAPI and renames file1 to file-updated with WebDAV");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addFileToFavorites(file1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        this.webDavProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)file1).rename(file1.getName() + "-updated");
        Step.STEP((String)"13. U2 gets preference 'org.alfresco.ext.documents.favourites.workspace://SpacesStore/<guid>.createdAt' using RestAPI");
        preference = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(PreferenceName.DOCUMENTS_FAVORITES_PREFIX.toString());
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        preference.assertThat().field("value").is((Object)("workspace://SpacesStore/" + file1.getNodeRefWithoutVersion()));
        Step.STEP((String)"14. U2 adds file1 to favorites using RestAPI and deletes file-updated with CMIS");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addFileToFavorites(file1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        this.cmisAPI.authenticateUser(this.testUser2).usingResource((ContentModel)file1).delete();
        Step.STEP((String)"15. U2 gets preference 'org.alfresco.ext.documents.favourites.workspace://SpacesStore/<guid>.createdAt' using RestAPI");
        preference = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(PreferenceName.DOCUMENTS_FAVORITES_PREFIX.toString());
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        preference.assertThat().field("value").isNull();
        Step.STEP((String)"16. U2 adds site to favorites with RestAPI and U1 deletes site1 with CMIS");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addSiteToFavorites(testSitePublic);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((DataSite)this.dataSite.usingUser(this.testUser1)).deleteSite(testSitePublic);
        Step.STEP((String)"17. U2 gets preference 'org.alfresco.ext.sites.favourites.site1.createdAt' using RestAPI");
        preference = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), testSitePublic.getId()));
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        preference.assertThat().field("value").isNull();
    }

    @Bug(id="REPO-2419", status=Bug.Status.FIXED)
    @Test(groups={"protocols", "webdav", "full"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that the version of a new file uploaded through WebDAV is 1.0 with the real content size.")
    public void uploadedFileThroughWebdavHasFirstVersion() throws Exception {
        UserModel managerUser = this.dataUser.createRandomTestUser();
        SiteModel testSite = ((DataSite)this.dataSite.usingUser(managerUser)).createPublicRandomSite();
        Step.STEP((String)"0. Verify versionable aspect is set for all contents using webscript");
        String fileCreationWebScript = "alfresco/s/api/classes/cm_content";
        RestAssured.basePath = "";
        this.restAPI.configureRequestSpec().setBasePath(RestAssured.basePath);
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)fileCreationWebScript, (String[])new String[0]);
        RestResponse response = this.restAPI.authenticateUser(this.admin).process(request);
        Assert.assertEquals((int)response.getResponse().getStatusCode(), (int)HttpStatus.OK.value());
        try {
            response.assertThat().body(Matchers.containsString((String)"cm:versionable"), new Matcher[0]);
            response.assertThat().body("defaultAspects.'cm:versionable'.title", Matchers.equalTo((Object)"Versionable"), new Object[0]);
        }
        catch (AssertionError ae) {
            throw new SkipException("Skipping this test because the versionable aspect is not applied. Please add the versionable aspect to all content in contentModel.xml and run the test again.");
        }
        Step.STEP((String)"1. Upload a local file on a new folder using WebDAV protocol");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(managerUser).usingSite(testSite)).createFolder();
        File fileToUpload = Utility.getTestResourceFile((String)"shared-resources/testdata/nonemptyupload.txt");
        this.webDavProtocol.authenticateUser(managerUser).usingSite(testSite).usingResource((ContentModel)folder).uploadFile(fileToUpload);
        FileModel file = new FileModel(fileToUpload.getName());
        Step.STEP((String)"2. Verify version is exactly 1.0 and the size is the same as the local file");
        ((DataContent)this.dataContent.usingResource((ContentModel)file)).assertContentVersionIs("1.0");
        ((DataContent)this.dataContent.usingResource((ContentModel)file)).assertContentSizeIs(19L);
    }
}

