/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tas.integration;

import io.restassured.RestAssured;
import java.util.HashMap;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestPersonModel;
import org.alfresco.tas.integration.IntegrationTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class IntegrationWithWebScriptsTests
extends IntegrationTest {
    @Test(groups={"integration", "rest-api", "full"})
    @TestRail(section={"integration", "rest-api"}, executionType={ExecutionType.REGRESSION}, description="Verify when importing multiple users via CSV, if the password is not set in the CSV file, user will be disable")
    public void verifyCSVUserImportDisableUserAndGivesRandomPasswordIfItIsMissing() throws Exception {
        Step.STEP((String)"1.Upload the CSV File that contains the users.");
        this.restAPI.authenticateUser(this.dataUser.getAdminUser()).configureRequestSpec().addMultiPart("filedata", Utility.getResourceTestDataFile((String)"userCSV.csv"));
        RestAssured.basePath = "alfresco";
        this.restAPI.configureRequestSpec().setBasePath(RestAssured.basePath);
        String fileCreationWebScript = "s/api/people/upload";
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.POST, (String)fileCreationWebScript, (String[])new String[0]);
        this.restAPI.authenticateUser(this.dataUser.getAdminUser()).process(request);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"2.Verify that user1np is disabled and user2 is enabled");
        UserModel disabledUserPerson = new UserModel("MNT-171990-user-with-no-password", "user1");
        UserModel enabledUserPerson = new UserModel("MNT-171990-user-with-password", "user2");
        RestPersonModel personModel = this.restAPI.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingUser(new UserModel(disabledUserPerson.getUsername(), disabledUserPerson.getPassword())).getPerson();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        personModel.assertThat().field("enabled").is((Object)"false");
        personModel = this.restAPI.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingUser(new UserModel(enabledUserPerson.getUsername(), enabledUserPerson.getPassword())).getPerson();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        personModel.assertThat().field("enabled").is((Object)"true");
        Step.STEP((String)"3.Activate the disabled user.");
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("enabled", "true");
        String putBody = JsonBodyGenerator.keyValueJson(input);
        this.restAPI.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingUser(disabledUserPerson).updatePerson(putBody);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4.Verify that the disabled user has a randomly generated password not the same as firstname(DOCS-2755)");
        this.restAPI.authenticateUser(disabledUserPerson).withCoreAPI().usingUser(new UserModel(enabledUserPerson.getUsername(), enabledUserPerson.getPassword())).getPerson();
        this.restAPI.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
        Step.STEP((String)"5.Change the user password and try an Rest API call.");
        input = new HashMap();
        input.put("password", "newPassword1");
        putBody = JsonBodyGenerator.keyValueJson(input);
        this.restAPI.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingUser(disabledUserPerson).updatePerson(putBody);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        disabledUserPerson = new UserModel(disabledUserPerson.getUsername(), "newPassword1");
        this.restAPI.authenticateUser(disabledUserPerson).withCoreAPI().usingUser(new UserModel(enabledUserPerson.getUsername(), enabledUserPerson.getPassword())).getPerson();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        ((DataUser)this.dataUser.usingAdmin()).deleteUser(disabledUserPerson);
        ((DataUser)this.dataUser.usingAdmin()).deleteUser(enabledUserPerson);
    }
}

