/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tas.integration;

import jakarta.mail.FolderNotFoundException;
import junit.framework.Assert;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.email.ImapWrapper;
import org.alfresco.ftp.FTPWrapper;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestPersonFavoritesModel;
import org.alfresco.rest.model.RestPersonFavoritesModelsCollection;
import org.alfresco.rest.model.RestRatingModel;
import org.alfresco.tas.integration.IntegrationTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavWrapper;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class IntegrationCoreTests
extends IntegrationTest {
    UserModel testUser1;
    UserModel testUser2;
    SiteModel testSitePublic;
    SiteModel testSiteModerated;
    SiteModel testSitePrivate;
    SiteModel secondPublicSite;
    FolderModel testFolder1;
    FolderModel testFolder2;
    FolderModel parentFolder1;
    private String renamePrefix = "edited-";
    FileModel testFile1;
    FileModel testFile2;
    FileModel childDoc1;
    FileModel childDoc2;
    FileModel childDoc3;
    FileModel childDoc4;
    FileModel childDoc5;
    RestRatingModel returnedRatingModel;
    RestPersonFavoritesModel restPersonFavoritesModel;
    private String newContent = "new TAS content";

    @Test(groups={"integration", "core"}, expectedExceptions={FolderNotFoundException.class})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to move a folder with a file to a public site if he is not a member of that site.")
    public void moveFolderWithFileToPublicSiteByUninvitedUser() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public test site and U2 a public test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.secondPublicSite = ((DataSite)this.dataSite.usingUser(this.testUser2)).createIMAPSite();
        Step.STEP((String)"3. U1 creates a folder with a file in public site's document library using WebDav");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).assertThat().existsInWebdav().usingResource((ContentModel)this.testFolder1).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"4. U1 tries to move his folder to U2 public site using IMAP. 5. Verify folder with file is not moved. U1 is not authorized to access the U2 public site");
        FolderModel destination = new FolderModel(Utility.buildPath((String)"Sites", (String[])new String[]{this.secondPublicSite.getId(), "documentLibrary"}));
        destination.setProtocolLocation(this.imapProtocol.authenticateUser(this.testUser2).usingSite(this.secondPublicSite).getLastResourceWithoutPrefix());
        this.imapProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).moveTo((ContentModel)destination).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able to delete parent folder along with all its children using CMIS.")
    public void deleteFolderWithChildrenUsingCMIS() throws Exception {
        Step.STEP((String)"1. Using CMIS create 1 test user: u1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createIMAPSite();
        Step.STEP((String)"3. U1 creates a folder (parentFolder) inside public site's document library using WebDav");
        FolderModel parentFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(parentFolder).assertThat().existsInWebdav().and()).assertThat().existsInRepo();
        Step.STEP((String)"4. Inside parentFolder create 4 files using CMIS, WebDAV, FTP");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel testFile2 = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        FileModel testFile3 = FileModel.getRandomFileModel((FileType)FileType.HTML);
        FileModel testFile4 = FileModel.getRandomFileModel((FileType)FileType.EXE);
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)parentFolder).createFile(this.testFile1).assertThat().existsInRepo();
        ((WebDavWrapper)this.webDavProtocol.usingResource((ContentModel)parentFolder).createFile(testFile2).assertThat().existsInWebdav().and()).assertThat().existsInRepo();
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)parentFolder).createFile(testFile3).assertThat().existsInRepo();
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)parentFolder).createFile(testFile4).assertThat().existsInFtp().and()).assertThat().existsInRepo();
        Step.STEP((String)"5. Inside parentFolder create 1 subfolder using IMAP");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)parentFolder).createFolder(this.testFolder1).assertThat().existsInImap().and()).assertThat().existsInRepo();
        Step.STEP((String)"6. Delete parentFolder using CMIS 7. Verify folder is deleted along with all its children");
        ((CmisWrapper)this.cmisAPI.usingResource((ContentModel)parentFolder).deleteFolderTree().and()).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFolder1).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile1).assertThat().doesNotExistInRepo().usingResource((ContentModel)testFile2).assertThat().doesNotExistInRepo().usingResource((ContentModel)testFile3).assertThat().doesNotExistInRepo().usingResource((ContentModel)testFile4).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able to delete parent folder along with all its children using WebDAV.")
    public void deleteFolderWithChildrenUsingWebDAV() throws Exception {
        Step.STEP((String)"1. Using CMIS create 1 test user: u1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createIMAPSite();
        Step.STEP((String)"3. U1 creates a folder (parentFolder) inside public site's document library using IMAP");
        FolderModel parentFolder = FolderModel.getRandomFolderModel();
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(parentFolder).assertThat().existsInImap().and()).assertThat().existsInRepo();
        Step.STEP((String)"4. Inside parentFolder create 4 files using CMIS, WebDAV, FTP");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel testFile2 = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        FileModel testFile3 = FileModel.getRandomFileModel((FileType)FileType.HTML);
        FileModel testFile4 = FileModel.getRandomFileModel((FileType)FileType.EXE);
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)parentFolder).createFile(this.testFile1).assertThat().existsInRepo();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)parentFolder).createFile(testFile2).assertThat().existsInWebdav().and()).assertThat().existsInRepo();
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)parentFolder).createFile(testFile4).assertThat().existsInFtp().and()).assertThat().existsInRepo();
        Step.STEP((String)"5. Inside parentFolder create 1 subfolder using WebDAV");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)this.webDavProtocol.usingResource((ContentModel)parentFolder).createFolder(this.testFolder1).assertThat().existsInWebdav().and()).assertThat().existsInRepo();
        Step.STEP((String)"6. Delete parentFolder using WebDAV 7. Verify folder is deleted along with all its children");
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.usingResource((ContentModel)parentFolder).delete().and()).assertThat().doesNotExistInRepo()).usingResource((ContentModel)this.testFolder1).assertThat().doesNotExistInRepo()).usingResource((ContentModel)this.testFile1).assertThat().doesNotExistInRepo()).usingResource((ContentModel)testFile2).assertThat().doesNotExistInRepo()).usingResource((ContentModel)testFile3).assertThat().doesNotExistInRepo()).usingResource((ContentModel)testFile4).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able to delete parent folder along with all its children using FTP.")
    public void deleteFolderWithChildrenUsingFTP() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public test site using CMIS and adds u2 as manager to his site using REST");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        ((DataUser)this.dataUser.usingUser(this.testUser1)).addUserToSite(this.testUser2, this.testSitePublic, UserRole.SiteManager);
        this.testUser2.setUserRole(UserRole.SiteManager);
        Step.STEP((String)"3. U1 creates a folder (parentFolder) inside public site's document library using CMIS");
        FolderModel parentFolder = FolderModel.getRandomFolderModel();
        this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(parentFolder).assertThat().existsInRepo();
        Step.STEP((String)"4. U1 creates a subfolder1 and a file1 inside parentFolder using FTP");
        FolderModel subFolder1 = FolderModel.getRandomFolderModel();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((FTPWrapper)((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)parentFolder).createFolder(subFolder1).assertThat().existsInRepo()).assertThat().existsInFtp().usingResource((ContentModel)parentFolder).createFile(this.testFile1).assertThat().existsInRepo()).assertThat().existsInFtp();
        Step.STEP((String)"5. U1 creates a subfolder2 and a file2 inside subfolder1 using CMIS");
        FolderModel subFolder2 = FolderModel.getRandomFolderModel();
        FileModel testFile2 = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)subFolder1).createFolder(subFolder2).assertThat().existsInRepo().createFile(testFile2).assertThat().existsInRepo();
        Step.STEP((String)"6. U2 creates a subfolder3 and a file3 using WebDAV");
        FolderModel subFolder3 = FolderModel.getRandomFolderModel();
        FileModel testFile3 = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)subFolder2).createFolder(subFolder3).assertThat().existsInWebdav().assertThat().existsInRepo()).createFile(testFile3).assertThat().existsInWebdav().assertThat().existsInRepo();
        Step.STEP((String)"7. U2 deletes parentFolder using FTP");
        ((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)parentFolder).assertThat().existsInFtp().then()).delete().assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInFtp().usingResource((ContentModel)subFolder1).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInFtp().usingResource((ContentModel)subFolder2).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInFtp().usingResource((ContentModel)subFolder3).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInFtp().usingResource((ContentModel)this.testFile1).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInFtp().usingResource((ContentModel)testFile2).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInFtp().usingResource((ContentModel)testFile3).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInFtp();
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify deletion of a parentFolder with checkedout file using CMIS.")
    public void deleteParentFolderWithCheckoutFileInUsingCMIS() throws Exception {
        Step.STEP((String)"1. Using CMIS create one test user: U1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. Using CMIS U1 creates a public test site");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. Using CMIS, WebDAV and FTP U1 creates multiple files and folders in parent folder");
        FileModel cmisTestFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file 1 content");
        FileModel webdavTestFile = FileModel.getRandomFileModel((FileType)FileType.HTML, (String)"file 2 content");
        FileModel ftpTestFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)"file 4 content");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).assertThat().existsInRepo();
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFile(cmisTestFile).assertThat().existsInRepo();
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFile(webdavTestFile).assertThat().existsInWebdav().assertThat().existsInRepo();
        this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFile(ftpTestFile).assertThat().existsInFtp().assertThat().existsInRepo();
        FolderModel cmisTestFolder = FolderModel.getRandomFolderModel();
        FolderModel webdavTestFolder = FolderModel.getRandomFolderModel();
        FolderModel ftpTestFolder = FolderModel.getRandomFolderModel();
        this.cmisAPI.usingResource((ContentModel)this.testFolder1).createFolder(cmisTestFolder).assertThat().existsInRepo();
        this.webDavProtocol.usingResource((ContentModel)this.testFolder1).createFolder(webdavTestFolder).assertThat().existsInWebdav().assertThat().existsInRepo();
        this.ftpProtocol.usingResource((ContentModel)this.testFolder1).createFolder(ftpTestFolder).assertThat().existsInFtp().assertThat().existsInRepo();
        this.cmisAPI.usingResource((ContentModel)this.testFolder1).assertThat().hasChildren(new ContentModel[]{cmisTestFile, webdavTestFile, ftpTestFile, cmisTestFolder, webdavTestFolder, ftpTestFolder});
        Step.STEP((String)"Step 4: Using CMIS, U1 checks out a document from parent folder");
        this.cmisAPI.usingResource((ContentModel)webdavTestFile).checkOut().assertThat().documentIsCheckedOut();
        Step.STEP((String)"Step 5: Using CMIS, U1 deletes parent folder (deleteTree)");
        this.cmisAPI.usingResource((ContentModel)this.testFolder1).deleteFolderTree().assertThat().doesNotExistInRepo();
        Step.STEP((String)"Step 6. Using WebDAV, U1 verifies that parent folder and all children are not present");
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.usingResource((ContentModel)this.testFolder1).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInWebdav().and()).usingResource((ContentModel)cmisTestFile).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInWebdav().and()).usingResource((ContentModel)webdavTestFile).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInWebdav().and()).usingResource((ContentModel)ftpTestFile).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInWebdav().and()).usingResource((ContentModel)cmisTestFolder).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInWebdav().and()).usingResource((ContentModel)webdavTestFolder).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInWebdav().and()).usingResource((ContentModel)ftpTestFolder).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInWebdav();
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify deletion of a parentFolder with checkedout file using WebDAV.")
    public void deleteParentFolderWithCheckoutFileInUsingWebDAV() throws Exception {
        Step.STEP((String)"1. Using CMIS create one test user: U1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. Using CMIS U1 creates a public test site");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. Using FTP U1 creates a parent folder");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).assertThat().existsInRepo();
        Step.STEP((String)"4. Using CMIS, WebDAV and FTP U1 creates multiple files and folders in parent folder");
        FileModel cmisTestFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file 1 content");
        FileModel webdavTestFile = FileModel.getRandomFileModel((FileType)FileType.HTML, (String)"file 2 content");
        FileModel ftpTestFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)"file 4 content");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFile(cmisTestFile).assertThat().existsInRepo();
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFile(webdavTestFile).assertThat().existsInWebdav().assertThat().existsInRepo();
        this.ftpProtocol.usingResource((ContentModel)this.testFolder1).createFile(ftpTestFile).assertThat().existsInFtp().assertThat().existsInRepo();
        FolderModel cmisTestFolder = FolderModel.getRandomFolderModel();
        FolderModel webdavTestFolder = FolderModel.getRandomFolderModel();
        this.cmisAPI.usingResource((ContentModel)this.testFolder1).createFolder(cmisTestFolder).assertThat().existsInRepo();
        ((WebDavWrapper)this.webDavProtocol.usingResource((ContentModel)this.testFolder1).createFolder(webdavTestFolder).assertThat().existsInWebdav().and()).assertThat().existsInRepo();
        this.cmisAPI.usingResource((ContentModel)this.testFolder1).assertThat().hasChildren(new ContentModel[]{cmisTestFile, webdavTestFile, ftpTestFile, cmisTestFolder, webdavTestFolder});
        Step.STEP((String)"Step 5: Using CMIS, U1 checks out a document from parent folder");
        this.cmisAPI.usingResource((ContentModel)cmisTestFile).checkOut().assertThat().documentIsCheckedOut();
        Step.STEP((String)"Step 6: Using WebDAV, U1 deletes parent folder (deleteFolder)");
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.usingResource((ContentModel)this.testFolder1).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).assertThat().hasFiles(new FileModel[]{cmisTestFile, webdavTestFile, ftpTestFile}).and()).assertThat().hasFolders(new FolderModel[]{cmisTestFolder, webdavTestFolder}).then()).usingResource((ContentModel)this.testFolder1).delete().assertThat().doesNotExistInWebdav().assertThat().doesNotExistInRepo();
        Step.STEP((String)"Step 7. Using FTP, U1 verifies that parent folder and all children are not present");
        ((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)((FTPWrapper)this.ftpProtocol.usingResource((ContentModel)this.testFolder1).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInFtp().and()).usingResource((ContentModel)cmisTestFile).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInFtp().and()).usingResource((ContentModel)webdavTestFile).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInFtp().and()).usingResource((ContentModel)ftpTestFile).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInFtp().and()).usingResource((ContentModel)cmisTestFolder).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInFtp().and()).usingResource((ContentModel)webdavTestFolder).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInFtp();
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify deletion of a parentFolder with checkedout file using FTP.")
    public void deleteParentFolderWithCheckoutFileInUsingFTP() throws Exception {
        Step.STEP((String)"1. Using CMIS create one test user: U1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. Using CMIS U1 creates a public test site");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. Using WebDAV U1 creates a parent folder");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).assertThat().existsInRepo()).assertThat().existsInWebdav();
        Step.STEP((String)"4. Using CMIS, WebDAV and FTP U1 creates multiple files and folders in parent folder");
        FileModel cmisTestFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file 1 content");
        FileModel webdavTestFile = FileModel.getRandomFileModel((FileType)FileType.HTML, (String)"file 2 content");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFile(cmisTestFile).assertThat().existsInRepo();
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFile(webdavTestFile).assertThat().existsInWebdav().assertThat().existsInRepo();
        FolderModel cmisTestFolder = FolderModel.getRandomFolderModel();
        FolderModel webdavTestFolder = FolderModel.getRandomFolderModel();
        FolderModel ftpTestFolder = FolderModel.getRandomFolderModel();
        this.cmisAPI.usingResource((ContentModel)this.testFolder1).createFolder(cmisTestFolder).assertThat().existsInRepo();
        this.webDavProtocol.usingResource((ContentModel)this.testFolder1).createFolder(webdavTestFolder).assertThat().existsInWebdav().assertThat().existsInRepo();
        this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFolder(ftpTestFolder).assertThat().existsInFtp().assertThat().existsInRepo();
        this.cmisAPI.usingResource((ContentModel)this.testFolder1).assertThat().hasChildren(new ContentModel[]{cmisTestFile, webdavTestFile, cmisTestFolder, webdavTestFolder, ftpTestFolder});
        Step.STEP((String)"Step 5: Using CMIS, U1 checks out a document from parent folder");
        this.cmisAPI.usingResource((ContentModel)webdavTestFile).checkOut().assertThat().documentIsCheckedOut();
        Step.STEP((String)"Step 6: Using FTP, U1 deletes parent folder (deleteDirectory)");
        ((FTPWrapper)((FTPWrapper)this.ftpProtocol.usingResource((ContentModel)this.testFolder1).delete().and()).assertThat().doesNotExistInFtp().and()).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify user with collaborator role can update document content in a public site.")
    public void usersCanUpdateDocumentContentInsideAPublicSite() throws Exception {
        String originalContent = "originalContent";
        String updatedContent = "updatedContent";
        this.testFolder1 = FolderModel.getRandomFolderModel();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        Step.STEP((String)"1. Using CMIS create 2 test users: U1 and U2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. Using CMIS and RestAPI U1 creates a public test site and U2 user is added with collaborator role");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testUser2.setUserRole(UserRole.SiteCollaborator);
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingSite(this.testSitePublic).addPerson(this.testUser2);
        Step.STEP((String)"3. Using WebDAV U1 creates a folder in his public site's document library");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).and()).assertThat().existsInRepo();
        Step.STEP((String)"4. Using WebDAV U1 creates a document inside the above folder");
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFile(this.testFile1).and()).assertThat().existsInWebdav().and()).assertThat().existsInRepo();
        Step.STEP((String)"5. Using RestAPI U2 adds the document to favorites");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addFolderToFavorites(this.testFolder1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"6. Using CMIS U1 adds content to document");
        ((CmisWrapper)((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).and()).assertThat().existsInRepo().and()).update(originalContent);
        Step.STEP((String)"7. Using WebDAV U2 validates document's content");
        this.webDavProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFile1).assertThat().contentIs(originalContent);
        Step.STEP((String)"8. Using WebDAV U2 updates content from document");
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.usingUser(this.testUser2)).usingResource((ContentModel)this.testFile1).assertThat().existsInRepo()).and()).update(updatedContent);
        Step.STEP((String)"9. Using CMIS U2 validates document's content");
        this.cmisAPI.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFile1).assertThat().contentIs(updatedContent);
        Step.STEP((String)"10. Using WebDAV U1 deletes the file");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).delete().and()).assertThat().doesNotExistInRepo();
        Step.STEP((String)"11. Using WebDAV U1 deletes the folder");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).delete().and()).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "core"}, expectedExceptions={CmisPermissionDeniedException.class, CmisUnauthorizedException.class})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify user with contributor role can like/favorite a document in a public site.")
    public void usersCanLikeADocumentInPublicSite() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: U1 and U2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. Using RestAPI U1 creates a public test site and U2 user is added with contributor role");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testUser2.setUserRole(UserRole.SiteContributor);
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingSite(this.testSitePublic).addPerson(this.testUser2);
        Step.STEP((String)"3. Using WebDAV U1 creates a folder in his public site's document library");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).assertThat().existsInWebdav().and()).assertThat().existsInRepo();
        Step.STEP((String)"4. Using WebDAV U1 creates a document1 inside the above folder");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.usingResource((ContentModel)this.testFolder1).createFile(this.testFile1).assertThat().existsInRepo()).and()).assertThat().existsInWebdav();
        Step.STEP((String)"5. Using WebDAV U2 creates a document2 inside folder");
        this.testFile2 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFolder1).createFile(this.testFile2).assertThat().existsInRepo()).and()).assertThat().existsInWebdav();
        Step.STEP((String)"6. Using RestAPI U2 likes document1");
        RestRatingModel returnedRatingModel = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingResource((RepoTestModel)this.testFile1).likeDocument();
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
        Step.STEP((String)"7. Using RestAPI U1 likes document2");
        returnedRatingModel = this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingResource((RepoTestModel)this.testFile2).likeDocument();
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
        Step.STEP((String)"8. Using RestAPI U1 dislikes document2");
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingResource((RepoTestModel)this.testFile2).deleteLikeRating();
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"9. Using RestAPI U2 add to favorites document1");
        RestPersonFavoritesModel restPersonFavoritesModel = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addFileToFavorites(this.testFile1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)this.testFile1.getNodeRefWithoutVersion());
        Step.STEP((String)"10. Using CMIS U1 delete document1");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).delete().and()).assertThat().doesNotExistInRepo();
        this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile1).getLikeRating();
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.testFile1.getNodeRef()));
        RestPersonFavoritesModelsCollection userFavorites = this.restAPI.withCoreAPI().usingAuthUser().getFavorites();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)userFavorites.assertThat().entriesListIsEmpty()).and().paginationField("totalItems").is("0");
        Step.STEP((String)"11. Using CMIS U2 delete the folder. With Contributor role, U2 does not have permission to delete files/folders created by others.");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFolder1).assertThat().doesNotHaveFile(new FileModel[]{this.testFile1}).and()).assertThat().hasFiles(new FileModel[]{this.testFile2}).and()).usingResource((ContentModel)this.testFile2).delete().and()).usingResource((ContentModel)this.testFolder1).delete();
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify user with collaborator role can rate a document in a public site.")
    public void usersCanRateADocumentInPublicSite() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: U1 and U2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. Using RestAPI U1 creates a public test site and U2 user is added with collaborator role");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testUser2.setUserRole(UserRole.SiteCollaborator);
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingSite(this.testSitePublic).addPerson(this.testUser2);
        Step.STEP((String)"3. Using CMIS U1 creates a new folder in site");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).assertThat().existsInRepo();
        Step.STEP((String)"4. Using WebDAV U2 creates file1 in public site document library");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFolder1).createFile(this.testFile1).assertThat().existsInRepo()).and()).assertThat().existsInWebdav();
        Step.STEP((String)"5. Using WebDAV U1 creates a file2 in public site document library");
        this.testFile2 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).usingResource((ContentModel)this.testFolder1).createFile(this.testFile2).assertThat().existsInRepo();
        Step.STEP((String)"6. Using RestAPI U2 rates with 5 stars file2");
        RestRatingModel returnedRatingModel = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingResource((RepoTestModel)this.testFile2).rateStarsToDocument(5);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
        Step.STEP((String)"7. Using RestAPI U1 rates with 1 star file1");
        returnedRatingModel = this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingResource((RepoTestModel)this.testFile1).rateStarsToDocument(1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)returnedRatingModel.assertThat().field("myRating").is((Object)"1")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
        Step.STEP((String)"8. Using RestAPI U2 likes file1");
        returnedRatingModel = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingResource((RepoTestModel)this.testFile1).likeDocument();
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
        Step.STEP((String)"9. Using RestAPI U2 removes the rating of 5 stars for file2");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingResource((RepoTestModel)this.testFile2).deleteFiveStarRating();
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        returnedRatingModel = this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile2).getFiveStarRating();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        returnedRatingModel.getAggregate().assertThat().field("numberOfRatings").is((Object)"0");
        Step.STEP((String)"10. Using WebDAV U1 delete file1. Using RestAPI get ratings of file1.");
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).delete().and()).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInWebdav();
        this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile1).getLikeRating();
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.testFile1.getNodeRef()));
        this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile1).getFiveStarRating();
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.testFile1.getNodeRef()));
        Step.STEP((String)"11. Using WebDAV U1 delete the folder");
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).assertThat().hasFiles(new FileModel[]{this.testFile2}).and()).usingResource((ContentModel)this.testFolder1).delete().and()).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="File handling - perform actions: create, delete, add comment, like and rate, update file content ")
    public void fileHandlingCreateUpdateContentDeleteLikeAndRate() throws Exception {
        Step.STEP((String)"1. Using CMIS create 1 test user: U1 and U2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createIMAPSite();
        Step.STEP((String)"3. Using FTP U1 creates folder: folder1");
        FolderModel folder1 = FolderModel.getRandomFolderModel();
        this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(folder1).assertThat().existsInRepo();
        Step.STEP((String)"4. Using WebDAV U1 creates folder2 inside folder1");
        FolderModel folder2 = FolderModel.getRandomFolderModel();
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)folder1).createFolder(folder2);
        Step.STEP((String)"5. Using webDAV U1 creates folder3 inside folder2");
        FolderModel folder3 = FolderModel.getRandomFolderModel();
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)folder2).createFolder(folder3);
        Step.STEP((String)"6. Using CMIS U1 creates file1 inside folder1");
        FileModel file1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file 1 content");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)folder1).createFile(file1).assertThat().existsInRepo();
        Step.STEP((String)"7. Using webDAV U1 creates file2 inside folder2");
        FileModel file2 = FileModel.getRandomFileModel((FileType)FileType.HTML, (String)"file 2 content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)folder2).createFile(file2).assertThat().existsInWebdav().assertThat().existsInRepo();
        Step.STEP((String)"8. Using FTP U1 creates file3 inside folder3");
        FileModel file3 = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)"file 3 content");
        this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)folder3).createFile(file3).assertThat().existsInRepo();
        Step.STEP((String)"9. Using webDAV U1 deletes file1");
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)file1).delete().assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInWebdav();
        Step.STEP((String)"10. Using IMAP U1 deletes file2");
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)file2).deleteMessage().and()).usingResource((ContentModel)file2).assertThat().doesNotExistInRepo();
        Step.STEP((String)"11. Using WebDAV U1 update content of file3");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)file3).assertThat().existsInRepo()).update(this.newContent).assertThat().contentIs(this.newContent);
        Step.STEP((String)"12. Using RestAPI U1 adds a comment to file3");
        String comment = RandomData.getRandomName((String)"comment1");
        file3.setNodeRef(((DataContent)((DataContent)((DataContent)this.dataContent.usingUser(this.testUser1).usingSite(this.testSitePublic)).usingResource((ContentModel)folder3)).usingResource((ContentModel)file3)).getNodeRef());
        RestCommentModel commentModel = this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingResource((RepoTestModel)file3).addComment(comment);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestCommentModel)commentModel.assertThat().field("content").isNotEmpty()).and().field("content").is((Object)comment);
        Step.STEP((String)"13. Using RestAPI U1 likes file3 and user U2 rates file3");
        this.returnedRatingModel = this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingResource((RepoTestModel)file3).likeDocument();
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
        this.returnedRatingModel = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingResource((RepoTestModel)file3).rateStarsToDocument(5);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
        Step.STEP((String)"14. Using CMIS U1 deletes file3");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)file3).delete().assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="File handling - perform actions: copy, move, add/update content, favorites, like and rate")
    public void fileHandlingCopyMoveAddUpdateContentFavoritesLikeAndRate() throws Exception {
        Step.STEP((String)"1. Using CMIS creates 2 users: U1 and U2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. Using CMIS U1 creates folder: folder1");
        FolderModel folder1 = FolderModel.getRandomFolderModel();
        this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(folder1).assertThat().existsInRepo();
        Step.STEP((String)"4. Using WebDAV U1 creates folder2 and folder3 inside folder1");
        FolderModel folder2 = FolderModel.getRandomFolderModel();
        FolderModel folder3 = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)folder1).createFolder(folder2).and()).assertThat().existsInWebdav().usingResource((ContentModel)folder1).createFolder(folder3).and()).assertThat().existsInWebdav();
        Step.STEP((String)"5. Using FTP U1 creates file1 inside folder1");
        FileModel file1 = FileModel.getRandomFileModel((FileType)FileType.MSWORD2007, (String)"tasTesting");
        this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)folder1).createFile(file1).assertThat().existsInRepo();
        Step.STEP((String)"6. Using CMIS U1 copies file1 to folder2");
        FileModel copiedFile = new FileModel(file1);
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)file1).copyTo((ContentModel)folder2);
        copiedFile.setCmisLocation(this.cmisAPI.getLastResource());
        this.cmisAPI.usingResource((ContentModel)folder2).assertThat().hasFiles(new FileModel[]{file1});
        Step.STEP((String)"7. Using WebDAV U1 update content of file1 from folder2");
        ((WebDavWrapper)this.webDavProtocol.usingResource((ContentModel)copiedFile).assertThat().existsInRepo()).update(this.newContent).assertThat().contentIs(this.newContent);
        Step.STEP((String)"8. Using FTP U1 tries to move file1 from folder2 to folder1");
        this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)copiedFile).moveTo((ContentModel)folder1).assertThat().existsInRepo();
        Assert.assertTrue((this.ftpProtocol.usingResource((ContentModel)folder1).getFiles().size() == 1 ? 1 : 0) != 0);
        Step.STEP((String)"9. Using WebDAV U1 updates content of file1 from folder1");
        this.webDavProtocol.usingResource((ContentModel)file1).update("content folder1").assertThat().contentIs("content folder1");
        Step.STEP((String)"10. Using RestAPI U1 adds file1 to favorites");
        file1.setNodeRef(((DataContent)((DataContent)((DataContent)this.dataContent.usingUser(this.testUser1).usingSite(this.testSitePublic)).usingResource((ContentModel)folder1)).usingResource((ContentModel)file1)).getNodeRef());
        this.restPersonFavoritesModel = this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().addFileToFavorites(file1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)file1.getNodeRefWithoutVersion());
        Step.STEP((String)"11. Using RestAPI U1 likes file1 and U2 user rates file1");
        this.returnedRatingModel = this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingResource((RepoTestModel)file1).likeDocument();
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
        this.returnedRatingModel = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingResource((RepoTestModel)file1).rateStarsToDocument(5);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
        Step.STEP((String)"12. Using CMIS U1 moves file1 from folder1 to folder3");
        ((CmisWrapper)this.cmisAPI.usingSite(this.testSitePublic).usingResource((ContentModel)file1).moveTo((ContentModel)folder3).and()).assertThat().existsInRepo();
        Step.STEP((String)"13. Using CMIS/RestAPI U1 checks that content, favorites and ratings are kept");
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
        this.restPersonFavoritesModel.assertThat().field("targetGuid").is((Object)file1.getNodeRefWithoutVersion());
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify document versioning after appending content using WebDAV.")
    public void checkDocumentVersionAfterAppendingContent() throws Exception {
        Step.STEP((String)"1. Using CMIS create one test user: U1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. Using CMIS U1 creates a new document in Share");
        FileModel cmisTestFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file 1 content");
        this.cmisAPI.authenticateUser(this.testUser1).usingShared().createFile(cmisTestFile).assertThat().existsInRepo();
        Step.STEP((String)"3. Using WebDAV U1 creates a new document in User Home");
        FileModel webDAVTestFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file 2 content");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingUserHome().createFile(webDAVTestFile).assertThat().existsInWebdav().and()).assertThat().existsInRepo();
        Step.STEP((String)"4. Using WebDAV U1 updates both documents");
        this.webDavProtocol.usingResource((ContentModel)cmisTestFile).update("cmis file content").usingResource((ContentModel)webDAVTestFile).update("WebDAV file content");
        Step.STEP((String)"5. Verify if only first document's version is increased using CMIS");
        this.cmisAPI.usingResource((ContentModel)cmisTestFile).assertThat().documentHasVersion(1.1).usingResource((ContentModel)webDAVTestFile).assertThat().documentHasVersion(1.0);
        Step.STEP((String)"6. Verify if content is updated using WebDav");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)cmisTestFile).assertThat().contentIs("cmis file content").usingResource((ContentModel)webDAVTestFile).assertThat().contentIs("WebDAV file content");
        Step.STEP((String)"7. Verify if the size of the document is increased");
        this.cmisAPI.usingResource((ContentModel)cmisTestFile).assertThat().contentLengthIs(17L).usingResource((ContentModel)webDAVTestFile).assertThat().contentLengthIs(19L);
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify increased version and new content of a file that was check out then check in.")
    public void verifyIncreasedVersionAndNewContentOfCheckInDocument() throws Exception {
        Step.STEP((String)"Step 1. Using CMIS create test user: U1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"Step 2. U1 creates a private test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPrivateRandomSite();
        Step.STEP((String)"Step 3. Using WebDAV U1 creates a folder");
        FolderModel folder = FolderModel.getRandomFolderModel();
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(folder);
        Step.STEP((String)"Step 4. Using WebDAV U1 creates a file inside the folder");
        FileModel file = FileModel.getRandomFileModel((FileType)FileType.XML, (String)"file content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)folder).createFile(file).assertThat().existsInWebdav().assertThat().existsInRepo();
        Step.STEP((String)"Step 5: Using CMIS, check out the document and verify document version");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)file).checkOut().assertThat().documentIsCheckedOut();
        Step.STEP((String)"Step 6: Using CMIS verify if PWC is created");
        FileModel filePWC = this.cmisAPI.usingResource((ContentModel)file).withCMISUtil().getPWCFileModel();
        this.cmisAPI.usingResource((ContentModel)filePWC).assertThat().existsInRepo();
        Step.STEP((String)"Step 7: Using CMIS check in document with content");
        String newContent = "new major content";
        this.cmisAPI.usingResource((ContentModel)folder).assertThat().folderHasCheckedOutDocument(new ContentModel[]{file});
        ((CmisWrapper)this.cmisAPI.usingResource((ContentModel)file).prepareDocumentForCheckIn().withMajorVersion().withContent(newContent).checkIn().refreshResource().and()).assertThat().documentIsNotCheckedOut();
        Step.STEP((String)"Step 8: Using CMIS verify that version does not increase");
        this.cmisAPI.usingResource((ContentModel)file).assertThat().documentHasVersion(1.0);
        Step.STEP((String)"Step 9: Using CMIS verify new content is added to document");
        this.cmisAPI.usingResource((ContentModel)file).assertThat().contentIs(newContent);
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify that version and the content of a file are not changed if the checkout is canceled.")
    public void verifyVersionAndContentOfACanceledCheckoutDocument() throws Exception {
        Step.STEP((String)"Step 1. Using CMIS create test user: U1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"Step 2. U1 creates a private test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPrivateRandomSite();
        Step.STEP((String)"Step 3. Using WebDAV U1 creates a folder");
        FolderModel folder = FolderModel.getRandomFolderModel();
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(folder);
        Step.STEP((String)"Step 4. Using WebDAV U1 creates a file inside the folder");
        FileModel file = FileModel.getRandomFileModel((FileType)FileType.XML, (String)"file content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)folder).createFile(file).assertThat().existsInWebdav().assertThat().existsInRepo();
        Step.STEP((String)"Step 5: Using CMIS, check out the document");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)file).checkOut();
        Step.STEP((String)"Step 6: Using CMIS verify if PWC is created");
        FileModel filePWC = this.cmisAPI.usingResource((ContentModel)file).withCMISUtil().getPWCFileModel();
        this.cmisAPI.usingResource((ContentModel)filePWC).assertThat().existsInRepo();
        Step.STEP((String)"Step 7: Using CMIS, cancel check out");
        ((CmisWrapper)this.cmisAPI.usingResource((ContentModel)file).cancelCheckOut().then()).assertThat().documentIsNotCheckedOut();
        Step.STEP((String)"Step 8: Using CMIS, verify original document has version 1.0");
        ((CmisWrapper)this.cmisAPI.usingResource((ContentModel)file).assertThat().isNotPrivateWorkingCopy().then()).assertThat().documentHasVersion(1.0);
        Step.STEP((String)"Step 9: Using CMIS, verify original document has same content");
        this.cmisAPI.usingResource((ContentModel)file).assertThat().contentIs("file content");
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Edit document name and verify document with new name")
    public void renameDocument() throws Exception {
        Step.STEP((String)"1. Using CMIS create test user: U1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. Using CMIS U1 creates file");
        FileModel file = FileModel.getRandomFileModel((FileType)FileType.PDF, (String)"file content");
        this.cmisAPI.authenticateUser(this.testUser1).usingUserHome().createFile(file).assertThat().existsInRepo();
        Step.STEP((String)"3. Using WebDAV U1 renames file and verify if the new document exists");
        FileModel oldFile = new FileModel(file);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)file).rename(this.renamePrefix + file.getName()).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav();
        Step.STEP((String)"4. Using FTP verify old document does not exists");
        ((FTPWrapper)((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)oldFile).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInFtp();
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Delete document after append content and verify document version.")
    public void deleteDocumentAfterAppendContent() throws Exception {
        Step.STEP((String)"Step 1. Using CMIS create test user: U1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"Step 2. Using WebDAV U1 creates a file using shared");
        FileModel file = FileModel.getRandomFileModel((FileType)FileType.XML, (String)"file content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingUserHome().createFile(file).assertThat().existsInRepo();
        Step.STEP((String)"Step 3. Using webDAV append content to document");
        String newContentToAppend = " - append this text to the file";
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)file).assertThat().contentIs("file content").then()).update(file.getContent() + newContentToAppend).assertThat().contentIs(file.getContent() + newContentToAppend);
        Step.STEP((String)"Step 4: Using CMIS, verify original document has version 1.0");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)file).assertThat().isNotPrivateWorkingCopy().then()).assertThat().documentHasVersion(1.0);
        Step.STEP((String)"Step 4: Using CMIS, delete document");
        this.cmisAPI.usingResource((ContentModel)file).assertThat().existsInRepo().delete();
        Step.STEP((String)"Step 5: Using WebDAV, verify document is deleted");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)file).assertThat().doesNotExistInWebdav().and()).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify if relationship is created between 2 items using CMIS.")
    public void checkRelationshipBetween2Files() throws Exception {
        Step.STEP((String)"1. Using CMIS create one test user: U1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. Using CMIS U1 creates a public test site");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. Using WebDAV U1 creates a new file in User Home");
        FileModel sourceFile = FileModel.getRandomFileModel((FileType)FileType.PDF, (String)"file content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingUserHome().createFile(sourceFile).assertThat().existsInRepo();
        Step.STEP((String)"4. Using WebDAV U1 creates another file in public site document library.");
        FileModel targetFile = FileModel.getRandomFileModel((FileType)FileType.PDF, (String)"file content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(targetFile).assertThat().existsInRepo();
        Step.STEP((String)"5. Using CMIS U1 creates a relationship between documents. 6. Verify if relationship is created");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)sourceFile).createRelationshipWith((ContentModel)targetFile).assertThat().objectHasRelationshipWith((ContentModel)targetFile);
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify parents list for an object using CMIS.")
    public void addAndRemoveDocumentFromFolders() throws Exception {
        Step.STEP((String)"1. Using CMIS create one test user: U1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. Using CMIS U1 creates an imap test site");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createIMAPSite();
        Step.STEP((String)"3. Using CMIS U1 creates cmisFolder in Shared");
        FolderModel cmisFolder = FolderModel.getRandomFolderModel();
        this.cmisAPI.authenticateUser(this.testUser1).usingShared().createFolder(cmisFolder).assertThat().existsInRepo();
        Step.STEP((String)"4. Using IMAP U1 creates parentFolder in private site document library.");
        FolderModel parentFolder = FolderModel.getRandomFolderModel();
        this.imapProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(parentFolder).assertThat().existsInRepo();
        Step.STEP((String)"5. Using FTP U1 creates a subfolder in parentFolder");
        FolderModel subFolder = FolderModel.getRandomFolderModel();
        this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)parentFolder).createFolder(subFolder).assertThat().existsInRepo();
        Step.STEP((String)"6. Using WebDAV U1 creates a webdavFolder in User Home");
        FolderModel webdavFolder = FolderModel.getRandomFolderModel();
        this.webDavProtocol.authenticateUser(this.testUser1).usingUserHome().createFolder(webdavFolder).assertThat().existsInRepo();
        Step.STEP((String)"7. Using WebDAV U1 creates a document in parentFolder");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)parentFolder).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"8. Using CMIS U1 adds document to cmisFolder, subfolder, webdavFolder");
        this.cmisAPI.usingResource((ContentModel)this.testFile1).addDocumentToFolder(cmisFolder, true).assertThat().hasParents(new String[]{parentFolder.getName(), cmisFolder.getName()}).addDocumentToFolder(subFolder, true).assertThat().hasParents(new String[]{parentFolder.getName(), cmisFolder.getName(), subFolder.getName()}).addDocumentToFolder(webdavFolder, true).assertThat().hasParents(new String[]{parentFolder.getName(), cmisFolder.getName(), subFolder.getName(), webdavFolder.getName()});
        Step.STEP((String)"9. Using WebDAV verify document is present in all folders");
        FileModel fileAddedInCMISFolder = new FileModel(this.testFile1.getName(), this.testFile1.getTitle(), this.testFile1.getDescription(), this.testFile1.getFileType(), this.testFile1.getContent());
        fileAddedInCMISFolder.setCmisLocation(Utility.buildPath((String)cmisFolder.getCmisLocation(), (String[])new String[]{this.testFile1.getName()}));
        FileModel fileAddedInSubFolder = new FileModel(this.testFile1.getName(), this.testFile1.getTitle(), this.testFile1.getDescription(), this.testFile1.getFileType(), this.testFile1.getContent());
        fileAddedInSubFolder.setCmisLocation(Utility.buildPath((String)subFolder.getCmisLocation(), (String[])new String[]{this.testFile1.getName()}));
        FileModel fileAddedInWebDAVFolder = new FileModel(this.testFile1.getName(), this.testFile1.getTitle(), this.testFile1.getDescription(), this.testFile1.getFileType(), this.testFile1.getContent());
        fileAddedInWebDAVFolder.setCmisLocation(Utility.buildPath((String)webdavFolder.getCmisLocation(), (String[])new String[]{this.testFile1.getName()}));
        this.webDavProtocol.usingResource((ContentModel)fileAddedInCMISFolder).assertThat().existsInWebdav().usingResource((ContentModel)fileAddedInSubFolder).assertThat().existsInWebdav().usingResource((ContentModel)fileAddedInWebDAVFolder).assertThat().existsInWebdav();
        Step.STEP((String)"10. Using CMIS U1 removes document from subFolder");
        this.cmisAPI.usingResource((ContentModel)this.testFile1).removeDocumentFromFolder(subFolder).assertThat().hasParents(new String[]{parentFolder.getName(), cmisFolder.getName(), webdavFolder.getName()});
        Step.STEP((String)"11. Using WebDAV verify document is not present in subFolder");
        this.webDavProtocol.usingResource((ContentModel)this.testFile1).assertThat().existsInWebdav().usingResource((ContentModel)fileAddedInCMISFolder).assertThat().existsInWebdav().usingResource((ContentModel)fileAddedInSubFolder).assertThat().doesNotExistInWebdav().usingResource((ContentModel)fileAddedInWebDAVFolder).assertThat().existsInWebdav();
        Step.STEP((String)"12. Using FTP U1 deletes original document from parentFolder");
        this.ftpProtocol.usingResource((ContentModel)this.testFile1).delete().assertThat().doesNotExistInFtp();
        Step.STEP((String)"13. Using CMIS verify document does not exist");
        this.cmisAPI.usingResource((ContentModel)fileAddedInCMISFolder).assertThat().doesNotExistInRepo().usingResource((ContentModel)fileAddedInWebDAVFolder).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify users can delete many documents in a public site using different protocols.")
    public void usersCanDeleteManyDocuments() throws Exception {
        FolderModel parentFolder1 = FolderModel.getRandomFolderModel();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.testFile2 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel childDoc1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel childDoc2 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel childDoc3 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel childDoc4 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        FileModel childDoc5 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        Step.STEP((String)"1. Using CMIS create test user: U1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. Using CMIS U1 creates a public test site");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"3. Using CMIS and WebDAV U1 creates parentFolder1, doc1 and doc2 in document library");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(parentFolder1).and()).assertThat().existsInRepo();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(this.testFile1).and()).createFile(this.testFile2);
        Step.STEP((String)"4. Using WebDAV and FTP U1 creates inside parentFolder1: childDoc1 to childDoc5");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)parentFolder1).createFile(childDoc1).and()).createFile(childDoc2);
        ((FTPWrapper)((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)parentFolder1).createFile(childDoc3).and()).createFile(childDoc4).and()).createFile(childDoc5);
        Step.STEP((String)"5. Using IMAP bulk delete doc1 and doc2");
        this.imapProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).deleteMessage(new String[]{this.testFile1.getName(), this.testFile2.getName()}).assertThat().doesNotContainMessages(new FileModel[]{this.testFile1, this.testFile2});
        Step.STEP((String)"6. Using CMIS verify that doc1 and doc2 are deleted");
        Utility.sleep((int)500, (int)10000, () -> ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).assertThat().doesNotExistInRepo().and()).usingResource((ContentModel)this.testFile2).assertThat().doesNotExistInRepo());
        Step.STEP((String)"7. Using IMAP delete childDoc1 to childDoc4");
        this.imapProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)parentFolder1).deleteMessage(new String[]{childDoc1.getName(), childDoc2.getName(), childDoc3.getName(), childDoc4.getName()}).assertThat().doesNotContainMessages(new FileModel[]{childDoc1, childDoc2, childDoc3, childDoc4});
        Step.STEP((String)"8. Using WebDAV and FTP verify if docs are deleted from their folders");
        Utility.sleep((int)500, (int)10000, () -> ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)parentFolder1).assertThat().hasFiles(new FileModel[]{childDoc5}).and()).usingResource((ContentModel)childDoc1).assertThat().doesNotExistInRepo()).and()).usingResource((ContentModel)childDoc2).assertThat().doesNotExistInRepo());
        ((FTPWrapper)((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)childDoc3).assertThat().doesNotExistInRepo()).and()).usingResource((ContentModel)childDoc4).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able to move a non empty folder to another folder from the same site.")
    public void moveFolderInAnotherFolder() throws Exception {
        this.testFolder1 = FolderModel.getRandomFolderModel();
        this.testFolder2 = FolderModel.getRandomFolderModel();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        Step.STEP((String)"1. Using CMIS create user u1 and public site");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"2. Using WebDAV U1 creates folder1 and folder2");
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().then()).createFolder(this.testFolder2).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav();
        Step.STEP((String)"3. Using WebDAV U1 creates doc1 in folder1");
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFile(this.testFile1).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).usingResource((ContentModel)this.testFolder1).assertThat().hasFiles(new FileModel[]{this.testFile1});
        Step.STEP((String)"4. Using FTP U1 moves folder1 in folder2");
        ((FTPWrapper)((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).moveTo((ContentModel)this.testFolder2).assertThat().existsInRepo()).then()).usingResource((ContentModel)this.testFolder1).assertThat().doesNotExistInRepo();
        Step.STEP((String)"5. Using WebDAV verify that folder1 is not in the original location and is present in folder2");
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).assertThat().doesNotExistInRepo()).and()).usingResource((ContentModel)this.testFolder2).assertThat().hasFolders(new FolderModel[]{this.testFolder1});
        Step.STEP((String)"6. Using CMIS verify if doc1 is still present in folder1");
        FolderModel newTestFolder1 = new FolderModel(this.testFolder1.getName(), this.testFolder1.getTitle(), this.testFolder1.getDescription());
        newTestFolder1.setCmisLocation(Utility.buildPath((String)this.testFolder2.getCmisLocation(), (String[])new String[]{this.testFolder1.getName()}));
        FileModel newTestFile1 = new FileModel(this.testFile1.getName(), this.testFile1.getTitle(), this.testFile1.getDescription(), this.testFile1.getFileType(), this.testFile1.getContent());
        newTestFile1.setCmisLocation(Utility.buildPath((String)newTestFolder1.getCmisLocation(), (String[])new String[]{this.testFile1.getName()}));
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)newTestFolder1).assertThat().existsInRepo().assertThat().hasFiles(new FileModel[]{newTestFile1});
    }

    @Test(groups={"integration", "core"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able to copy non empty folder to another folder in the same site.")
    public void copyFolderInAnotherFolder() throws Exception {
        this.testFolder1 = FolderModel.getRandomFolderModel();
        this.testFolder2 = FolderModel.getRandomFolderModel();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        Step.STEP((String)"1. Using CMIS create user u1 and public site");
        this.testUser1 = this.dataUser.createUser(RandomStringUtils.randomAlphanumeric((int)20));
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"2. Using CMIS U1 creates folder1 and folder2");
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).and()).assertThat().existsInRepo().and()).createFolder(this.testFolder2).and()).assertThat().existsInRepo();
        Step.STEP((String)"3. Using WebDAV U1 creates doc1 in folder1");
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFile(this.testFile1).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav();
        Step.STEP((String)"4. Using WebDAV U1 copies folder1 in folder2");
        this.testFolder2.setProtocolLocation(this.webDavProtocol.getPrefixSpace() + this.testFolder2.getCmisLocation());
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).copyTo((ContentModel)this.testFolder2).assertThat().existsInRepo()).then()).usingResource((ContentModel)this.testFolder1).assertThat().existsInRepo();
        Step.STEP((String)"5. Using FTP verify that folder1 is in the original location and contains doc1");
        ((FTPWrapper)((FTPWrapper)((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).assertThat().existsInRepo()).and()).assertThat().existsInFtp().and()).assertThat().hasFiles(new FileModel[]{this.testFile1});
        Step.STEP((String)"6. Using WebDAV verify that folder1 is in folder2 and contains doc1");
        FolderModel newTestFolder1 = new FolderModel(this.testFolder1.getName(), this.testFolder1.getTitle(), this.testFolder1.getDescription());
        newTestFolder1.setCmisLocation(Utility.buildPath((String)this.testFolder2.getCmisLocation(), (String[])new String[]{this.testFolder1.getName()}));
        FileModel newTestFile1 = new FileModel(this.testFile1.getName(), this.testFile1.getTitle(), this.testFile1.getDescription(), this.testFile1.getFileType(), this.testFile1.getContent());
        newTestFile1.setCmisLocation(Utility.buildPath((String)newTestFolder1.getCmisLocation(), (String[])new String[]{this.testFile1.getName()}));
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder2).assertThat().hasFolders(new FolderModel[]{newTestFolder1}).and()).usingResource((ContentModel)newTestFolder1).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).assertThat().hasFiles(new FileModel[]{newTestFile1});
    }

    @Test(groups={"integration", "core"}, expectedExceptions={CmisRuntimeException.class}, expectedExceptionsMessageRegExp="^.*Sites can not be renamed.$")
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify sites cannot be renamed using CMIS.")
    public void renameSite() throws Exception {
        Step.STEP((String)"1. Using CMIS create one test user: U1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2.  Using CMIS U1 creates a moderated site");
        this.testSiteModerated = ((DataSite)this.dataSite.usingUser(this.testUser1)).createModeratedRandomSite();
        Step.STEP((String)"3. Using WebDAV U1 creates a folder in the moderated site document library");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSiteModerated).createFolder(this.testFolder1).assertThat().existsInWebdav().assertThat().existsInRepo();
        Step.STEP((String)"4. Using CMIS U1 tries to rename site 5. Verify that a site cannot be renamed");
        FolderModel siteFolder = new FolderModel(String.format("/Sites/%s", this.testSiteModerated.getId()));
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)siteFolder).rename("renamedSite");
    }
}

