/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tas.integration;

import org.alfresco.cmis.CmisWrapper;
import org.alfresco.ftp.FTPWrapper;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestCommentModelsCollection;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.tas.integration.IntegrationTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavWrapper;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class IntegrationFullTestsBulk3
extends IntegrationTest {
    private UserModel testUser1;
    private UserModel testUser2;
    private SiteModel publicSite;
    private SiteModel moderatedSite;
    private SiteModel privateSite;
    private RestCommentModelsCollection comments;
    private FileModel testFile1;
    private FileModel testFile2;
    private FileModel wordFile;
    private DataUser.ListUserWithRoles usersWithRoles;
    private FolderModel testFolder1;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testFolder1 = FolderModel.getRandomFolderModel();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="File handling using several protocols")
    public void fileHandlingWithCollaboratorRole() throws Exception {
        String contentCollaborator = "content added by Collaborator";
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteCollaborator});
        this.wordFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD2007, (String)"tasTesting");
        Step.STEP((String)"1. Create folder1 with webdav");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFolder(this.testFolder1).and()).assertThat().existsInRepo();
        Step.STEP((String)"2. Create testFile1 inside folder1 using CMIS");
        this.cmisAPI.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.publicSite).usingResource((ContentModel)this.testFolder1).createFile(this.wordFile).assertThat().existsInRepo();
        Step.STEP((String)"3. Delete wordFile content with WebDAV");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.wordFile).deleteContent();
        Step.STEP((String)"4. Update content using Collaborator role with CMIS");
        this.cmisAPI.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.wordFile).update(contentCollaborator).assertThat().contentIs(contentCollaborator);
        Step.STEP((String)"5. Append content using Manager role with WebDAV");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.wordFile).update("content added by Manager").assertThat().contentIs("content added by Manager");
        Step.STEP((String)"6. Delete content that Manager added using Collaborator role with CMIS");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.wordFile).deleteAllVersions(false).and()).assertThat().documentHasVersion(1.2);
        Step.STEP((String)"7. Rename wordFile with FTP");
        this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.wordFile).rename("renamedFile.docx");
        Step.STEP((String)"8. Delete file with WEBDAV");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.wordFile).delete().assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="File handling using several protocols")
    public void fileHandlingWithContributorRole() throws Exception {
        String contentContributor = "content added by Contributor";
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteContributor});
        this.wordFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD2007, (String)"tasTesting");
        Step.STEP((String)"1. Create folder1 with webdav");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFolder(this.testFolder1).and()).assertThat().existsInRepo();
        Step.STEP((String)"2. Create testFile1 inside folder1 using CMIS");
        this.cmisAPI.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.testFolder1).createFile(this.wordFile).assertThat().existsInRepo();
        Step.STEP((String)"3. Delete wordFile content with CMIS");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.wordFile).deleteContent();
        Step.STEP((String)"4. Update content using Contributor role with CMIS");
        this.cmisAPI.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.wordFile).update(contentContributor).assertThat().contentIs(contentContributor);
        Step.STEP((String)"5. Append content using Manager role with WebDAV");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.wordFile).update("content added by Manager").assertThat().contentIs("content added by Manager");
        Step.STEP((String)"6. Delete content that Manager added using Contributor role with CMIS");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.wordFile).deleteAllVersions(false).and()).assertThat().documentHasVersion(1.2);
        Step.STEP((String)"7. Rename wordFile with WebDAV");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.wordFile).rename("renamedFile.docx");
        Step.STEP((String)"8. Delete file with FTP");
        this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.wordFile).delete().assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify comment is deleted .")
    public void negativeScenarioWithComments() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create two users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a public site using CMIS");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"* 3. U1 creates a file in public site's document library using FTP");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 4. U1 adds comment1 for testFile1 using REST API");
        String newComment = "This is a new comment added by " + this.testUser1.getUsername();
        ((RestCommentModel)this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingResource((RepoTestModel)this.testFile1).addComment(newComment).assertThat().field("content").isNotEmpty()).and().field("content").is((Object)newComment);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"* 5. U2 gets comment1 using REST API");
        this.comments = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingResource((RepoTestModel)this.testFile1).getNodeComments();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListContains("content", newComment);
        Step.STEP((String)"* 6. U1 updates testFile1 using WEBDAV");
        String newContent = "This is new content added by " + this.testUser1.getUsername();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).update(newContent).and()).assertThat().contentIs(newContent);
        Step.STEP((String)"* 7. U2 gets comment1 using REST API");
        this.comments = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingResource((RepoTestModel)this.testFile1).getNodeComments();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListContains("content", newComment);
        Step.STEP((String)"* 8. U1 deletes testFile1 using WebDAV");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).delete().and()).assertThat().doesNotExistInRepo();
        Step.STEP((String)"* 9. U2 can not get comment1 using REST API");
        this.comments = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingResource((RepoTestModel)this.testFile1).getNodeComments();
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.testFile1.getNodeRef()));
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify manager permission to a document in a public site - is able to edit document.")
    public void addManagerPermissionToADocumentFromPublicSite() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create two users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a public site using CMIS");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"* 3. U1 creates a file in public site's document library using FTP");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 4. U1 applyAcl(permission) for U2 with role Site Manager to the document using CMIS");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).addAcl(this.testUser2, UserRole.SiteManager).then()).assertThat().permissionIsSetForUser(this.testUser2, UserRole.SiteManager);
        Step.STEP((String)"* 5. U2 edits the document using FTP");
        this.ftpProtocol.authenticateUser(this.testUser2).usingSite(this.publicSite).usingResource((ContentModel)this.testFile1).update("new Content").assertThat().contentIs("new Content");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator permission to a document in a public site - is able to edit document.")
    public void addCollaboratorPermissionToADocumentFromPublicSite() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create two users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a public site using CMIS");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"* 3. U1 creates a file in public site's document library using FTP");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 4. U1 applyAcl(permission) for U2 with role Site Manager to the document using CMIS");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).addAcl(this.testUser2, UserRole.SiteCollaborator).then()).assertThat().permissionIsSetForUser(this.testUser2, UserRole.SiteCollaborator);
        Step.STEP((String)"* 5. U2 edits the document using FTP");
        this.ftpProtocol.authenticateUser(this.testUser2).usingSite(this.publicSite).usingResource((ContentModel)this.testFile1).update("new Content").assertThat().contentIs("new Content");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor permission to a document in a public site - is not able to edit document.")
    public void addContributorPermissionToADocumentFromPublicSite() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create two users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a public site using CMIS");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"* 3. U1 creates a file in public site's document library using FTP");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 4. U1 applyAcl(permission) for U2 with role Site Manager to the document using CMIS");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).addAcl(this.testUser2, UserRole.SiteContributor).then()).assertThat().permissionIsSetForUser(this.testUser2, UserRole.SiteContributor);
        Step.STEP((String)"* 5. U2 edits the document using FTP");
        this.ftpProtocol.authenticateUser(this.testUser2).usingSite(this.publicSite).usingResource((ContentModel)this.testFile1).update("new Content");
        this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).usingResource((ContentModel)this.testFile1).assertThat().contentIs("file1 content");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer permission to a document in a public site - is not able to edit document.")
    public void addConsumerPermissionToADocumentFromPublicSite() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create two users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a public site using CMIS");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"* 3. U1 creates a file in public site's document library using FTP");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 4. U1 applyAcl(permission) for U2 with role Site Manager to the document using CMIS");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).addAcl(this.testUser2, UserRole.SiteConsumer).then()).assertThat().permissionIsSetForUser(this.testUser2, UserRole.SiteConsumer);
        Step.STEP((String)"* 5. U2 edits the document using FTP");
        this.ftpProtocol.authenticateUser(this.testUser2).usingSite(this.publicSite).usingResource((ContentModel)this.testFile1).update("new Content");
        this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).usingResource((ContentModel)this.testFile1).assertThat().contentIs("file1 content");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify manager permission to a document in a moderated site - is not able to edit document.")
    public void addManagerPermissionToADocumentFromModeratedSite() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create two users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a moderated site using CMIS");
        this.moderatedSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createModeratedRandomSite();
        Step.STEP((String)"* 3. U1 creates a file in moderated site's document library using FTP");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.moderatedSite).createFile(this.testFile1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 4. U1 applyAcl(permission) for U2 with role Site Manager to the document using CMIS");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).addAcl(this.testUser2, UserRole.SiteManager).then()).assertThat().permissionIsSetForUser(this.testUser2, UserRole.SiteManager);
        Step.STEP((String)"* 5. U2 edits the document using FTP");
        this.ftpProtocol.authenticateUser(this.testUser2).usingSite(this.moderatedSite).usingResource((ContentModel)this.testFile1).update("new Content");
        this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.moderatedSite).usingResource((ContentModel)this.testFile1).assertThat().contentIs("file1 content");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify manager permission to a document in a private site - is not able to edit document.")
    public void addManagerPermissionToADocumentFromPrivateSite() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create two users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a private site using CMIS");
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPrivateRandomSite();
        Step.STEP((String)"* 3. U1 creates a file in private site's document library using FTP");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.privateSite).createFile(this.testFile1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 4. U1 applyAcl(permission) for U2 with role Site Manager to the document using CMIS");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).addAcl(this.testUser2, UserRole.SiteManager).then()).assertThat().permissionIsSetForUser(this.testUser2, UserRole.SiteManager);
        Step.STEP((String)"* 5. U2 edits the document using FTP");
        this.ftpProtocol.authenticateUser(this.testUser2).usingSite(this.privateSite).usingResource((ContentModel)this.testFile1).update("new Content");
        this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.privateSite).usingResource((ContentModel)this.testFile1).assertThat().contentIs("file1 content");
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Compare Modified Date")
    public void manageModificationTimeOfFile() throws Exception {
        Step.STEP((String)"1. Using CMIS creates one test user: u1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates testFile1 in a public site using FTP");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testFile1 = new FileModel("testFile1", FileType.TEXT_PLAIN);
        this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.publicSite).createFile(this.testFile1).assertThat().existsInRepo();
        String modifiedDate1 = this.ftpProtocol.getModificationTime();
        Step.STEP((String)"3. U1 creates testFile2 in a public site using FTP");
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testFile2 = new FileModel("testFile1", FileType.TEXT_PLAIN);
        Utility.waitToLoopTime((int)2, (String[])new String[0]);
        this.ftpProtocol.usingSite(this.publicSite).createFile(this.testFile2).assertThat().existsInRepo();
        String modifiedDate2 = this.ftpProtocol.getModificationTime();
        Utility.waitToLoopTime((int)2, (String[])new String[]{"Waiting for update"});
        Step.STEP((String)"4. U1 updates testFile2 in a public site using FTP");
        this.ftpProtocol.update("test update").assertThat().contentIs("test update");
        String updatedDate2 = this.ftpProtocol.getModificationTime();
        Step.STEP((String)"5. Compare created date with modified date");
        Assert.assertNotEquals((Object)modifiedDate1, (Object)modifiedDate2, (String)"Updated and modified dates are equal");
        Assert.assertNotEquals((Object)modifiedDate2, (Object)updatedDate2, (String)"Modified and updated dates are equal");
    }
}

