/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tas.integration;

import org.alfresco.dataprep.SiteService;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestSiteEntry;
import org.alfresco.rest.model.RestSiteMemberModelsCollection;
import org.alfresco.rest.model.RestSiteMembershipRequestModel;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.tas.integration.IntegrationTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataGroup;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class IntegrationFullTests1
extends IntegrationTest {
    UserModel testUser1;
    UserModel testUser2;
    UserModel testUser3;
    SiteModel testSitePublic;
    SiteModel testSiteModerated;

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify document permissions are added for a group of users")
    public void addDocumentPermissionsForGroupOfUsers() throws Exception {
        Step.STEP((String)"1. Using RestApi Admin user creates a new group1");
        GroupModel group1 = this.dataGroup.createRandomGroup();
        Step.STEP((String)"2. Using CMIS create test users: U1, U2 and U3");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        this.testUser3 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"3. Using RestApi add users U2 and U3 to group1");
        ((DataGroup)this.dataGroup.usingUser(this.testUser2)).addUserToGroup(group1);
        ((DataGroup)this.dataGroup.usingUser(this.testUser3)).addUserToGroup(group1);
        Step.STEP((String)"4. U1 creates public test site1 using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"5. U1 creates file1 using CMIS, WebDav, FTP");
        FileModel cmisFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(cmisFile);
        FileModel webDavFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(webDavFile);
        FileModel ftpFile = FileModel.getRandomFileModel((FileType)FileType.XML);
        this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(ftpFile);
        Step.STEP((String)"6. U1 apply Acl permission in the new documents for testGroup with role Site Consumer using CMIS");
        this.cmisAPI.usingResource((ContentModel)cmisFile).addAcl(group1, UserRole.SiteConsumer);
        this.cmisAPI.usingResource((ContentModel)webDavFile).addAcl(group1, UserRole.SiteConsumer);
        this.cmisAPI.usingResource((ContentModel)ftpFile).addAcl(group1, UserRole.SiteConsumer);
        Step.STEP((String)"7. Get permissions for U2 using CMIS");
        this.cmisAPI.usingResource((ContentModel)cmisFile).assertThat().permissionIsSetForGrup(group1, UserRole.SiteConsumer);
        this.cmisAPI.usingResource((ContentModel)webDavFile).assertThat().permissionIsSetForGrup(group1, UserRole.SiteConsumer);
        this.cmisAPI.usingResource((ContentModel)ftpFile).assertThat().permissionIsSetForGrup(group1, UserRole.SiteConsumer);
        Step.STEP((String)"8. U2 edits files created with CMIS, WebDav, FTP using WebDav");
        String newContent = "new content";
        this.webDavProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)cmisFile).update(newContent).assertThat().hasStatus(403).usingResource((ContentModel)webDavFile).update(newContent).assertThat().hasStatus(403).usingResource((ContentModel)ftpFile).update(newContent).assertThat().hasStatus(403);
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify folder permissions are added for a group of users")
    public void addFolderPermissionsForGroupOfUsers() throws Exception {
        Step.STEP((String)"1. Using RestApi Admin user creates a new group1");
        GroupModel group1 = this.dataGroup.createRandomGroup();
        Step.STEP((String)"2. Using CMIS create test users: U1, U2 and U3");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        this.testUser3 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"3. Using RestApi add users U2 and U3 to group1");
        ((DataGroup)this.dataGroup.usingUser(this.testUser2)).addUserToGroup(group1);
        ((DataGroup)this.dataGroup.usingUser(this.testUser3)).addUserToGroup(group1);
        Step.STEP((String)"4. U1 creates public test site1 using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"5. U1 creates folders using CMIS, WebDav, FTP");
        FolderModel cmisFolder = FolderModel.getRandomFolderModel();
        this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(cmisFolder);
        FolderModel webDavFolder = FolderModel.getRandomFolderModel();
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(webDavFolder);
        FolderModel ftpFolder = FolderModel.getRandomFolderModel();
        this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(ftpFolder);
        Step.STEP((String)"6. U1 apply Acl permission in the new folders for testGroup with role Site Consumer using CMIS");
        this.cmisAPI.usingResource((ContentModel)cmisFolder).addAcl(group1, UserRole.SiteConsumer);
        this.cmisAPI.usingResource((ContentModel)webDavFolder).addAcl(group1, UserRole.SiteConsumer);
        this.cmisAPI.usingResource((ContentModel)ftpFolder).addAcl(group1, UserRole.SiteConsumer);
        Step.STEP((String)"7. Get permissions for U2 using CMIS");
        this.cmisAPI.usingResource((ContentModel)cmisFolder).assertThat().permissionIsSetForGrup(group1, UserRole.SiteConsumer);
        this.cmisAPI.usingResource((ContentModel)webDavFolder).assertThat().permissionIsSetForGrup(group1, UserRole.SiteConsumer);
        this.cmisAPI.usingResource((ContentModel)ftpFolder).assertThat().permissionIsSetForGrup(group1, UserRole.SiteConsumer);
        Step.STEP((String)"8. U2 edits folders created with CMIS, WebDav, FTP using WebDav");
        String newName = "newName";
        this.webDavProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)cmisFolder).rename(newName).assertThat().hasStatus(403).usingResource((ContentModel)webDavFolder).rename(newName).assertThat().hasStatus(403).usingResource((ContentModel)ftpFolder).rename(newName).assertThat().hasStatus(403);
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user can update or not site membership request when site visibility is updated")
    public void updateSiteMembershipRequestWhenSiteVisibilityIsUpdated() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: U1 and U2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates moderated test site1 using CMIS");
        this.testSiteModerated = ((DataSite)this.dataSite.usingUser(this.testUser1)).createModeratedRandomSite();
        Step.STEP((String)"3. U2 creates site membership request to site1 with RestAPI");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingMe().addSiteMembershipRequest("Please add me 1", this.testSiteModerated, "Request1");
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"4. U2 gets site membership request, check new message using RestAPI");
        RestSiteMembershipRequestModel request = this.restAPI.withCoreAPI().usingMe().getSiteMembershipRequest(this.testSiteModerated);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        request.assertThat().field("message").is((Object)"Please add me 1");
        Step.STEP((String)"5. U2 updates site membership request with a new message using RestAPI");
        request = this.restAPI.withCoreAPI().usingMe().updateSiteMembershipRequest(this.testSiteModerated, "Please add me 2");
        request.assertThat().field("message").is((Object)"Please add me 2");
        Step.STEP((String)"6. U2 gets site membership request, check new message using RestAPI");
        request = this.restAPI.withCoreAPI().usingMe().getSiteMembershipRequest(this.testSiteModerated);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        request.assertThat().field("message").is((Object)"Please add me 2");
        Step.STEP((String)"7. U1 changes site visibility to private site using RestAPI");
        ((DataSite)this.dataSite.usingUser(this.testUser1)).updateSiteVisibility(this.testSiteModerated, SiteService.Visibility.PRIVATE);
        Step.STEP((String)"8. U2 updates site membership request with a new message using RestAPI");
        this.restAPI.withCoreAPI().usingMe().updateSiteMembershipRequest(this.testSiteModerated, "Please add me 2");
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        Step.STEP((String)"9. U2 gets site membership request, check new message using RestAPI");
        this.restAPI.withCoreAPI().usingMe().getSiteMembershipRequest(this.testSiteModerated);
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        Step.STEP((String)"10. U1 change site visibility to moderated site RestAPI");
        ((DataSite)this.dataSite.usingUser(this.testUser1)).updateSiteVisibility(this.testSiteModerated, SiteService.Visibility.MODERATED);
        Step.STEP((String)"11. U2 gets site membership request, check new message using RestAPI");
        request = this.restAPI.withCoreAPI().usingMe().getSiteMembershipRequest(this.testSiteModerated);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        request.assertThat().field("message").is((Object)"Please add me 2");
        Step.STEP((String)"12. U2 updates site membership request with a new message using RestAPI");
        request = this.restAPI.withCoreAPI().usingMe().updateSiteMembershipRequest(this.testSiteModerated, "Please add me 3");
        request.assertThat().field("message").is((Object)"Please add me 3");
        Step.STEP((String)"13. U2 get site membership request, check new message using RestAPI");
        request = this.restAPI.withCoreAPI().usingMe().getSiteMembershipRequest(this.testSiteModerated);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        request.assertThat().field("message").is((Object)"Please add me 3");
        Step.STEP((String)"14. U1 user1 changes site visibility to public using RestAPI");
        ((DataSite)this.dataSite.usingUser(this.testUser1)).updateSiteVisibility(this.testSiteModerated, SiteService.Visibility.PUBLIC);
        Step.STEP((String)"15. U2 updates site membership request with a new message with RestAPI");
        this.restAPI.withCoreAPI().usingMe().updateSiteMembershipRequest(this.testSiteModerated, "Please add me 4");
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        Step.STEP((String)"16. U2 gets site membership request, check new message using RestAPI");
        this.restAPI.withCoreAPI().usingMe().getSiteMembershipRequest(this.testSiteModerated);
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        Step.STEP((String)"17. U1 changes site visibility to moderated site RestAPI");
        ((DataSite)this.dataSite.usingUser(this.testUser1)).updateSiteVisibility(this.testSiteModerated, SiteService.Visibility.MODERATED);
        Step.STEP((String)"18. U2 gets site membership request, check new message using RestAPI");
        request = this.restAPI.withCoreAPI().usingMe().getSiteMembershipRequest(this.testSiteModerated);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        request.assertThat().field("message").is((Object)"Please add me 3");
        Step.STEP((String)"19. U2 updates new site membership request using RestAPI");
        request = this.restAPI.withCoreAPI().usingMe().updateSiteMembershipRequest(this.testSiteModerated, "Please add me 5");
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        request.assertThat().field("message").is((Object)"Please add me 5");
        Step.STEP((String)"20. U1 approves site membership using RestAPI");
        RestTaskModel taskModel = this.restAPI.withWorkflowAPI().getTasks().getTaskModelByDescription(this.testSiteModerated);
        this.workflow.approveSiteMembershipRequest(this.testUser1.getUsername(), this.testUser1.getPassword(), taskModel.getId(), true, "Approve");
        Step.STEP((String)"21. U2 gets site membership request - no request using RestAPI");
        this.restAPI.withCoreAPI().usingMe().getSiteMembershipRequest(this.testSiteModerated);
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        RestSiteEntry site = this.restAPI.withCoreAPI().usingMe().getSiteMembership(this.testSiteModerated);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteEntry)site.assertThat().field("id").is((Object)this.testSiteModerated.getId())).and().field("role").isNotEmpty();
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify get site members when users are added to site or deleted")
    public void getSiteMembersWhenUsersAreAddedOrDeleted() throws Exception {
        Step.STEP((String)"1. Using CMIS create test user A1");
        UserModel testUser = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. A1 creates public test site1 using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(testUser)).createPublicRandomSite();
        Step.STEP((String)"3. Using CMIS create test user U1");
        UserModel user1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"4. A1 adds U1 to site1 as site manager using RestAPI");
        user1.setUserRole(UserRole.SiteManager);
        this.restAPI.authenticateUser(testUser).withCoreAPI().usingSite(this.testSitePublic).addPerson(user1);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"5. A1 get site members using RestAPI");
        RestSiteMemberModelsCollection members = this.restAPI.authenticateUser(testUser).withCoreAPI().usingSite(this.testSitePublic).getSiteMembers();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        members.assertThat().paginationField("count").is("2");
        ((RestModels)members.assertThat().entriesListContains("id", user1.getUsername())).and().entriesListContains("role", UserRole.SiteManager.toString());
        Step.STEP((String)"6. Using CMIS create test user U2");
        UserModel user2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"7. A1 adds U2 to site1 as site collaborator using RestAPI");
        user2.setUserRole(UserRole.SiteCollaborator);
        this.restAPI.authenticateUser(testUser).withCoreAPI().usingSite(this.testSitePublic).addPerson(user2);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"8. A1 get site members using RestAPI");
        members = this.restAPI.authenticateUser(testUser).withCoreAPI().usingSite(this.testSitePublic).getSiteMembers();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        members.assertThat().paginationField("count").is("3");
        ((RestModels)members.assertThat().entriesListContains("id", user2.getUsername())).and().entriesListContains("role", UserRole.SiteCollaborator.toString());
        Step.STEP((String)"9. Using CMIS create test user U3");
        UserModel user3 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"10. A1 add U3 to site1 as site contributor using RestAPI");
        user3.setUserRole(UserRole.SiteContributor);
        this.restAPI.authenticateUser(testUser).withCoreAPI().usingSite(this.testSitePublic).addPerson(user3);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"11. A1 get site members using RestAPI");
        members = this.restAPI.authenticateUser(testUser).withCoreAPI().usingSite(this.testSitePublic).getSiteMembers();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        members.assertThat().paginationField("count").is("4");
        ((RestModels)members.assertThat().entriesListContains("id", user3.getUsername())).and().entriesListContains("role", UserRole.SiteContributor.toString());
        Step.STEP((String)"12. Using CMIS create test user U4");
        UserModel user4 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"13. A1 add U4 to site1 as site consumer using RestAPI");
        user4.setUserRole(UserRole.SiteConsumer);
        this.restAPI.authenticateUser(testUser).withCoreAPI().usingSite(this.testSitePublic).addPerson(user4);
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"14. A1 get site members using RestAPI");
        members = this.restAPI.authenticateUser(testUser).withCoreAPI().usingSite(this.testSitePublic).getSiteMembers();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        members.assertThat().paginationField("count").is("5");
        ((RestModels)members.assertThat().entriesListContains("id", user4.getUsername())).and().entriesListContains("role", UserRole.SiteConsumer.toString());
        Step.STEP((String)"15. Using CMIS delete test user U1");
        this.dataUser.deleteUser(user1);
        Step.STEP((String)"16. A1 get site members using RestAPI");
        members = this.restAPI.authenticateUser(testUser).withCoreAPI().usingSite(this.testSitePublic).getSiteMembers();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        members.assertThat().paginationField("count").is("4");
        members.assertThat().entriesListDoesNotContain("id", user1.getUsername());
        Step.STEP((String)"17. Using CMIS delete test user U2");
        this.dataUser.deleteUser(user2);
        Step.STEP((String)"18. A1 get site members using RestAPI");
        members = this.restAPI.authenticateUser(testUser).withCoreAPI().usingSite(this.testSitePublic).getSiteMembers();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        members.assertThat().paginationField("count").is("3");
        members.assertThat().entriesListDoesNotContain("id", user2.getUsername());
        Step.STEP((String)"19. Using CMIS delete test user U3");
        this.dataUser.deleteUser(user3);
        Step.STEP((String)"20. A1 get site members using RestAPI");
        members = this.restAPI.authenticateUser(testUser).withCoreAPI().usingSite(this.testSitePublic).getSiteMembers();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        members.assertThat().paginationField("count").is("2");
        members.assertThat().entriesListDoesNotContain("id", user3.getUsername());
        Step.STEP((String)"21. Using CMIS delete test user U4");
        this.dataUser.deleteUser(user4);
        Step.STEP((String)"22. A1 get site members using RestAPI");
        members = this.restAPI.authenticateUser(testUser).withCoreAPI().usingSite(this.testSitePublic).getSiteMembers();
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        members.assertThat().paginationField("count").is("1");
        members.assertThat().entriesListDoesNotContain("id", user4.getUsername());
    }

    @Test(groups={"integration", "full"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.REGRESSION}, description="Verify file properties with file properties are updated")
    public void checkFilePropertiesWhenFileIsUpdated() throws Exception {
        Step.STEP((String)"1. Using CMIS create test user U1");
        UserModel testUser = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates public test site1 using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(testUser)).createPublicRandomSite();
        Step.STEP((String)"3. U1 creates file1 using Webdav");
        FileModel file1 = FileModel.getRandomFileModel((FileType)FileType.MSWORD2007);
        file1.setContent("content1");
        this.webDavProtocol.authenticateUser(testUser).usingSite(this.testSitePublic).createFile(file1);
        Step.STEP((String)"4. U1 updates file1 properties using CMIS");
        String newDescription = "New-" + file1.getDescription();
        String newTitle = "New title-" + file1.getTitle();
        this.cmisAPI.authenticateUser(testUser).usingSite(this.testSitePublic).usingResource((ContentModel)file1).updateProperty("cmis:description", (Object)newDescription).updateProperty("cm:title", (Object)newTitle);
        Step.STEP((String)"5. U1 gets file1 properties using CMIS");
        this.cmisAPI.authenticateUser(testUser).usingResource((ContentModel)file1).assertThat().contentPropertyHasValue("cmis:description", newDescription).assertThat().contentPropertyHasValue("cm:title", newTitle);
        Step.STEP((String)"6. U1 renames file1 using Webdav");
        String newName = "Edited-" + file1.getName();
        this.webDavProtocol.authenticateUser(testUser).usingSite(this.testSitePublic).usingResource((ContentModel)file1).rename(newName);
        Step.STEP((String)"7. U1 updates file1 content using FTP");
        String newContent = "New " + file1.getContent();
        this.ftpProtocol.authenticateUser(testUser).usingSite(this.testSitePublic).usingResource((ContentModel)file1).update(newContent).assertThat().contentIs(newContent);
    }
}

