/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.members;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteMemberModel;
import org.alfresco.rest.requests.Site;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSiteMemberTests
extends RestTest {
    private UserModel adminUser;
    private SiteModel publicSiteModel;
    private SiteModel moderatedSiteModel;
    private SiteModel privateSiteModel;
    private DataUser.ListUserWithRoles usersWithRoles;
    private UserModel manager;
    private UserModel consumer;
    private UserModel collaborator;
    private UserModel contributor;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUser = this.dataUser.getAdminUser();
        this.publicSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.moderatedSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createModeratedRandomSite();
        this.privateSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPrivateRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.consumer = this.dataUser.createRandomTestUser();
        this.manager = this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        this.collaborator = this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator);
        this.contributor = this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor);
        this.dataUser.addUserToSite(this.consumer, this.publicSiteModel, UserRole.SiteConsumer);
        this.dataUser.addUserToSite(this.consumer, this.moderatedSiteModel, UserRole.SiteConsumer);
        this.dataUser.addUserToSite(this.manager, this.moderatedSiteModel, UserRole.SiteManager);
        this.dataUser.addUserToSite(this.consumer, this.privateSiteModel, UserRole.SiteConsumer);
        this.dataUser.addUserToSite(this.manager, this.privateSiteModel, UserRole.SiteManager);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify user with Manager role gets site member and status code is OK (200)")
    public void getSiteMemberWithManagerRole() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(this.consumer).assertThat().field("id").is((Object)this.consumer.getUsername())).and().field("role").is((Object)this.consumer.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role gets site member and gets status code OK (200)")
    public void getSiteMemberWithCollaboratorRole() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(this.consumer).and().field("id").is((Object)this.consumer.getUsername())).and().field("role").is((Object)this.consumer.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role gets site member and gets status code OK (200)")
    public void getSiteMemberWithContributorRole() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(this.consumer).and().field("id").is((Object)this.consumer.getUsername())).and().field("role").is((Object)this.consumer.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role gets site member and gets status code OK (200)")
    public void getSiteMemberWithConsumerRole() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(this.consumer).and().field("id").is((Object)this.consumer.getUsername())).and().field("role").is((Object)this.consumer.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with admin user gets site member and gets status code OK (200)")
    public void getSiteMemberWithAdminUser() throws Exception {
        this.restClient.authenticateUser(this.adminUser);
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(this.consumer).and().field("id").is((Object)this.consumer.getUsername())).and().field("role").is((Object)this.consumer.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Failed authentication get site member call returns status code 401")
    public void unauthenticatedUserIsNotAuthorizedToRetrieveSiteMember() throws JsonToModelConversionException, Exception {
        UserModel inexistentUser = new UserModel("inexistent user", "inexistent password");
        this.restClient.authenticateUser(inexistentUser);
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(this.consumer);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Manager role doesn't get a site member of inexistent site and status code is Not Found (404)")
    public void getSiteMemberOfInexistentSite() throws Exception {
        SiteModel invalidSite = new SiteModel("invalidSite");
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(invalidSite).getSiteMember(this.consumer);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.consumer.getUsername(), invalidSite.getId()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Manager role doesn't get non site member of inexistent site and status code is Not Found (404)")
    public void getSiteMemberForNonSiteMember() throws Exception {
        UserModel nonMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(nonMember);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, nonMember.getUsername(), this.publicSiteModel.getId()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Manager role doesn't get not existing site member and status code is Not Found (404)")
    public void getSiteMemberForInexistentSiteMember() throws Exception {
        UserModel inexistentUser = new UserModel("inexistentUser", "password");
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(inexistentUser);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, inexistentUser.getUsername()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Manager role can get site member using \"-me-\" in place of personId")
    public void getSiteMemberUsingMeForPersonId() throws Exception {
        UserModel meUser = new UserModel("-me-", "password");
        this.restClient.authenticateUser(this.manager);
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(meUser).assertThat().field("id").is((Object)this.manager.getUsername())).and().field("role").is((Object)this.manager.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Manager role can get site member for empty siteId")
    public void getSiteMemberForEmptySiteId() throws Exception {
        SiteModel emptySite = new SiteModel("");
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(emptySite).getSiteMember(this.consumer);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.consumer.getUsername(), emptySite.getId()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Manager role gets site member with Manager role and status code is OK (200)")
    public void getSiteManagerMemberWithManagerRole() throws Exception {
        UserModel anotherManager = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(anotherManager, this.publicSiteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(this.manager);
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(anotherManager).assertThat().field("id").is((Object)anotherManager.getUsername())).and().field("role").is((Object)anotherManager.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role gets site member with Manager role and status code is OK (200)")
    public void getSiteManagerMemberWithCollaboratorRole() throws Exception {
        this.restClient.authenticateUser(this.collaborator);
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(this.manager).assertThat().field("id").is((Object)this.manager.getUsername())).and().field("role").is((Object)this.manager.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role gets site member with Manager role and status code is OK (200)")
    public void getSiteManagerMemberWithConsumerRole() throws Exception {
        this.restClient.authenticateUser(this.consumer);
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(this.manager).assertThat().field("id").is((Object)this.manager.getUsername())).and().field("role").is((Object)this.manager.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role gets site member with Manager role and status code is OK (200)")
    public void getSiteManagerMemberWithContributorRole() throws Exception {
        this.restClient.authenticateUser(this.contributor);
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(this.manager).assertThat().field("id").is((Object)this.manager.getUsername())).and().field("role").is((Object)this.manager.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role gets admin site member and status code is OK (200)")
    public void getSiteAdminManagerMember() throws Exception {
        this.restClient.authenticateUser(this.contributor);
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(this.adminUser).assertThat().field("id").is((Object)this.adminUser.getUsername())).and().field("role").is((Object)UserRole.SiteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role gets site member with Contributor role and status code is OK (200)")
    public void getSiteContributorMemberWithCollaboratorRole() throws Exception {
        ((RestSiteMemberModel)this.restClient.authenticateUser(this.collaborator).withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(this.contributor).assertThat().field("id").is((Object)this.contributor.getUsername())).and().field("role").is((Object)this.contributor.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role gets site member with Collaborator role and status code is OK (200)")
    public void getSiteCollaboratorMemberWithContributorRole() throws Exception {
        ((RestSiteMemberModel)this.restClient.authenticateUser(this.contributor).withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(this.collaborator).assertThat().field("id").is((Object)this.collaborator.getUsername())).and().field("role").is((Object)this.collaborator.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role gets admin role and status code is OK (200)")
    public void getAdminWithCollaboratorRole() throws Exception {
        ((RestSiteMemberModel)this.restClient.authenticateUser(this.collaborator).withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(this.adminUser).assertThat().field("id").is((Object)this.adminUser.getUsername())).and().field("role").is((Object)UserRole.SiteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role gets site member with Consumer role and status code is OK (200)")
    public void getSiteConsumerMemberWithCollaboratorRole() throws Exception {
        ((RestSiteMemberModel)this.restClient.authenticateUser(this.collaborator).withCoreAPI().usingSite(this.publicSiteModel).getSiteMember(this.consumer).assertThat().field("id").is((Object)this.consumer.getUsername())).and().field("role").is((Object)this.consumer.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets site member of private site and status code is OK (200)")
    public void getSiteMemberOfPrivateSite() throws Exception {
        ((RestSiteMemberModel)this.restClient.authenticateUser(this.manager).withCoreAPI().usingSite(this.privateSiteModel).getSiteMember(this.consumer).assertThat().field("id").is((Object)this.consumer.getUsername())).and().field("role").is((Object)this.consumer.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify not joined user is not is not able to get site member of private site and status code is 404")
    public void regularUserIsNotAbleToGetSiteMemberOfPrivateSite() throws Exception {
        UserModel regularUser = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(regularUser).withCoreAPI().usingSite(this.privateSiteModel).getSiteMember(this.consumer);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.consumer.getUsername(), this.privateSiteModel.getTitle()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to get from site a user that created a member request that was not accepted yet")
    @Test(groups={"rest-api", "sites", "regression"})
    public void adminIsNotAbleToGetFromSiteANonExistingMember() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSiteModel);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(this.moderatedSiteModel).getSiteMember(newMember);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, newMember.getUsername(), this.moderatedSiteModel.getTitle())).containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets site creator and status code is OK (200)")
    public void getSiteCreator() throws Exception {
        SiteModel newSiteModel = ((DataSite)this.dataSite.usingUser(this.collaborator)).createModeratedRandomSite();
        this.dataUser.addUserToSite(this.consumer, this.publicSiteModel, UserRole.SiteConsumer);
        ((RestSiteMemberModel)this.restClient.authenticateUser(this.consumer).withCoreAPI().usingSite(newSiteModel).getSiteMember(this.collaborator).assertThat().field("id").is((Object)this.collaborator.getUsername())).and().field("role").is((Object)UserRole.SiteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role can get site member using \"-me-\" in place of personId")
    public void getSiteMemberOfPrivateSiteUsingMeForPersonId() throws Exception {
        UserModel meUser = new UserModel("-me-", "password");
        ((RestSiteMemberModel)this.restClient.authenticateUser(this.consumer).withCoreAPI().usingSite(this.privateSiteModel).getSiteMember(meUser).assertThat().field("id").is((Object)this.consumer.getUsername())).and().field("role").is((Object)this.consumer.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets site member of moderated site and status code is OK (200)")
    public void getSiteMemberOfModeratedSite() throws Exception {
        ((RestSiteMemberModel)this.restClient.authenticateUser(this.manager).withCoreAPI().usingSite(this.moderatedSiteModel).getSiteMember(this.consumer).assertThat().field("id").is((Object)this.consumer.getUsername())).and().field("role").is((Object)this.consumer.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify not joined user gets site member of moderated site and status code is OK (200)")
    public void regularUserIsAbleToGetSiteMemberOfModeratedSite() throws Exception {
        UserModel regularUser = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(regularUser).withCoreAPI().usingSite(this.moderatedSiteModel).getSiteMember(this.consumer);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site member request with properties parameter returns status code 200 and parameter is applied")
    public void getSiteMemberUsingPropertiesParameter() throws Exception {
        ((RestSiteMemberModel)((RestSiteMemberModel)((RestSiteMemberModel)((Site)this.restClient.authenticateUser(this.manager).withCoreAPI().usingSite(this.publicSiteModel).usingParams(new String[]{"properties=id"})).getSiteMember(this.consumer).assertThat().fieldsCount().is((Object)2)).and().field("id").isNotEmpty()).and().field("role").isNull()).and().field("person").isNull();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }
}

