/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteProcessVariableCoreTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private UserModel adminUser;
    private RestProcessModel restProcessModel;
    private ProcessModel processModel;
    private RestProcessVariableModel variableModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsTask)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.processModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createSingleReviewerTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete invalid process variable")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteInvalidProcessVariable() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"x:InvalidVar");
        this.restProcessModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).deleteProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.variableModel.getName())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process variable twice")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessVariableTwice() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.restProcessModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).deleteProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).deleteProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.variableModel.getName()));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Remove process variables with empty processId")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessVariableEmptyProcessId() throws JsonToModelConversionException, Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.restProcessModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restProcessModel.setId("");
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).deleteProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "")).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process variable with admin.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessVariableWithAdmin() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.restProcessModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().usingProcess(this.processModel).deleteProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).getProcessVariables().assertThat().entriesListDoesNotContain("name", this.variableModel.getName());
    }
}

