/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.members;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteMemberModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class UpdateSiteMemberTests
extends RestTest {
    private UserModel adminUser;
    private UserModel siteCreator;
    private UserModel regularUser;
    private SiteModel publicSite;
    private SiteModel moderatedSite;
    private SiteModel privateSite;
    private DataUser.ListUserWithRoles publicSiteUsers;
    private UserModel userToBeUpdated;
    private RestSiteMemberModel updatedMember;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.siteCreator = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createPublicRandomSite();
        this.moderatedSite = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createModeratedRandomSite();
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createPrivateRandomSite();
        this.publicSiteUsers = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.regularUser = this.dataUser.createRandomTestUser();
        this.regularUser.setUserRole(UserRole.SiteConsumer);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that collaborator is not able to update site member and gets status code FORBIDDEN (403)")
    public void collaboratorIsNotAbleToUpdateSiteMember() throws Exception {
        this.userToBeUpdated = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(this.userToBeUpdated, this.publicSite, UserRole.SiteConsumer);
        this.userToBeUpdated.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingSite(this.publicSite).updateSiteMember(this.userToBeUpdated);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
        this.restClient.assertLastError().containsSummary(String.format("The current user does not have permissions to modify the membership details of the site %s.", this.publicSite.getTitle()));
    }

    @Bug(id="REPO-1832")
    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that collaborator is not able to update site member and gets status code FORBIDDEN (403)")
    public void collaboratorIsNotAbleToUpdateSiteMemberWithTheSameRole() throws Exception {
        this.userToBeUpdated = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(this.userToBeUpdated, this.publicSite, UserRole.SiteConsumer);
        this.userToBeUpdated.setUserRole(UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingSite(this.publicSite).updateSiteMember(this.userToBeUpdated);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
        this.restClient.assertLastError().containsSummary(String.format("The current user does not have permissions to modify the membership details of the site %s.", this.publicSite.getTitle()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that contributor is not able to update site member and gets status code FORBIDDEN (403)")
    public void contributorIsNotAbleToUpdateSiteMember() throws Exception {
        this.userToBeUpdated = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(this.userToBeUpdated, this.publicSite, UserRole.SiteConsumer);
        this.userToBeUpdated.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingSite(this.publicSite).updateSiteMember(this.userToBeUpdated);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
        this.restClient.assertLastError().containsSummary(String.format("The current user does not have permissions to modify the membership details of the site %s.", this.publicSite.getTitle()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that consumer is not able to update site member and gets status code FORBIDDEN (403)")
    public void consumerIsNotAbleToUpdateSiteMember() throws Exception {
        this.userToBeUpdated = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(this.userToBeUpdated, this.publicSite, UserRole.SiteConsumer);
        this.userToBeUpdated.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingSite(this.publicSite).updateSiteMember(this.userToBeUpdated);
        this.restClient.assertLastError().containsSummary(String.format("The current user does not have permissions to modify the membership details of the site %s.", this.publicSite.getTitle()));
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin is able to update site member and gets status code OK (200)")
    public void adminIsAbleToUpdateSiteMember() throws Exception {
        this.userToBeUpdated = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(this.userToBeUpdated, this.publicSite, UserRole.SiteConsumer);
        this.userToBeUpdated.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.adminUser);
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(this.publicSite).updateSiteMember(this.userToBeUpdated).assertThat().field("id").is((Object)this.userToBeUpdated.getUsername())).and().field("role").is((Object)this.userToBeUpdated.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify that unauthenticated user is not able to update site member")
    public void unauthenticatedUserIsNotAuthorizedToUpdateSiteMmeber() throws Exception {
        this.userToBeUpdated = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(this.userToBeUpdated, this.publicSite, UserRole.SiteConsumer);
        this.userToBeUpdated.setUserRole(UserRole.SiteCollaborator);
        UserModel inexistentUser = new UserModel("inexistent user", "inexistent password");
        this.restClient.authenticateUser(inexistentUser);
        this.restClient.withCoreAPI().usingSite(this.publicSite).updateSiteMember(this.userToBeUpdated);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if update site member request returns status code 404 when nonexistent siteId is used")
    public void updateSiteMemberOfNonexistentSite() throws Exception {
        SiteModel deletedSite = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.dataUser.addUserToSite(this.regularUser, deletedSite, UserRole.SiteConsumer);
        this.dataSite.deleteSite(deletedSite);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(deletedSite).updateSiteMember(this.regularUser);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, deletedSite.getId()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if update site member request returns status code 400 when personId is not member of the site")
    public void updateNotASiteMember() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(this.publicSite).updateSiteMember(this.regularUser);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("User is not a member of the site");
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if update site member request returns status code 404 when personId does not exist")
    public void updateNonexistentSiteMember() throws Exception {
        UserModel nonexistentUser = new UserModel("nonexistentUser", DataUser.PASSWORD);
        nonexistentUser.setUserRole(UserRole.SiteContributor);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(this.publicSite).updateSiteMember(nonexistentUser);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, nonexistentUser.getUsername()));
    }

    @Bug(id="REPO-1941")
    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if a manager is able to downgrade to contributor using -me- string in place of personId.")
    public void updateSiteManagerToSiteContributorUsingMe() throws Exception {
        UserModel meManager = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(meManager, this.publicSite, UserRole.SiteManager);
        UserModel meUser = new UserModel("-me-", "password");
        meUser.setUserRole(UserRole.SiteContributor);
        this.updatedMember = this.restClient.authenticateUser(meManager).withCoreAPI().usingSite(this.publicSite).updateSiteMember(meUser);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)meManager.getUsername())).and().field("role").is((Object)meUser.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if update site member request returns status code 404 when empty siteId is used")
    public void updateSiteMemberUsingEmptySiteId() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite("").updateSiteMember(this.regularUser);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if update site member request returns status code 405 when empty personId is used")
    public void updateSiteMemberUsingEmptyPersonId() throws Exception {
        UserModel emptyUser = new UserModel("", DataUser.PASSWORD);
        emptyUser.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(this.publicSite).updateSiteMember(emptyUser);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.PUT_EMPTY_ARGUMENT);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if update site member request returns status code 400 when invalid role is used")
    public void updateSiteMemberUsingInvalidRole() throws Exception {
        this.restClient.authenticateUser(this.siteCreator).withCoreAPI();
        UserModel siteConsumer = this.publicSiteUsers.getOneUserWithRole(UserRole.SiteConsumer);
        String json = JsonBodyGenerator.keyValueJson((String)"role", (String)"invalidRole");
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)json, (String)"sites/{siteId}/members/{personId}", (String[])new String[]{this.publicSite.getId(), siteConsumer.getUsername()});
        this.restClient.processModel(RestSiteMemberModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.UNKNOWN_ROLE, "invalidRole"));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update another site manager to site collaborator")
    public void managerUpdateSiteManagerToSiteCollaborator() throws Exception {
        UserModel siteManager = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteManager, this.publicSite, UserRole.SiteManager);
        siteManager.setUserRole(UserRole.SiteCollaborator);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteManager.getUsername())).and().field("role").is((Object)siteManager.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update site contributor to site manager")
    public void managerUpdateSiteContributorToSiteManager() throws Exception {
        UserModel siteContributor = this.publicSiteUsers.getOneUserWithRole(UserRole.SiteContributor);
        siteContributor.setUserRole(UserRole.SiteManager);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteContributor);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteContributor.getUsername())).and().field("role").is((Object)siteContributor.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update site collaborator to site manager")
    public void managerUpdateSiteCollaboratorToSiteManager() throws Exception {
        UserModel siteCollaborator = this.publicSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator);
        siteCollaborator.setUserRole(UserRole.SiteManager);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteCollaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteCollaborator.getUsername())).and().field("role").is((Object)siteCollaborator.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify if manager is able to update site consumer to site manager")
    public void managerUpdateSiteConsumerToSiteManager() throws Exception {
        UserModel siteConsumer = this.publicSiteUsers.getOneUserWithRole(UserRole.SiteConsumer);
        siteConsumer.setUserRole(UserRole.SiteManager);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteConsumer);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteConsumer.getUsername())).and().field("role").is((Object)siteConsumer.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to downgrade himself to site consumer")
    public void publicSiteManagerDowngradesRole() throws Exception {
        UserModel siteManager = this.publicSiteUsers.getOneUserWithRole(UserRole.SiteManager);
        siteManager.setUserRole(UserRole.SiteConsumer);
        this.updatedMember = this.restClient.authenticateUser(siteManager).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteManager.getUsername())).and().field("role").is((Object)siteManager.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update another site manager to site contributor")
    public void managerUpdateSiteManagerToSiteContributor() throws Exception {
        UserModel siteManager = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteManager, this.publicSite, UserRole.SiteManager);
        siteManager.setUserRole(UserRole.SiteContributor);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteManager.getUsername())).and().field("role").is((Object)siteManager.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update another site manager to site consumer")
    public void managerUpdateSiteManagerToSiteConsumer() throws Exception {
        UserModel siteManager = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteManager, this.publicSite, UserRole.SiteManager);
        siteManager.setUserRole(UserRole.SiteConsumer);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteManager.getUsername())).and().field("role").is((Object)siteManager.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update site contributor to site collaborator")
    public void managerUpdateSiteContributorToSiteCollaborator() throws Exception {
        UserModel siteContributor = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteContributor, this.publicSite, UserRole.SiteContributor);
        siteContributor.setUserRole(UserRole.SiteCollaborator);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteContributor);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteContributor.getUsername())).and().field("role").is((Object)siteContributor.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update site contributor to site consumer")
    public void managerUpdateSiteContributorToSiteConsumer() throws Exception {
        UserModel siteContributor = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteContributor, this.publicSite, UserRole.SiteContributor);
        siteContributor.setUserRole(UserRole.SiteConsumer);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteContributor);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteContributor.getUsername())).and().field("role").is((Object)siteContributor.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update site collaborator to site contributor")
    public void managerUpdateSiteCollaboratorToSiteContributor() throws Exception {
        UserModel siteCollaborator = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteCollaborator, this.publicSite, UserRole.SiteCollaborator);
        siteCollaborator.setUserRole(UserRole.SiteContributor);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteCollaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteCollaborator.getUsername())).and().field("role").is((Object)siteCollaborator.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update site collaborator to site consumer")
    public void managerUpdateSiteCollaboratorToSiteConsumer() throws Exception {
        UserModel siteCollaborator = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteCollaborator, this.publicSite, UserRole.SiteCollaborator);
        siteCollaborator.setUserRole(UserRole.SiteConsumer);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteCollaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteCollaborator.getUsername())).and().field("role").is((Object)siteCollaborator.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update site consumer to site collaborator")
    public void managerUpdateSiteConsumerToSiteCollaborator() throws Exception {
        UserModel siteConsumer = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteConsumer, this.publicSite, UserRole.SiteConsumer);
        siteConsumer.setUserRole(UserRole.SiteCollaborator);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteConsumer);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteConsumer.getUsername())).and().field("role").is((Object)siteConsumer.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update site consumer to site contributor")
    public void managerUpdateSiteConsumerToSiteContributor() throws Exception {
        UserModel siteConsumer = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteConsumer, this.publicSite, UserRole.SiteConsumer);
        siteConsumer.setUserRole(UserRole.SiteContributor);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteConsumer);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteConsumer.getUsername())).and().field("role").is((Object)siteConsumer.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update another site manager to site manager")
    public void managerUpdateSiteManagerToSiteManager() throws Exception {
        UserModel siteManager = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteManager, this.publicSite, UserRole.SiteManager);
        siteManager.setUserRole(UserRole.SiteManager);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteManager.getUsername())).and().field("role").is((Object)siteManager.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update site collaborator to site collaborator")
    public void managerUpdateSiteCollaboratorToSiteCollaborator() throws Exception {
        UserModel siteCollaborator = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteCollaborator, this.publicSite, UserRole.SiteCollaborator);
        siteCollaborator.setUserRole(UserRole.SiteCollaborator);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteCollaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteCollaborator.getUsername())).and().field("role").is((Object)siteCollaborator.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update site contributor to site contributor")
    public void managerUpdateSiteContributorToSiteContributor() throws Exception {
        UserModel siteContributor = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteContributor, this.publicSite, UserRole.SiteContributor);
        siteContributor.setUserRole(UserRole.SiteContributor);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteContributor);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteContributor.getUsername())).and().field("role").is((Object)siteContributor.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update site consumer to site consumer")
    public void managerUpdateSiteConsumerToSiteConsumer() throws Exception {
        UserModel siteConsumer = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteConsumer, this.publicSite, UserRole.SiteConsumer);
        siteConsumer.setUserRole(UserRole.SiteConsumer);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.publicSite).updateSiteMember(siteConsumer);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteConsumer.getUsername())).and().field("role").is((Object)siteConsumer.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager of a private site is able to downgrade his role")
    public void privateSiteManagerDowngradesRole() throws Exception {
        UserModel siteManager = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteManager, this.privateSite, UserRole.SiteManager);
        siteManager.setUserRole(UserRole.SiteConsumer);
        this.updatedMember = this.restClient.authenticateUser(siteManager).withCoreAPI().usingSite(this.privateSite).updateSiteMember(siteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteManager.getUsername())).and().field("role").is((Object)siteManager.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager of a moderated site is able to downgrade his role")
    public void moderatedSiteManagerDowngradesRole() throws Exception {
        UserModel siteManager = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteManager, this.moderatedSite, UserRole.SiteManager);
        siteManager.setUserRole(UserRole.SiteConsumer);
        this.updatedMember = this.restClient.authenticateUser(siteManager).withCoreAPI().usingSite(this.moderatedSite).updateSiteMember(siteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)siteManager.getUsername())).and().field("role").is((Object)siteManager.getUserRole());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify the response of updating a site member with empty body at request")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void managerCanNotUpdateSiteMemberWithEmptyBody() throws Exception {
        this.restClient.authenticateUser(this.siteCreator).withCoreAPI();
        UserModel siteCollaborator = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteCollaborator, this.publicSite, UserRole.SiteCollaborator);
        siteCollaborator.setUserRole(UserRole.SiteConsumer);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"", (String)"sites/{siteId}/members/{personId}", (String[])new String[]{this.publicSite.getId(), siteCollaborator.getUsername()});
        this.restClient.processModel(RestSiteMemberModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "No content to map due to end-of-input")).containsErrorKey(String.format(RestErrorModel.NO_CONTENT, "No content to map due to end-of-input")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if manager is able to update a user that has created a site membership request, but it's not a member of the site yet")
    public void managerCanNotUpdateUserWithSiteMembershipRequest() throws Exception {
        UserModel siteConsumer = this.dataUser.createRandomTestUser();
        siteConsumer.setUserRole(UserRole.SiteConsumer);
        this.restClient.authenticateUser(siteConsumer).withCoreAPI().usingUser(siteConsumer).addSiteMembershipRequest(this.moderatedSite);
        this.updatedMember = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite).updateSiteMember(siteConsumer);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NOT_A_MEMBER);
    }
}

