/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestItemModelsCollection;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddProcessItemFullTests
extends RestTest {
    private FileModel document;
    private FileModel document2;
    private SiteModel siteModel;
    private UserModel userWhoStartsProcess;
    private UserModel assignee;
    private UserModel adminUser;
    private ProcessModel processModel;
    private RestItemModel processItem;
    private RestItemModelsCollection processItems;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.document2 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.MSPOWERPOINT);
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsProcess)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple process items is falling in case of empty process id is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingMultipleProcessItemsIfEmptyProcessIdIsProvided() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        FileModel testDocument = ((DataContent)this.dataContent.usingAdmin().usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.processModel.setId("");
        this.processItems = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItems(new FileModel[]{testDocument, this.document});
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_WAS_NOT_FOUND, ""));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process items is falling in case of empty process id is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessItemsIfEmptyProcessIdIsProvided() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        FileModel testDocument = ((DataContent)this.dataContent.usingAdmin().usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.processModel.setId("");
        this.processItem = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItem(testDocument);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_WAS_NOT_FOUND, ""));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process item is falling in case of empty body item value is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessItemIfEmptyItemBodyIsProvided() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.document.setNodeRef("");
        this.processItem = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItem(this.document);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.REQUIRED_TO_ADD, "itemId"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple process items is falling in case of empty body item value is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingMultipleProcessItemsIfEmptyItemBodyIsProvided() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.document.setNodeRef("");
        this.processItems = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItems(new FileModel[]{this.document, this.document2});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.REQUIRED_TO_ADD, "itemId"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add a new process item, update the item and then delete.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void createDeleteCreateMultipleProcessItems() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.document2 = ((DataContent)this.dataContent.usingAdmin().usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.MSPOWERPOINT);
        this.processItems = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItems(new FileModel[]{this.document, this.document2});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).deleteProcessItem(((RestItemModel)this.processItems.getEntries().get(0)).onModel());
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).getProcessItems().assertThat().entriesListDoesNotContain("name", ((RestItemModel)this.processItems.getEntries().get(0)).onModel().getName());
        this.processItems = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItems(new FileModel[]{this.document});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add a new process item, delete the item and create it again.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void createDeleteCreateProcessItem() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processItem = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).deleteProcessItem(this.processItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).getProcessItems().assertThat().entriesListDoesNotContain("name", this.processItem.getName());
        this.processItem = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).getProcessItems().assertThat().entriesListContains("name", this.processItem.getName());
    }
}

