/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.nodes;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.body.RestNodeLockBodyModel;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.search.RestRequestFilterQueryModel;
import org.alfresco.rest.search.RestRequestQueryModel;
import org.alfresco.rest.search.SearchRequest;
import org.alfresco.rest.search.SearchResponse;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class NodesLockTests
extends RestTest {
    private UserModel user1;
    private UserModel user2;
    private UserModel adminUser;
    private SiteModel publicSite;
    private FileModel file1;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.user1 = this.dataUser.createRandomTestUser();
        this.user2 = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(this.user1, this.publicSite, UserRole.SiteCollaborator);
        this.user1.setUserRole(UserRole.SiteCollaborator);
        this.dataUser.addUserToSite(this.user2, this.publicSite, UserRole.SiteCollaborator);
        this.user2.setUserRole(UserRole.SiteCollaborator);
    }

    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can not lock PERSISTENT after EPHEMERAL lock made by different user")
    public void lockEphemeralAndRelockPersistentDifferentUser() throws Exception {
        Step.STEP((String)"1. Administrator adds a file in the site.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode EPHEMERAL for 20 seconds with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("EPHEMERAL");
        lockBodyModel.setTimeToExpire(20);
        lockBodyModel.setType("FULL");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with user1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
        Step.STEP((String)"5. Cannot lock the file using mode PERSISTENT with user2 while the file is still locked");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("PERSISTENT");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("ALLOW_OWNER_CHANGES");
        ((Node)this.restClient.authenticateUser(this.user2).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).containsSummary(String.format(RestErrorModel.LOCKED_NODE_SUMMARY, this.file1.getNodeRefWithoutVersion())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can not lock EPHEMERAL after EPHEMERAL lock made by different user")
    public void lockEphemeralAndRelockEphemeralDifferentUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode EPHEMERAL with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("EPHEMERAL");
        lockBodyModel.setTimeToExpire(20);
        lockBodyModel.setType("FULL");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with user1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
        Step.STEP((String)"5. Cannot lock the file using mode EPHEMERAL with user2 while the file is still locked");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("EPHEMERAL");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("FULL");
        ((Node)this.restClient.authenticateUser(this.user2).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).containsSummary(String.format(RestErrorModel.LOCKED_NODE_SUMMARY, this.file1.getNodeRefWithoutVersion())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can lock EPHEMERAL after EPHEMERAL lock made by same user")
    public void lockEphemeralAndRelockEphemeralSameUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode EPHEMERAL with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("EPHEMERAL");
        lockBodyModel.setTimeToExpire(20);
        lockBodyModel.setType("FULL");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with user1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
        Step.STEP((String)"5. Lock the file using mode EPHEMERAL with user1 while the file is still locked");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("EPHEMERAL");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("FULL");
        RestNodeModel file1Model3 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestNodeModel)((RestNodeModel)file1Model3.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
    }

    @Bug(id="MNT-17612", status=Bug.Status.FIXED, description="AccessDeniedException in AOS Edit Offline Upload New Version")
    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can lock PERSISTENT after EPHEMERAL lock made by same user")
    public void lockEphemeralAndRelockPersistentSameUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode EPHEMERAL with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("EPHEMERAL");
        lockBodyModel.setTimeToExpire(2);
        lockBodyModel.setType("FULL");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with user1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
        Step.STEP((String)"5. Lock the file using mode PERSISTENT with user1 while the file is still locked");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("PERSISTENT");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("ALLOW_OWNER_CHANGES");
        RestNodeModel file1Model3 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestNodeModel)((RestNodeModel)file1Model3.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
        Step.STEP((String)"6. Verify that the file is locked PERSISTENT only after EPHEMERAL lock has expired");
        Utility.sleep((int)500, (int)5000, () -> {
            RestNodeModel file1Model4 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
            ((RestNodeModel)((RestNodeModel)file1Model4.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=WRITE_LOCK");
        });
    }

    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can not lock EPHEMERAL after PERSISTENT lock made by different user")
    public void lockPersistentAndRelockEphemeralDifferentUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode PERSISTENT with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("PERSISTENT");
        lockBodyModel.setTimeToExpire(20);
        lockBodyModel.setType("ALLOW_OWNER_CHANGES");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with user1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=WRITE_LOCK");
        Step.STEP((String)"5. Cannot lock the file using mode EPHEMERAL with user2 while the file is still locked");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("EPHEMERAL");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("FULL");
        ((Node)this.restClient.authenticateUser(this.user2).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).containsSummary(String.format(RestErrorModel.LOCKED_NODE_SUMMARY, this.file1.getNodeRefWithoutVersion())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can not lock PERSISTENT after PERSISTENT lock made by different user")
    public void lockPersistentAndRelockPersistentDifferentUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode PERSISTENT with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("PERSISTENT");
        lockBodyModel.setTimeToExpire(20);
        lockBodyModel.setType("ALLOW_OWNER_CHANGES");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with user1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=WRITE_LOCK");
        Step.STEP((String)"5. Cannot lock the file using mode PERSISTENT with user2 while the file is still locked");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("PERSISTENT");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("ALLOW_OWNER_CHANGES");
        ((Node)this.restClient.authenticateUser(this.user2).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).containsSummary(String.format(RestErrorModel.LOCKED_NODE_SUMMARY, this.file1.getNodeRefWithoutVersion())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can lock EPHEMERAL after PERSISTENT lock made by different user is expired")
    public void lockPersistentAndRelockEphemeralAfterExpiredLockDifferentUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode PERSISTENT with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("PERSISTENT");
        lockBodyModel.setTimeToExpire(1);
        lockBodyModel.setType("ALLOW_OWNER_CHANGES");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with admin that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=WRITE_LOCK");
        Step.STEP((String)"5. Lock the file using mode EPHEMERAL with user2 while the first lock has expired");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("EPHEMERAL");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("FULL");
        Utility.sleep((int)500, (int)5000, () -> {
            RestNodeModel file1Model3 = ((Node)this.restClient.authenticateUser(this.user2).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            ((RestNodeModel)((RestNodeModel)file1Model3.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
        });
    }

    @Bug(id="REPO-4790")
    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can lock PERSISTENT after EPHEMERAL lock made by another user is expired")
    public void lockEphemeralAndRelockPersistentAfterExpiredLockDifferentUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode EPHEMERAL with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("EPHEMERAL");
        lockBodyModel.setTimeToExpire(1);
        lockBodyModel.setType("FULL");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with user1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
        Step.STEP((String)"5. Lock the file using mode PERSISTENT with user2 after the first lock has expired");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("PERSISTENT");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("ALLOW_OWNER_CHANGES");
        Utility.sleep((int)500, (int)5000, () -> {
            RestNodeModel file1Model3 = ((Node)this.restClient.authenticateUser(this.user2).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            ((RestNodeModel)((RestNodeModel)file1Model3.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=WRITE_LOCK");
        });
    }

    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can lock EPHEMERAL after EPHEMERAL lock made by another user is expired")
    public void lockEphemeralAndRelockEphemeralAfterExpiredLockDifferentUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode EPHEMERAL with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("EPHEMERAL");
        lockBodyModel.setTimeToExpire(1);
        lockBodyModel.setType("FULL");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with user1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
        Step.STEP((String)"5. Lock the file using mode EPHEMERAL with user2 while the first lock has expired");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("EPHEMERAL");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("FULL");
        Utility.sleep((int)500, (int)5000, () -> {
            RestNodeModel file1Model3 = ((Node)this.restClient.authenticateUser(this.user2).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            ((RestNodeModel)((RestNodeModel)file1Model3.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
        });
    }

    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can lock PERSISTENT after PERSISTENT lock made by different user is expired")
    public void lockPersistentAndRelockPersistentAfterExpiredLockDifferentUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode PERSISTENT with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("PERSISTENT");
        lockBodyModel.setTimeToExpire(1);
        lockBodyModel.setType("ALLOW_OWNER_CHANGES");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with admin that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=WRITE_LOCK");
        Step.STEP((String)"5. Lock the file using mode PERSISTENT with user2 after the first lock has expired");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("PERSISTENT");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("ALLOW_OWNER_CHANGES");
        Utility.sleep((int)500, (int)5000, () -> {
            RestNodeModel file1Model3 = ((Node)this.restClient.authenticateUser(this.user2).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            ((RestNodeModel)((RestNodeModel)file1Model3.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=WRITE_LOCK");
        });
    }

    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can lock EPHEMERAL after EPHEMERAL lock made by same user is expired")
    public void lockEphemeralAndRelockEphemeralAfterExpiredLockSameUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode EPHEMERAL with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("EPHEMERAL");
        lockBodyModel.setTimeToExpire(1);
        lockBodyModel.setType("FULL");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with user1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
        Step.STEP((String)"5. Lock the file using mode EPHEMERAL with user1 after the first lock has expired");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("EPHEMERAL");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("FULL");
        Utility.sleep((int)500, (int)5000, () -> {
            RestNodeModel file1Model3 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            ((RestNodeModel)((RestNodeModel)file1Model3.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
        });
    }

    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can lock PERSISTENT after PERSISTENT lock made by same user is expired")
    public void lockPersistentAndRelockPersistentAfterExpiredLockSameUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode PERSISTENT with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("PERSISTENT");
        lockBodyModel.setTimeToExpire(1);
        lockBodyModel.setType("ALLOW_OWNER_CHANGES");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with user1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model2.assertThat().field("isLocked").is((Object)true);
        file1Model2.assertThat().field("properties").contains("lockLifetime=PERSISTENT");
        Step.STEP((String)"5. Lock the file using mode PERSISTENT with user1 while the first lock has expired");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("PERSISTENT");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("ALLOW_OWNER_CHANGES");
        Utility.sleep((int)500, (int)5000, () -> {
            RestNodeModel file1Model3 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            ((RestNodeModel)((RestNodeModel)file1Model3.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=WRITE_LOCK");
        });
    }

    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can lock EPHEMERAL after PERSISTENT lock made by same user is expired")
    public void lockPersistentAndRelockEphemeralAfterExpiredLockSameUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode PERSISTENT with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("PERSISTENT");
        lockBodyModel.setTimeToExpire(1);
        lockBodyModel.setType("ALLOW_OWNER_CHANGES");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with admin that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=WRITE_LOCK");
        Step.STEP((String)"5. Lock the file using mode EPHEMERAL with user1 while the first lock has expired");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("EPHEMERAL");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("FULL");
        Utility.sleep((int)500, (int)5000, () -> {
            RestNodeModel file1Model3 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            ((RestNodeModel)((RestNodeModel)file1Model3.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
        });
    }

    @Bug(id="REPO-4809")
    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can lock PERSISTENT after EPHEMERAL lock made by same user is expired")
    public void lockEphemeralAndRelockPersistentAfterExpiredLockSameUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode EPHEMERAL with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("EPHEMERAL");
        lockBodyModel.setTimeToExpire(1);
        lockBodyModel.setType("FULL");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with useer1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
        Step.STEP((String)"5. Lock the file using mode PERSISTENT with user1 while the first lock has expired");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("PERSISTENT");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("ALLOW_OWNER_CHANGES");
        Utility.sleep((int)500, (int)5000, () -> {
            RestNodeModel file1Model3 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            ((RestNodeModel)((RestNodeModel)file1Model3.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=WRITE_LOCK");
        });
    }

    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can lock PERSISTENT after PERSISTENT lock made by same user")
    public void lockPersistentAndRelockPersistentSameUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode PERSISTENT with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("PERSISTENT");
        lockBodyModel.setTimeToExpire(20);
        lockBodyModel.setType("ALLOW_OWNER_CHANGES");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with user1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=WRITE_LOCK");
        Step.STEP((String)"5. Lock the file using mode PERSISTENT with user1 while the file is still locked");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("PERSISTENT");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("ALLOW_OWNER_CHANGES");
        RestNodeModel file1Model3 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        file1Model3.assertThat().field("isLocked").is((Object)true);
        ((RestNodeModel)file1Model3.assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=WRITE_LOCK");
    }

    @Test(groups={"rest-api", "nodes", "regression"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator can lock EPHERMERAL after PERSISTENT lock made by same user")
    public void lockPersistentAndRelockEphemeralSameUser() throws Exception {
        Step.STEP((String)"1. Adds a file in the site by administrator.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode PERSISTENT with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("PERSISTENT");
        lockBodyModel.setTimeToExpire(1);
        lockBodyModel.setType("ALLOW_OWNER_CHANGES");
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with user1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        ((RestNodeModel)((RestNodeModel)file1Model2.assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=WRITE_LOCK");
        Step.STEP((String)"5. Lock the file using mode EPHERMERAL with user1 while the file is still locked");
        RestNodeLockBodyModel lockBodyModel2 = new RestNodeLockBodyModel();
        lockBodyModel2.setLifetime("EPHEMERAL");
        lockBodyModel2.setTimeToExpire(20);
        lockBodyModel2.setType("FULL");
        RestNodeModel file1Model3 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel2);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        file1Model3.assertThat().field("isLocked").is((Object)true);
        ((RestNodeModel)file1Model3.assertThat().field("properties").contains("lockLifetime=EPHEMERAL")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
    }

    @Test(groups={"rest-api", "nodes", "regression", "require-solr"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify that child nodes can be locked differently and unlocked")
    public void testLockUnlockParentChild() throws Exception {
        Step.STEP((String)"1. Create user, site, parent node and children nodes.");
        SiteModel siteLock = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        FolderModel parentNode = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(siteLock)).createFolder();
        FileModel childNode1 = ((DataContent)((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(siteLock)).usingResource((ContentModel)parentNode)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        FileModel childNode2 = ((DataContent)((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(siteLock)).usingResource((ContentModel)parentNode)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel restNodeResponse = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)parentNode).usingParams(new String[]{"include=isLocked"})).getNode();
        restNodeResponse.assertThat().field("isLocked").is((Object)false);
        restNodeResponse = ((Node)this.restClient.withCoreAPI().usingNode((RepoTestModel)childNode1).usingParams(new String[]{"include=isLocked"})).getNode();
        restNodeResponse.assertThat().field("isLocked").is((Object)false);
        restNodeResponse = ((Node)this.restClient.withCoreAPI().usingNode((RepoTestModel)childNode2).usingParams(new String[]{"include=isLocked"})).getNode();
        restNodeResponse.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock  childNode1 using mode PERSISTENT with adminUser (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("PERSISTENT");
        lockBodyModel.setTimeToExpire(0);
        lockBodyModel.setType("ALLOW_OWNER_CHANGES");
        restNodeResponse = ((Node)this.restClient.withCoreAPI().usingNode((RepoTestModel)childNode1).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestNodeModel)((RestNodeModel)((RestNodeModel)restNodeResponse.assertThat().field("aspectNames").contains("cm:lockable")).assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=WRITE_LOCK");
        Step.STEP((String)"4. Lock childNode2 using mode PERSISTENT with adminUser (POST nodes/{nodeId}/lock).");
        lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("PERSISTENT");
        lockBodyModel.setTimeToExpire(0);
        lockBodyModel.setType("FULL");
        restNodeResponse = ((Node)this.restClient.withCoreAPI().usingNode((RepoTestModel)childNode2).usingParams(new String[]{"include=isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestNodeModel)((RestNodeModel)((RestNodeModel)restNodeResponse.assertThat().field("aspectNames").contains("cm:lockable")).assertThat().field("isLocked").is((Object)true)).assertThat().field("properties").contains("lockLifetime=PERSISTENT")).assertThat().field("properties").contains("lockType=READ_ONLY_LOCK");
        Step.STEP((String)"5. Verify that childNode1 and childNode 2 are locked.");
        SearchRequest query = new SearchRequest();
        RestRequestQueryModel queryReq = new RestRequestQueryModel();
        RestRequestFilterQueryModel queryFilters = new RestRequestFilterQueryModel();
        queryFilters.setQuery("cm:lockOwner:'admin'");
        queryReq.setQuery("ASPECT:'cm:lockable'");
        query.setQuery(queryReq);
        query.setFilterQueries(queryFilters);
        query.setIncludeRequest(Boolean.valueOf(false));
        Utility.sleep((int)500, (int)60000, () -> {
            SearchResponse response = this.query(query);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            response.assertThat().entriesListContains("id", childNode1.getNodeRefWithoutVersion());
            response.assertThat().entriesListContains("id", childNode2.getNodeRefWithoutVersion());
        });
        Step.STEP((String)"6. Unlock the nodes.");
        restNodeResponse = ((Node)this.restClient.withCoreAPI().usingNode((RepoTestModel)childNode1).usingParams(new String[]{"include=isLocked"})).unlockNode();
        restNodeResponse.assertThat().field("isLocked").is((Object)false);
        restNodeResponse = ((Node)this.restClient.withCoreAPI().usingNode((RepoTestModel)childNode2).usingParams(new String[]{"include=isLocked"})).unlockNode();
        restNodeResponse.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"7. Verify that childNode1 and childNode2 are not found in the query results.");
        Utility.sleep((int)500, (int)60000, () -> {
            SearchResponse response = this.query(query);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            response.assertThat().entriesListDoesNotContain("id", childNode1.getNodeRefWithoutVersion());
            response.assertThat().entriesListDoesNotContain("id", childNode2.getNodeRefWithoutVersion());
        });
    }

    protected SearchResponse query(SearchRequest query) throws Exception {
        return this.restClient.authenticateUser(this.dataUser.getAdminUser()).withSearchAPI().search(query);
    }
}

