/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.renditions;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.RestRenditionInfoModel;
import org.alfresco.rest.model.RestRenditionInfoModelCollection;
import org.alfresco.rest.renditions.RenditionIntegrationTests;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"renditions"})
public class AvailableRenditionTests
extends RenditionIntegrationTests {
    private List<Object[]> renditionsToTest;

    @Override
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        super.dataPreparation();
        List<String> toTest = Arrays.asList("doc", "xls", "ppt", "docx", "xlsx", "pptx", "msg", "pdf", "png", "gif", "jpg");
        LinkedList<Object[]> renditionsForFiles = new LinkedList<Object[]>();
        for (String extensions : toTest) {
            String sourceFile = "quick/quick." + extensions;
            renditionsForFiles.addAll(this.uploadFileAndGetAvailableRenditions(sourceFile));
        }
        this.renditionsToTest = Collections.unmodifiableList(renditionsForFiles);
    }

    private List<Object[]> uploadFileAndGetAvailableRenditions(String sourceFile) throws Exception {
        RestNodeModel fileNode = this.uploadFile(sourceFile);
        FileModel file = new FileModel();
        file.setNodeRef(fileNode.getId());
        LinkedList<Object[]> renditionsForFile = new LinkedList<Object[]>();
        RestRenditionInfoModelCollection renditionsInfo = this.restClient.withCoreAPI().usingNode((RepoTestModel)file).getNodeRenditionsInfo();
        for (RestRenditionInfoModel m : renditionsInfo.getEntries()) {
            RestRenditionInfoModel renditionInfo = m.onModel();
            String renditionId = renditionInfo.getId();
            String targetMimeType = renditionInfo.getContent().getMimeType();
            renditionsForFile.add(new Object[]{sourceFile, fileNode.getId(), renditionId, targetMimeType});
        }
        return renditionsForFile;
    }

    @Test(dataProvider="RenditionTestDataProvider", groups={"rest-api", "renditions", "sanity"})
    @TestRail(section={"rest-api", "renditions"}, executionType={ExecutionType.SANITY}, description="Verify renditions created for a selection of test files via POST nodes/{nodeId}/renditions")
    public void supportedRenditionTest(String fileName, String nodeId, String renditionId, String expectedMimeType) throws Exception {
        this.checkRendition(fileName, nodeId, renditionId, expectedMimeType);
    }

    @DataProvider(name="RenditionTestDataProvider")
    protected Iterator<Object[]> renditionTestDataProvider() throws Exception {
        return this.renditionsToTest.iterator();
    }

    @Test(groups={"rest-api", "renditions", "sanity"})
    @TestRail(section={"rest-api", "renditions"}, executionType={ExecutionType.SANITY}, description="Verify that there are some available renditions.")
    public void renditionsAvailableTest() {
        Assert.assertFalse((boolean)this.renditionsToTest.isEmpty(), (String)"No available renditions were reported for any of the test files.");
    }

    @Test(dataProvider="UnsupportedRenditionTestDataProvider", groups={"rest-api", "renditions", "sanity"})
    @TestRail(section={"rest-api", "renditions"}, executionType={ExecutionType.SANITY}, description="Verify that requests for unsupported renditions return 400 ")
    public void unsupportedRenditionTest(String sourceFile, String renditionId) throws Exception {
        RestNodeModel fileNode = this.uploadFile(sourceFile);
        FileModel file = new FileModel(sourceFile);
        file.setNodeRef(fileNode.getId());
        this.restClient.withCoreAPI().usingNode((RepoTestModel)file).createNodeRendition(renditionId);
        Assert.assertEquals((int)Integer.valueOf(this.restClient.getStatusCode()), (int)HttpStatus.BAD_REQUEST.value(), (String)("Expected to see the rendition rejected. [" + sourceFile + ", " + renditionId + "] [source file, rendition ID] "));
    }

    @DataProvider(name="UnsupportedRenditionTestDataProvider")
    protected Iterator<Object[]> unsupportedRenditionTestDataProvider() throws Exception {
        String renditionId = "pdf";
        LinkedList<Object[]> toTest = new LinkedList<Object[]>();
        toTest.add(new Object[]{"quick/quick.png", renditionId});
        toTest.add(new Object[]{"quick/quick.gif", renditionId});
        toTest.add(new Object[]{"quick/quick.jpg", renditionId});
        return toTest.iterator();
    }
}

