/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.groups;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteGroupModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSiteGroupTests
extends RestTest {
    private UserModel adminUser;
    private SiteModel publicSiteModel;
    private DataUser.ListUserWithRoles usersWithRoles;
    private GroupModel manager;
    private GroupModel consumer;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUser = this.dataUser.getAdminUser();
        this.publicSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.consumer = this.dataGroup.createRandomGroup();
        this.dataGroup.addListOfUsersToGroup(this.consumer, new UserModel[]{this.dataUser.createRandomTestUser()});
        this.manager = this.dataGroup.createRandomGroup();
        this.dataGroup.addListOfUsersToGroup(this.consumer, new UserModel[]{this.dataUser.createRandomTestUser()});
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(this.publicSiteModel).addSiteGroup(this.getId(this.manager), UserRole.SiteManager);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(this.publicSiteModel).addSiteGroup(this.getId(this.consumer), UserRole.SiteConsumer);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user can get site group and gets status code OK (200)")
    public void getSiteGroupWithAdminUser() throws Exception {
        this.restClient.authenticateUser(this.adminUser);
        ((RestSiteGroupModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteGroup(this.getId(this.manager)).and().field("id").is((Object)this.getId(this.manager))).and().field("role").is((Object)UserRole.SiteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Failed authentication get site group call returns status code 401")
    public void unauthenticatedUserIsNotAuthorizedToRetrieveSiteGroup() throws JsonToModelConversionException, Exception {
        UserModel inexistentUser = new UserModel("inexistent user", "inexistent password");
        this.restClient.authenticateUser(inexistentUser).withCoreAPI().usingSite(this.publicSiteModel).getSiteGroup(this.getId(this.consumer));
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager role doesn't get a site group of inexistent site and status code is Not Found (404)")
    public void getSiteGroupOfInexistentSite() throws Exception {
        SiteModel invalidSite = new SiteModel("invalidSite");
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(invalidSite).getSiteGroup(this.getId(this.consumer));
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_WAS_NOT_FOUND, invalidSite.getId()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager role doesn't get non site group of inexistent site and status code is Not Found (404)")
    public void getSiteGroupForNonSiteGroup() throws Exception {
        GroupModel nonGroup = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteGroup(this.getId(nonGroup));
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format("Given authority is not a member of the site", new Object[0]));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager role doesn't get not existing site group and status code is Not Found (404)")
    public void getSiteGroupForInexistentSiteGroup() throws Exception {
        GroupModel inexistentGroup = new GroupModel("inexistentGroup");
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteGroup(this.getId(inexistentGroup));
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format("An authority was not found for %s", this.getId(inexistentGroup)));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager role can get site group for empty siteId")
    public void getSiteGroupForEmptySiteId() throws Exception {
        SiteModel emptySite = new SiteModel("");
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(emptySite).getSiteGroup(this.getId(this.consumer));
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_WAS_NOT_FOUND, ""));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager role gets site groups with Manager role and status code is OK (200)")
    public void getSiteGroupWithManagerRole() throws Exception {
        GroupModel anotherManager = this.dataGroup.createRandomGroup();
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).addSiteGroup(this.getId(anotherManager), UserRole.SiteManager);
        ((RestSiteGroupModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteGroup(this.getId(anotherManager)).assertThat().field("id").is((Object)this.getId(anotherManager))).and().field("role").is((Object)UserRole.SiteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    String getId(GroupModel group) {
        return "GROUP_" + group.getGroupIdentifier();
    }
}

