/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes;

import java.util.List;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessesCoreTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel adminUser;
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private TaskModel task1;
    private TaskModel task2;
    private ProcessModel process3;
    private RestProcessDefinitionModel adhocProcessDefinition;
    private RestProcessDefinitionModel activitiReviewProcessDefinition;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsTask)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.task1 = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
        this.task2 = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.adminUser);
        this.process3 = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createSingleReviewerTaskAndAssignTo(this.assignee);
        this.adhocProcessDefinition = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getAllProcessDefinitions().getProcessDefinitionByKey("activitiAdhoc");
        this.activitiReviewProcessDefinition = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getAllProcessDefinitions().getProcessDefinitionByKey("activitiReview");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets all processes started by him ordered descending by id")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessesOrderedByIdDESC() throws Exception {
        RestProcessModelsCollection processes = this.restClient.authenticateUser(this.userWhoStartsTask).withParams(new String[]{"orderBy=id DESC"}).withWorkflowAPI().getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        processes.assertThat().entriesListIsNotEmpty();
        List processesList = processes.getEntries();
        ((RestProcessModel)processesList.get(0)).onModel().assertThat().field("id").is((Object)this.process3.getId());
        ((RestProcessModel)processesList.get(1)).onModel().assertThat().field("id").is((Object)this.task2.getProcessId());
        ((RestProcessModel)processesList.get(2)).onModel().assertThat().field("id").is((Object)this.task1.getProcessId());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets processes that matches a where clause")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessesWithWhereClauseAsParameter() throws JsonToModelConversionException, Exception {
        RestProcessModelsCollection processes = this.restClient.authenticateUser(this.userWhoStartsTask).where("processDefinitionKey='activitiReview'").withWorkflowAPI().getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)processes.assertThat().entriesListIsNotEmpty()).and().entriesListContains("processDefinitionId", this.activitiReviewProcessDefinition.getId())).and().entriesListDoesNotContain("processDefinitionId", this.adhocProcessDefinition.getId());
    }
}

