/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks;

import java.util.HashMap;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.rest.model.RestVariableModel;
import org.alfresco.rest.model.RestVariableModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class UpdateTaskTests
extends RestTest {
    UserModel owner;
    UserModel anyUser;
    SiteModel siteModel;
    FileModel fileModel;
    UserModel assigneeUser;
    TaskModel taskModel;
    RestTaskModel restTaskModel;
    UserModel adminUser;
    RestProcessDefinitionModel activitiReviewProcessDefinition;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.owner = this.dataUser.createRandomTestUser();
        this.anyUser = this.dataUser.createRandomTestUser();
        this.assigneeUser = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.activitiReviewProcessDefinition = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getAllProcessDefinitions().getProcessDefinitionByKey("activitiReviewPooled");
    }

    @BeforeMethod(alwaysRun=true)
    public void createTask() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.owner)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify admin user updates task with Rest API and response is successfull (200)")
    public void adminUserUpdatesAnyTaskWithSuccess() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("description").is((Object)this.taskModel.getMessage());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify assignee user updates its assigned task with Rest API and response is successfull (200)")
    public void assigneeUserUpdatesItsTaskWithSuccess() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("description").is((Object)this.taskModel.getMessage());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify user that started the task updates the started task with Rest API and response is successfull (200)")
    public void starterUserUpdatesItsTaskWithSuccess() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user with no relation to task is forbidden to update other task with Rest API (403)")
    public void anyUserIsForbiddenToUpdateOtherTask() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.anyUser).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary("Permission was denied");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify candidate user updates its specific task and no other user claimed the task with Rest API and response is successfull (200)")
    public void candidateUserUpdatesItsTasks() throws Exception {
        UserModel userModel1 = this.dataUser.createRandomTestUser();
        UserModel userModel2 = this.dataUser.createRandomTestUser();
        GroupModel group = this.dataGroup.createRandomGroup();
        this.dataGroup.addListOfUsersToGroup(group, new UserModel[]{userModel1, userModel2});
        TaskModel taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.owner)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(group);
        this.restTaskModel = this.restClient.authenticateUser(userModel1).withWorkflowAPI().usingTask(taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)((RestTaskModel)this.restTaskModel.assertThat().field("dueAt").isNotEmpty()).and().field("processDefinitionId").is((Object)this.activitiReviewProcessDefinition.getId())).and().field("processId").is((Object)taskModel.getProcessId())).and().field("name").is((Object)"Review Task")).and().field("description").is((Object)taskModel.getMessage())).and().field("startedAt").isNotEmpty()).and().field("id").is((Object)taskModel.getId())).and().field("state").is((Object)"unclaimed")).and().field("activityDefinitionId").is((Object)"reviewTask")).and().field("priority").is((Object)taskModel.getPriority().getLevel())).and().field("formResourceKey").is((Object)"wf:activitiReviewTask");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task owner can update twice task with status resolve successfully (200)")
    public void taskOwnerCanUpdateTaskWithResolveStateTwice() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"resolved");
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task asignee cannot update twice task with status resolve - Forbidden (403)")
    public void taskAssigneeCanNotUpdateTaskWithResolveStateTwice() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"resolved");
        this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task cannot be update using a invalid json body property - Bad Request (400)")
    public void taskCanNotBeUpdatedWithInvalidJsonBodyProperty() throws Exception {
        String invalidJsonProperty = "states";
        this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel);
        String postBody = JsonBodyGenerator.keyValueJson((String)invalidJsonProperty, (String)"completed");
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)postBody, (String)"tasks/{taskId}?{parameters}", (String[])new String[]{this.taskModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestTaskModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unrecognized field \"" + invalidJsonProperty + "\""));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task cannot be update using a invalid state - Bad Request (400)")
    public void taskCanNotBeUpdatedWithInvalidState() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("continued");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_VALUE, "task state", "continued"));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task cannot be update using a invalid property - Bad Request (400)")
    public void taskCanNotBeUpdatedWithInvalidSelectProperty() throws Exception {
        String invalidProperty = "states";
        this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=" + invalidProperty}).withWorkflowAPI().usingTask(this.taskModel);
        String postBody = JsonBodyGenerator.keyValueJson((String)"state", (String)"completed");
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)postBody, (String)"tasks/{taskId}?{parameters}", (String[])new String[]{this.taskModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestTaskModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.PROPERTY_DOES_NOT_EXIST, invalidProperty));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task can be update using multiple select values successfully (200)")
    public void taskCanBeUpdatedWithMultipleSelectValues() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "resolved").add("assignee", "admin").build();
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"resolved");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify task assignee can complete task successfully (200)")
    public void taskAssigneeCanCompleteTask() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify task owner can complete task successfully (200))")
    public void taskOwnerCanCompleteTask() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user cannot complete task - Forbidden (403))")
    public void anyUserCannotCompleteTask() throws Exception {
        UserModel anyUser = this.dataUser.createRandomTestUser();
        this.restTaskModel = this.restClient.authenticateUser(anyUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @Bug(id="REPO-2062")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task owner cannot complete task with invalid name - Bad Request(400))")
    public void taskOwnerCannotCompleteTaskWithInvalidName() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "completed").add("variables", JsonBodyGenerator.defineJSONArray().add((JsonValue)JsonBodyGenerator.defineJSON().add("name", "bpmx_priorityx").add("type", "d:int").add("value", 1).add("scope", "global").build())).build();
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,variables"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.UNSUPPORTED_TYPE, "bpm_priorityx"));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task owner cannot complete task with invalid Type - Bad Request(400))")
    public void taskOwnerCannotCompleteTaskWithInvalidType() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "completed").add("variables", JsonBodyGenerator.defineJSONArray().add((JsonValue)JsonBodyGenerator.defineJSON().add("name", "bpmx_priority").add("type", "d_int").add("value", 1).add("scope", "global").build())).build();
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,variables"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.UNSUPPORTED_TYPE, "d_int"));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @Bug(id="REPO-2062")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task owner cannot complete task with invalid value - Bad Request(400))")
    public void taskOwnerCannotCompleteTaskWithInvalidValue() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "completed").add("variables", JsonBodyGenerator.defineJSONArray().add((JsonValue)JsonBodyGenerator.defineJSON().add("name", "bpmx_priority").add("type", "d:int").add("value", "text").add("scope", "global").build())).build();
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,variables"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.UNSUPPORTED_TYPE, "text"));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task owner cannot complete task with invalid scope - Bad Request(400))")
    public void taskOwnerCannotCompleteTaskWithInvalidScope() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "completed").add("variables", JsonBodyGenerator.defineJSONArray().add((JsonValue)JsonBodyGenerator.defineJSON().add("name", "bpmx_priority").add("type", "d:int").add("value", 1).add("scope", "globalscope").build())).build();
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,variables"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.ILLEGAL_SCOPE, "globalscope"));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task assignee can claim task successfully (200)")
    public void taskAssigneeCanClaimTask() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task assignee can unclaim task successfully (200)")
    public void taskAssigneeCanUnclaimTask() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task assignee can delegate task successfully (200)")
    public void taskAssigneeCanDelegateTask() throws Exception {
        UserModel delagateToUser = this.dataUser.createRandomTestUser();
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", delagateToUser.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated")).and().field("assignee").is((Object)delagateToUser.getUsername());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task owner can delegate task to same assignee successfully (200)")
    public void taskOwnerCanDelegateTaskToSameAssignee() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.assigneeUser.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated")).and().field("assignee").is((Object)this.assigneeUser.getUsername());
    }

    @Bug(id="REPO-2063")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task assignee cannot delegate task to task owner -  (400)")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskAssigneeCannotDelegateTaskToTaskOwner() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.owner.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @Bug(id="REPO-2063")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task assignee cannot delegate task to invalid assignee - (400)")
    public void taskAssigneeCannotDelegateTaskToInvalidAssignee() throws Exception {
        UserModel invalidAssignee = new UserModel("invalidAssignee", "password");
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", invalidAssignee.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task assignee can update task with status resolve")
    public void resolveTaskAsCurrentAssignee() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"resolved");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify update task using invalid taskId")
    public void updateTaskUsingInvalidTaskId() throws Exception {
        this.taskModel.setId("invalidId");
        this.restClient.authenticateUser(this.owner).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidId"));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify update task using another name")
    public void updateTaskUsingAnotherName() throws Exception {
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=name"}).withWorkflowAPI().usingTask(this.taskModel);
        String postBody = "{\"name\":\"newNameTask\"}";
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)postBody, (String)"tasks/{taskId}?{parameters}", (String[])new String[]{this.taskModel.getId(), this.restClient.getParameters()});
        this.restTaskModel = (RestTaskModel)this.restClient.processModel(RestTaskModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restTaskModel.assertThat().field("name").is((Object)"newNameTask");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify update task using another description")
    public void updateTaskUsingAnotherDescription() throws Exception {
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=description"}).withWorkflowAPI().usingTask(this.taskModel);
        String postBody = "{\"description\":\"newDescription\"}";
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)postBody, (String)"tasks/{taskId}?{parameters}", (String[])new String[]{this.taskModel.getId(), this.restClient.getParameters()});
        this.restTaskModel = (RestTaskModel)this.restClient.processModel(RestTaskModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restTaskModel.assertThat().field("description").is((Object)"newDescription");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify update task using another priority")
    public void updateTaskUsingAnotherPriority() throws Exception {
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=priority"}).withWorkflowAPI().usingTask(this.taskModel);
        String postBody = "{\"priority\":3}";
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)postBody, (String)"tasks/{taskId}?{parameters}", (String[])new String[]{this.taskModel.getId(), this.restClient.getParameters()});
        this.restTaskModel = (RestTaskModel)this.restClient.processModel(RestTaskModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restTaskModel.assertThat().field("priority").is((Object)CMISUtil.Priority.Low.getLevel());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify update task using another priority")
    public void updateTaskUsingAnotherOwner() throws Exception {
        UserModel newOwner = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=owner"}).withWorkflowAPI().usingTask(this.taskModel);
        String postBody = "{\"owner\":\"" + newOwner.getUsername() + "\"}";
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)postBody, (String)"tasks/{taskId}?{parameters}", (String[])new String[]{this.taskModel.getId(), this.restClient.getParameters()});
        this.restTaskModel = (RestTaskModel)this.restClient.processModel(RestTaskModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restTaskModel.assertThat().field("owner").is((Object)newOwner.getUsername());
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner can not update task from completed to claimed and response is 404")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskOwnerCanNotUpdateTaskFromCompletedToClaimed() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId()));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner can not update task from completed to unclaimed and response is 404")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskOwnerCanNotUpdateTaskFromCompletedToUnclaimed() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId()));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner can not update task from completed to completed and response is 404")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskOwnerCanNotUpdateTaskWithCompleteStateTwice() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed");
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId()));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner can update task from claimed to completed and response is 200")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskOwnerCanUpdateTaskFromClaimedToCompleted() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify user can update task from claimed to claimed and response is 200")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void userCanUpdateTaskWithClaimedStateTwice() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner can update task from unclaimed to completed and response is 200")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskOwnerCanUpdateTaskFromUnclaimedToCompleted() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner can not update task from unclaimed to unclaimed and response is 404")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskOwnerCanNotUpdateTaskWithUnclaimedStateTwice() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
    }

    @Bug(id="REPO-1924")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner can not update task from delegated to completed and response is 422")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskOwnerCanNotUpdateTaskFromDelegatedToCompleted() throws Exception {
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("state", "delegated");
        body.put("assignee", this.assigneeUser.getUsername());
        String postBody = JsonBodyGenerator.keyValueJson(body);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)postBody, (String)"tasks/{taskId}?{parameters}", (String[])new String[]{this.taskModel.getId(), this.restClient.getParameters()});
        this.restTaskModel = (RestTaskModel)this.restClient.processModel(RestTaskModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated")).and().field("assignee").is((Object)this.assigneeUser.getUsername());
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(RestErrorModel.DELEGATED_TASK_CAN_NOT_BE_COMPLETED);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner can not update task from delegated to delegated and response is 404")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskOwnerCanNotUpdateTaskWithDelegatedStateTwice() throws Exception {
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("state", "delegated");
        body.put("assignee", this.assigneeUser.getUsername());
        String postBody = JsonBodyGenerator.keyValueJson(body);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)postBody, (String)"tasks/{taskId}?{parameters}", (String[])new String[]{this.taskModel.getId(), this.restClient.getParameters()});
        this.restTaskModel = (RestTaskModel)this.restClient.processModel(RestTaskModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated")).and().field("assignee").is((Object)this.assigneeUser.getUsername());
        request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)postBody, (String)"tasks/{taskId}?{parameters}", (String[])new String[]{this.taskModel.getId(), this.restClient.getParameters()});
        this.restTaskModel = (RestTaskModel)this.restClient.processModel(RestTaskModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated")).and().field("assignee").is((Object)this.assigneeUser.getUsername());
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner can update task from resolved to completed and response is 200")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskOwnerCanUpdateTaskFromResolvedToCompleted() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"resolved");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner cannot update task from status completed to delegated and response is 404")
    public void ownerCannotUpdateTaskFromCompletedToDelegated() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed");
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("delegated");
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsErrorKey(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId())).containsSummary(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify assignee cannot update task from status completed to delegated and response is 404")
    public void assigneeCannotUpdateTaskFromCompletedToDelegated() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed");
        this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("delegated");
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsErrorKey(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId())).containsSummary(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner cannot update task from status completed to resolved and response is 404")
    public void ownerCannotUpdateTaskFromCompletedToResolved() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed");
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsErrorKey(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId())).containsSummary(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify assignee cannot update task from status completed to resolved and response is 404")
    public void assigneeCannotUpdateTaskFromCompletedToResolved() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed");
        this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsErrorKey(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId())).containsSummary(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner cannot update task from status completed to completed and response is 404")
    public void ownerCannotUpdateTaskFromCompletedToCompleted() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed");
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsErrorKey(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId())).containsSummary(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify assignee cannot update task from status completed to completed and response is 404")
    public void assigneeCannotUpdateTaskFromCompletedToCompleted() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"completed");
        this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsErrorKey(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId())).containsSummary(String.format(RestErrorModel.TASK_ALREADY_COMPLETED, this.taskModel.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner can update task from status claimed to unclaimed and response is 200")
    public void ownerCanUpdateTaskFromClaimedToUnclaimed() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify assignee can update task from status claimed to unclaimed and response is 200")
    public void assigneeCanUpdateTaskFromClaimedToUnclaimed() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner can update task from status claimed to delegated and response is 200")
    public void ownerCanUpdateTaskFromClaimedToDelegated() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
        UserModel newAssignee = this.dataUser.createRandomTestUser();
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", newAssignee.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated")).and().field("assignee").is((Object)newAssignee.getUsername());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify assignee can update task from status claimed to delegated and response is 200")
    public void assigneeCanUpdateTaskFromClaimedToDelegated() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
        UserModel newAssignee = this.dataUser.createRandomTestUser();
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", newAssignee.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated")).and().field("assignee").is((Object)newAssignee.getUsername());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner can update task from status claimed to resolved and response is 200")
    public void ownerCanUpdateTaskFromClaimedToResolved() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"resolved");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify assignee can update task from status claimed to resolved and response is 200")
    public void assigneeCanUpdateTaskFromClaimedToResolved() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"resolved");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner cannot update task from status claimed to claimed and response is 409")
    public void ownerCannotUpdateTaskFromClaimedToClaimed() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restClient.assertStatusCodeIs(HttpStatus.CONFLICT).assertLastError().containsErrorKey(RestErrorModel.TASK_ALREADY_CLAIMED).containsSummary(RestErrorModel.TASK_ALREADY_CLAIMED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify assignee can update task from status claimed to claimed and response is 200")
    public void assigneeCanUpdateTaskFromClaimedToClaimed() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withWorkflowAPI().usingTask(this.taskModel).getTask();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task owner can complete task with valid variables and response is 200")
    public void taskOwnerCanCompleteTaskWithValidVariables() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "completed").add("variables", JsonBodyGenerator.defineJSONArray().add((JsonValue)JsonBodyGenerator.defineJSON().add("name", "bpm_priority").add("type", "d:int").add("value", 3).add("scope", "global").build())).build();
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,variables"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)((RestTaskModel)this.restTaskModel.assertThat().field("priority").is((Object)1)).and().field("state").is((Object)"completed")).and().field("assignee").is((Object)this.taskModel.getAssignee());
        RestVariableModelsCollection variables = this.restClient.authenticateUser(this.owner).withWorkflowAPI().usingTask((TaskModel)this.restTaskModel).getTaskVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)variables.getVariableByName("bpm_priority").assertThat().field("scope").is((Object)"global")).and().field("name").is((Object)"bpm_priority")).and().field("type").is((Object)"d:int")).and().field("value").is((Object)3);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task owner cannot complete task with empty variables array and response is 200")
    public void taskOwnerCannotUpdateTaskWithEmptyVariablesArray() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "completed").add("variables", JsonBodyGenerator.defineJSONArray()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,variables"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)((RestTaskModel)this.restTaskModel.assertThat().field("priority").is((Object)1)).and().field("state").is((Object)"completed")).and().field("assignee").is((Object)this.taskModel.getAssignee());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task owner cannot complete task with empty variables json body and response is 200")
    public void taskOwnerCannotUpdateTaskWithEmptyVariablesJsonBody() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "completed").add("variables", JsonBodyGenerator.defineJSONArray().add((JsonValue)JsonBodyGenerator.defineJSON().build())).build();
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,variables"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.VARIABLE_NAME_REQUIRED).containsSummary(RestErrorModel.VARIABLE_NAME_REQUIRED);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user with no relation to task is forbidden to delegate other task with Rest API (403)")
    public void anyUserIsForbiddenToDelegateOtherTask() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.anyUser).withWorkflowAPI().usingTask(this.taskModel).updateTask("delegated");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary("Permission was denied");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user with no relation to task is forbidden to resolve other task with Rest API (403)")
    public void anyUserIsForbiddenToResolveOtherTask() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.anyUser).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary("Permission was denied");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user with no relation to task is forbidden to claim other task with Rest API (403)")
    public void anyUserIsForbiddenToClaimOtherTask() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.anyUser).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary("Permission was denied");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user with no relation to task is forbidden to unclaim other task with Rest API (403)")
    public void anyUserIsForbiddenToUnclaimOtherTask() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.anyUser).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary("Permission was denied");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot delegate task with emty assignee name and response is 400")
    public void updateTaskWithEmptyAssigneeValue() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", "").build();
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.DELEGATING_ASSIGNEE_PROVIDED).containsSummary(RestErrorModel.DELEGATING_ASSIGNEE_PROVIDED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner can resolve task when assignee is the owner and response is 200")
    public void taskOwnerUpdateTaskResolveStateAndOwnerAssignee() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "resolved").add("assignee", this.owner.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("state").is((Object)"resolved")).and().field("assignee").isNull();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify owner cannot update task after it was deleted and response is 404")
    public void updateTaskAfterItWasDeleted() throws Exception {
        ProcessModel process = new ProcessModel();
        process.setId(this.taskModel.getProcessId());
        ((DataWorkflow)this.dataWorkflow.usingUser(this.owner)).deleteProcess(process);
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_WAS_NOT_FOUND, this.taskModel.getId()));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify task owner cannot update task with empty input body and response is 400")
    public void taskOwnerCannotUpdateTaskWithEmptyInputBody() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().build();
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.TASK_INVALID_STATE, "null")).containsSummary(String.format(RestErrorModel.TASK_INVALID_STATE, "null"));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user cannot update task using another name")
    public void anyUserCannotUpdateTaskUsingAnotherName() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("name", "Review Task-updated").build();
        this.restClient.authenticateUser(this.anyUser).withParams(new String[]{"select=name"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user cannot update task using another description")
    public void anyUserCannotUpdateTaskUsingAnotherDescription() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("description", "description updated").build();
        this.restClient.authenticateUser(this.anyUser).withParams(new String[]{"select=description"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user cannot update task using another dueAt")
    public void anyUserCannotUpdateTaskUsingAnotherDueAt() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("dueAt", "2025-01-01T11:57:32.000+0000").build();
        this.restClient.authenticateUser(this.anyUser).withParams(new String[]{"select=dueAt"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user cannot update task using another priority")
    public void anyUserCannotUpdateTaskUsingAnotherPriority() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("priority", 3).build();
        this.restClient.authenticateUser(this.anyUser).withParams(new String[]{"select=priority"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user cannot update task using another priority")
    public void anyUserCannotUpdateTaskUsingAnotherOwner() throws Exception {
        UserModel newOwner = this.dataUser.createRandomTestUser();
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("owner", newOwner.getUsername()).build();
        this.restClient.authenticateUser(this.anyUser).withParams(new String[]{"select=owner"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user cannot update task using invalid name")
    public void anyUserCannotUpdateTaskUsingInvalidName() throws Exception {
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=name"}).withWorkflowAPI().usingTask(this.taskModel);
        String postBody = "{\"name\":\"invalid-\"a\"}";
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)postBody, (String)"tasks/{taskId}?{parameters}", (String[])new String[]{this.taskModel.getId(), this.restClient.getParameters()});
        this.restTaskModel = (RestTaskModel)this.restClient.processModel(RestTaskModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.NO_CONTENT, "Unexpected character ('a'")).containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unexpected character ('a'"));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user cannot update task using invalid description")
    public void anyUserCannotUpdateTaskUsingInvalidDescription() throws Exception {
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=description"}).withWorkflowAPI().usingTask(this.taskModel);
        String postBody = "{\"description\":\"invalid-\"a\"}";
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)postBody, (String)"tasks/{taskId}?{parameters}", (String[])new String[]{this.taskModel.getId(), this.restClient.getParameters()});
        this.restTaskModel = (RestTaskModel)this.restClient.processModel(RestTaskModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.NO_CONTENT, "Unexpected character ('a'")).containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unexpected character ('a'"));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user cannot update task using invalid dueAt")
    public void anyUserCannotUpdateTaskUsingInvalidDueAt() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("dueAt", "invalid-date").build();
        this.restClient.authenticateUser(this.anyUser).withParams(new String[]{"select=dueAt"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user cannot update task using invalid priority")
    public void anyUserCannotUpdateTaskUsingInvalidPriority() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("priority", "a").build();
        this.restClient.authenticateUser(this.anyUser).withParams(new String[]{"select=priority"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify any user cannot update task using invalid priority")
    public void anyUserCannotUpdateTaskUsingInvalidOwner() throws Exception {
        this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=owner"}).withWorkflowAPI().usingTask(this.taskModel);
        String postBody = "{\"owner\":\"invalid-\"a\"}";
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)postBody, (String)"tasks/{taskId}?{parameters}", (String[])new String[]{this.taskModel.getId(), this.restClient.getParameters()});
        this.restTaskModel = (RestTaskModel)this.restClient.processModel(RestTaskModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.NO_CONTENT, "Unexpected character ('a'")).containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unexpected character ('a'"));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from unclaimed to claimed by task creator")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskCreatorCanUpdateTaskFromUnclaimedToClaimed() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"claimed");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task cannot be updated from unclaimed to claimed by a regular user not connected to the task")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void regularUserCannotUpdateTaskFromUnclaimedToClaimed() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from unclaimed to delegated by task creator")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskCreatorCanUpdateTaskFromUnclaimedToDelegated() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.owner.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task cannot be updated from unclaimed to delegated by a regular user not connected to the task")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void regularUserCannotUpdateTaskFromUnclaimedToDelegated() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.assigneeUser.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from unclaimed to resolved by task creator")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskCreatorCanUpdateTaskFromUnclaimedToResolved() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"resolved");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from unclaimed to resolved by a regular user not connected to the task")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void regularCanNotUpdateTaskFromUnclaimedToResolved() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from unclaimed to unclaimed by task creator")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskCreatorCanUpdateTaskFromUnclaimedToUnclaimed() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from unclaimed to unclaimed by a regular user not connected to the task")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void regularUserCannotUpdateTaskFromUnclaimedToUnclaimed() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="REPO-1982")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from delegated to unclaimed by task creator")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskCreatorCanUpdateTaskFromDelegatedToUnclaimed() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.assigneeUser.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
    }

    @Bug(id="REPO-1982")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from delegated to unclaimed by task assignee")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskAssigneeCanUpdateTaskFromDelegatedToUnclaimed() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.assigneeUser.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated");
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"unclaimed");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task cannot be updated from delegated to claimed since it is already claimed by task creator")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskCreatorCannotUpdateTaskFromDelegatedToClaimed() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.assigneeUser.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restClient.assertStatusCodeIs(HttpStatus.CONFLICT).assertLastError().containsErrorKey(RestErrorModel.TASK_ALREADY_CLAIMED).containsSummary(RestErrorModel.TASK_ALREADY_CLAIMED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from delegated to claimed since it is already claimed by task assignee")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskAssigneeCanUpdateTaskFromDelegatedToClaimed() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.assigneeUser.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated");
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated");
    }

    @Bug(id="REPO-1924")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from delegated to completed by task creator")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskCreatorCanUpdateTaskFromDelegatedToCompleted() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.assigneeUser.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).containsSummary(RestErrorModel.DELEGATED_TASK_CAN_NOT_BE_COMPLETED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="REPO-1924")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from delegated to completed by task assignee")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskAssigneeCanUpdateTaskFromDelegatedToCompleted() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.assigneeUser.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated");
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("completed");
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).containsSummary(RestErrorModel.DELEGATED_TASK_CAN_NOT_BE_COMPLETED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from delegated to resolved")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskCreatorCanUpdateTaskFromDelegatedToResolved() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.assigneeUser.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"resolved");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from delegated to resolved by task assignee")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskAssigneeCanUpdateTaskFromDelegatedToResolved() throws Exception {
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.assigneeUser.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated");
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"resolved");
    }

    @Bug(id="REPO-1982")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from resolved to unclaimed by task creator")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskCreatorCanUpdateTaskFromResolvedToUnclaimed() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"resolved");
    }

    @Bug(id="REPO-1982")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task cannot be updated from resolved to unclaimed by task assignee")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskAssigneeCannotUpdateTaskFromResolvedToUnclaimed() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("unclaimed");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="REPO-1982")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task cannot be updated from resolved to claimed by task owner")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskOwnerCanUpdateTaskFromResolvedToClaimed() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"resolved");
    }

    @Bug(id="REPO-1982")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task cannot be updated from resolved to claimed by task assignee")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskAssigneeCanUpdateTaskFromResolvedToClaimed() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("claimed");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="REPO-1982")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from resolved to delegated by task creator")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskCreatorCannotUpdateTaskFromResolvedToDelegated() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.assigneeUser.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"delegated");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from resolved to delegated by task assignee")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskAssigneeCannotUpdateTaskFromResolvedToDelegated() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        JsonObject inputJson = JsonBodyGenerator.defineJSON().add("state", "delegated").add("assignee", this.assigneeUser.getUsername()).build();
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state,assignee"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(inputJson);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="REPO-1982")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from resolved to resolved by task creator")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskCreatorCannotUpdateTaskFromResolvedToResolved() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestTaskModel)this.restTaskModel.assertThat().field("id").is((Object)this.taskModel.getId())).and().field("state").is((Object)"resolved");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that task can be updated from resolved to resolved by task assignee")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void taskAssigneeCannotUpdateTaskFromResolvedToResolved() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restTaskModel = this.restClient.authenticateUser(this.assigneeUser).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="REPO-1982")
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task by providing empty select value")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskByProvidingEmptySelectValue() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select="}).withWorkflowAPI().usingTask(this.taskModel).updateTask("resolved");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.INVALID_SELECT_ERRORKEY).containsSummary(RestErrorModel.INVALID_SELECT).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task by providing empty state value")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskByProvidingEmptyStateValue() throws Exception {
        this.restTaskModel = this.restClient.authenticateUser(this.owner).withParams(new String[]{"select=state"}).withWorkflowAPI().usingTask(this.taskModel).updateTask(" ");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.TASK_INVALID_STATE, " ")).containsSummary(String.format(RestErrorModel.TASK_INVALID_STATE, " ")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

