/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.alfresco.webdav.WebDavWrapper;
import org.junit.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CreateFileTests
extends WebDavTest {
    UserModel managerUser;
    SiteModel testSite;
    FileModel testFile;
    private String content = "webdav file content";

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that admin user can create a file in Guest Home folder")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void adminShouldCreateFile() throws Exception {
        FolderModel guestHomeFolder = FolderModel.getGuestHomeFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)guestHomeFolder).createFile(this.testFile).and()).assertThat().hasStatus(201).then()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager can create file in site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManagerShouldCreateFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL, (String)this.content);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().hasStatus(201).then()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with contributor role can create file in site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteContributorShouldCreateFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSPOWERPOINT, (String)this.content);
        UserModel contributor = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(contributor, this.testSite, UserRole.SiteContributor);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(contributor).usingSite(this.testSite).createFile(this.testFile).assertThat().hasStatus(201).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with collaborator role can create file in site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteCollaboratorShouldCreateFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.content);
        UserModel collaborator = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(collaborator, this.testSite, UserRole.SiteCollaborator);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(collaborator).usingSite(this.testSite).createFile(this.testFile).assertThat().hasStatus(201).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with consumer role cannot create file in site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteConsumerShouldCreateFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.content);
        UserModel consumer = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(consumer, this.testSite, UserRole.SiteConsumer);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(consumer).usingSite(this.testSite).createFile(this.testFile).assertThat().hasStatus(403).and()).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInWebdav().and()).assertThat().hasStatus(404);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that user with manager role can create file with spaces in name")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManageShouldCreateFileWithSpacesInName() throws Exception {
        this.testFile = new FileModel("test file " + RandomData.getRandomFile((FileType)FileType.PDF));
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().hasStatus(201).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager cannot create file in site with symbols in name")
    @Test(groups={"protocols", "webdav", "core", "linux"}, expectedExceptions={IllegalArgumentException.class})
    public void siteManagerShouldCreateFileWithSymbolsInName() throws Exception {
        this.testFile = new FileModel("<>.|?#()[]{}.txt", FileType.MSWORD2007, this.content);
        this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that user with manager role can create file with no content")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManageShouldCreateFileWithNoContent() throws Exception {
        FileModel noContentFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(noContentFile).assertThat().hasStatus(201).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).assertThat().contentIs("");
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that inexistent user cannot create file")
    @Test(groups={"protocols", "webdav", "core"})
    public void inexistentUserShouldNotCreateFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(UserModel.getRandomUserModel()).usingResource((ContentModel)FolderModel.getSharedFolderModel()).createFile(this.testFile).assertThat().hasStatus(401).then()).usingAdmin()).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that unauthorized user cannot create file")
    @Test(groups={"protocols", "webdav", "core"})
    public void unauthorizedUserShouldNotCreateFile() throws Exception {
        UserModel unauthorized = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(unauthorized).usingRoot().createFile(this.testFile).assertThat().hasStatus(403).then()).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can create file in site")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManagerShouldNotCreateFileTwice() throws Exception {
        SiteModel twiceSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL, (String)this.content);
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(twiceSite).createFile(this.testFile).and()).assertThat().hasStatus(201).createFile(this.testFile).assertThat().hasStatus(204);
        Assert.assertTrue((this.webDavProtocol.usingSite(twiceSite).getFiles().size() == 1 ? 1 : 0) != 0);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify user can create file with a size smaller than the quota limit")
    @Test(groups={"protocols", "webdav", "full"})
    public void userCanCreateFileSmallerThanQuotaLimit() throws Exception {
        UserModel quotaUser = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(quotaUser, this.testSite, UserRole.SiteCollaborator);
        ((DataUser)this.dataUser.usingAdmin()).setUserQuota(quotaUser, 5);
        FileModel quotaFile = FileModel.getFileModelWithContentSizeOfxMB((int)1);
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(quotaUser).usingSite(this.testSite).createFile(quotaFile).then()).assertThat().existsInWebdav().assertThat().existsInRepo();
    }
}

