/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.alfresco.webdav.WebDavWrapper;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteFileTests
extends WebDavTest {
    UserModel managerUser;
    SiteModel testSite;
    FileModel testFile;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that admin user can delete content from repository")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void adminShouldDeleteContent() throws Exception {
        FolderModel guest = FolderModel.getGuestHomeFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)guest).createFile(this.testFile).then()).delete().and()).assertThat().hasStatus(200).and()).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInWebdav().and()).assertThat().hasStatus(404);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager can delete content from site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManagerShouldDeleteContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).delete().assertThat().hasStatus(200).and()).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInWebdav().and()).assertThat().hasStatus(404);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site collaborator cannot delete content from site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteCollaboratorShouldNotDeleteContent() throws Exception {
        UserModel collaborator = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(collaborator, this.testSite, UserRole.SiteCollaborator);
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).authenticateUser(collaborator).usingResource((ContentModel)this.testFile).delete().and()).assertThat().hasStatus(403).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site contributor cannot delete content from site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteContributorShouldNotDeleteContent() throws Exception {
        UserModel contributor = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(contributor, this.testSite, UserRole.SiteContributor);
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).authenticateUser(contributor).usingResource((ContentModel)this.testFile).delete().and()).assertThat().hasStatus(403).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site consumer cannot delete content from site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteConsumerShouldNotDeleteContent() throws Exception {
        UserModel consumer = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(consumer, this.testSite, UserRole.SiteConsumer);
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).then()).authenticateUser(consumer).usingResource((ContentModel)this.testFile).delete().and()).assertThat().hasStatus(403).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager cannot delete a file twice from site")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManagerShouldNotDeleteAFileTwice() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.XML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).delete().and()).assertThat().doesNotExistInRepo()).when()).delete().assertThat().hasStatus(404);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager cannot delete inexistent file")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManagerShouldNotDeleteInexistentContent() throws Exception {
        this.webDavProtocol.authenticateUser(this.managerUser).usingResource((ContentModel)FileModel.getRandomFileModel((FileType)FileType.MSEXCEL)).delete().assertThat().hasStatus(404);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that a disconected user cannot delete file from site")
    @Test(groups={"protocols", "webdav", "core"})
    public void disconectedUserShouldNotDeleteContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).disconnect().then()).delete().assertThat().hasStatus(401).then()).authenticateUser(this.managerUser).usingResource((ContentModel)this.testFile).assertThat().existsInRepo()).and()).assertThat().existsInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that a unauthorized user cannot delete file from site")
    @Test(groups={"protocols", "webdav", "core"})
    public void unauthorizedUserShouldNotDeleteContent() throws Exception {
        UserModel unauthorized = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).authenticateUser(unauthorized).and()).delete().assertThat().hasStatus(403).assertThat().existsInRepo()).and()).assertThat().existsInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that a inexistent user cannot delete file")
    @Test(groups={"protocols", "webdav", "core"})
    public void inexistentUserShouldNotDeleteContent() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).authenticateUser(UserModel.getRandomUserModel()).and()).delete().assertThat().hasStatus(401).then()).authenticateUser(this.managerUser).assertThat().existsInRepo()).and()).assertThat().existsInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager cannot delete locked file")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManagerCannotNotDeleteLockedFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).assertThat().existsInRepo()).then()).lock().assertThat().isLocked().then()).delete().assertThat().hasStatus(423).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav();
    }
}

