/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.alfresco.webdav.WebDavWrapper;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CopyTests
extends WebDavTest {
    UserModel managerUser;
    UserModel adminUser;
    SiteModel testSite;
    FolderModel sourceFolder;
    FolderModel destinationFolder;
    FileModel testFile;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
        this.destinationFolder = FolderModel.getRandomFolderModel();
        this.adminUser = this.dataUser.getAdminUser();
        this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.destinationFolder);
    }

    @Test(groups={"protocols", "webdav", "sanity"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that admin user can copy an empty folder in repository")
    public void adminShouldCopyEmptyFolderToNewLocation() throws Exception {
        FolderModel guest = FolderModel.getGuestHomeFolderModel();
        this.sourceFolder = new FolderModel("copy " + RandomData.getRandomFolder());
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.adminUser).usingRoot().createFolder(this.sourceFolder).then()).copyTo((ContentModel)guest).and()).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).when()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that an user with site manager role can copy an empty folder with content in site")
    public void siteManagerUserShouldCopyEmptyFolder() throws Exception {
        UserModel managerUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(managerUser)).addUserToSite(managerUser, this.testSite, UserRole.SiteManager);
        this.sourceFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.adminUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).assertThat().existsInRepo()).then()).copyTo((ContentModel)this.destinationFolder).and()).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).when()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can copy an empty folder with content in site")
    public void siteManagerShouldCopyEmptyFolder() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).assertThat().existsInRepo()).then()).copyTo((ContentModel)this.destinationFolder).and()).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).when()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "sanity"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that an user with site manager role can copy folder with content in site")
    public void siteManagerUserShouldCopyFolderWithContent() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        UserModel managerUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(managerUser)).addUserToSite(managerUser, this.testSite, UserRole.SiteManager);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.adminUser).usingSite(this.testSite).createFolder(this.sourceFolder).then()).usingResource((ContentModel)this.sourceFolder).createFile(this.testFile).and()).assertThat().existsInRepo()).when()).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.destinationFolder).and()).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).and()).assertThat().hasFiles(new FileModel[]{this.testFile}).then()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo()).and()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "sanity"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager can copy folder with content in site")
    public void siteManagerShouldCopyFolderWithContent() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).then()).usingResource((ContentModel)this.sourceFolder).createFile(this.testFile).and()).assertThat().existsInRepo()).when()).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.destinationFolder).and()).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).and()).assertThat().hasFiles(new FileModel[]{this.testFile}).then()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo()).and()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that user with collaborator role can copy an empty folder in site folder")
    public void siteCollaboratorShouldCopyEmptyFolderAddedByOtherUser() throws Exception {
        UserModel collaborator = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(collaborator, this.testSite, UserRole.SiteCollaborator);
        this.sourceFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).assertThat().existsInRepo()).then()).authenticateUser(collaborator).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.destinationFolder).and()).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).when()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "sanity"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with collaborator role can copy folder with content in site folder")
    public void siteCollaboratorShouldCopyFolderWithContentAddedByOtherUser() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        UserModel collaborator = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.XML);
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(collaborator, this.testSite, UserRole.SiteCollaborator);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).usingResource((ContentModel)this.sourceFolder).createFile(this.testFile).then()).authenticateUser(collaborator).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.destinationFolder).and()).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).and()).assertThat().hasFiles(new FileModel[]{this.testFile}).then()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo()).and()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that user with collaborator role can copy a file in site")
    public void siteCollaboratorShouldCopyFileAddedByOtherUser() throws Exception {
        UserModel collaborator = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(collaborator, this.testSite, UserRole.SiteCollaborator);
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).authenticateUser(collaborator).usingResource((ContentModel)this.testFile).copyTo((ContentModel)this.destinationFolder).and()).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).when()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that user with contribuitor role can copy an empty folder in site")
    public void siteContribuitorShouldCopyEmptyFolderAddedByOtherUser() throws Exception {
        UserModel contributor = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(contributor, this.testSite, UserRole.SiteContributor);
        this.sourceFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).assertThat().existsInRepo()).then()).authenticateUser(contributor).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.destinationFolder).and()).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).when()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "sanity"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with contributor role can copy folder with content in site folder")
    public void siteContributorShouldCopyFolderWithContentAddedByOtherUser() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        UserModel contributor = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.PDF);
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(contributor, this.testSite, UserRole.SiteContributor);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).usingResource((ContentModel)this.sourceFolder).createFile(this.testFile).then()).authenticateUser(contributor).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.destinationFolder).and()).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).and()).assertThat().hasFiles(new FileModel[]{this.testFile}).when()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo()).and()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that user with contributor role can copy a file in site")
    public void siteContributorShouldCopyFileAddedByOtherUser() throws Exception {
        UserModel contributor = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(contributor, this.testSite, UserRole.SiteCollaborator);
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).authenticateUser(contributor).usingResource((ContentModel)this.testFile).copyTo((ContentModel)this.destinationFolder).and()).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).when()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that user with consumer role cannot copy an empty folder in site")
    public void siteConsumerShouldNotCopyEmptyFolderAddedByOtherUser() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        UserModel consumer = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(consumer, this.testSite, UserRole.SiteConsumer);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).assertThat().existsInRepo()).then()).authenticateUser(consumer).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.destinationFolder).and()).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(403).when()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "sanity"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with consumer role cannot copy folder with content in site folder")
    public void siteConsumerShouldNotCopyFolderWithContentAddedByOther() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSPOWERPOINT);
        UserModel consumer = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(consumer, this.testSite, UserRole.SiteConsumer);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).usingResource((ContentModel)this.sourceFolder).createFile(this.testFile).then()).authenticateUser(consumer).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.destinationFolder).and()).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(403).when()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo()).and()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that user with consumer role cannot copy a file in site")
    public void siteConsumerShouldNotCopyFileAddedByOtherUser() throws Exception {
        UserModel consumer = this.dataUser.createRandomTestUser();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(consumer, this.testSite, UserRole.SiteConsumer);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).authenticateUser(consumer).usingResource((ContentModel)this.testFile).copyTo((ContentModel)this.destinationFolder).and()).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(403).when()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "sanity"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager can copy file from site in repository")
    public void siteManagerShouldCopyFileInRepository() throws Exception {
        FolderModel guest = FolderModel.getSharedFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).copyTo((ContentModel)guest).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).then()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can copy an empty folder twice in same location")
    public void siteManagerShouldCopyEmptyFolderTwiceInSameLocation() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).copyTo((ContentModel)this.destinationFolder).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).then()).copyTo((ContentModel)this.destinationFolder).assertThat().existsInRepo()).and()).assertThat().hasStatus(201);
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can copy a folder with content twice in same location")
    public void siteManagerShouldCopyFolderWithContentTwiceInSameLocation() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).usingResource((ContentModel)this.sourceFolder).createFile(this.testFile).copyTo((ContentModel)this.destinationFolder).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).then()).copyTo((ContentModel)this.destinationFolder).assertThat().existsInRepo()).and()).assertThat().hasStatus(201);
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager cannot copy nonexistent folder with content from site")
    public void siteManagerShouldNotCopyNonexistentFolderWithContent() throws Exception {
        UserModel managerUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(managerUser)).addUserToSite(managerUser, this.testSite, UserRole.SiteManager);
        this.sourceFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).usingResource((ContentModel)this.sourceFolder).createFile(this.testFile).delete().and()).assertThat().doesNotExistInRepo()).when()).copyTo((ContentModel)this.destinationFolder).assertThat().hasStatus(404);
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager cannot copy nonexistent empty folder from site")
    public void siteManagerShouldNotCopyNonexistentEmptyFolder() throws Exception {
        UserModel managerUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(managerUser)).addUserToSite(managerUser, this.testSite, UserRole.SiteManager);
        this.sourceFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).delete().and()).assertThat().doesNotExistInRepo()).when()).copyTo((ContentModel)this.destinationFolder).assertThat().hasStatus(404);
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager cannot copy nonexistent file from site")
    public void siteManagerShouldNotCopyNonexistentFile() throws Exception {
        UserModel managerUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(managerUser)).addUserToSite(managerUser, this.testSite, UserRole.SiteManager);
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(managerUser).usingSite(this.testSite).createFile(this.testFile).delete().and()).assertThat().doesNotExistInRepo()).when()).copyTo((ContentModel)this.destinationFolder).assertThat().hasStatus(404);
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that unauthenticated user cannot copy a folder with content from site")
    public void unauthenticatedUserShouldNotCopyFolderWithContent() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).usingResource((ContentModel)this.sourceFolder).createFile(this.testFile).and()).assertThat().existsInRepo()).when()).disconnect().usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.destinationFolder).and()).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(401).then()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that unauthenticated user cannot copy an empty folder from site")
    public void unauthenticatedUserShouldNotCopyEmptyFolder() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).assertThat().existsInRepo()).when()).disconnect().usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.destinationFolder).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(401).then()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that unauthenticated user cannot copy a file from site")
    public void unauthenticatedUserShouldNotCopyFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).when()).disconnect().usingResource((ContentModel)this.testFile).copyTo((ContentModel)this.destinationFolder).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(401).then()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that nonnexistent user cannot copy a folder with content from site")
    public void nonexistentUserShouldNotCopyFolderWithContent() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).usingResource((ContentModel)this.sourceFolder).createFile(this.testFile).and()).assertThat().existsInRepo()).then()).authenticateUser(UserModel.getRandomUserModel()).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.destinationFolder).then()).usingAdmin()).and()).assertThat().hasStatus(401).assertThat().doesNotExistInRepo()).then()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that nonexistent user cannot copy an empty folder from site")
    public void nonexistentUserShouldNotCopyEmptyFolder() throws Exception {
        this.sourceFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.sourceFolder).and()).assertThat().existsInRepo()).then()).authenticateUser(UserModel.getRandomUserModel()).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.destinationFolder).then()).usingAdmin()).and()).assertThat().hasStatus(401).assertThat().doesNotExistInRepo()).then()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that unauthorized user cannot copy an empty folder from site")
    public void unauthorizedUserShouldNotCopyEmptyFolder() throws Exception {
        UserModel unauthorizedUser = this.dataUser.createRandomTestUser();
        this.sourceFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.adminUser).usingRoot().createFolder(this.sourceFolder).and()).assertThat().existsInRepo()).when()).authenticateUser(unauthorizedUser).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.destinationFolder).assertThat().hasStatus(403).and()).assertThat().doesNotExistInRepo()).then()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that unauthorized user cannot copy a folder with content from site")
    public void unauthorizedUserShouldNotCopyFolderWithContent() throws Exception {
        UserModel unauthorizedUser = this.dataUser.createRandomTestUser();
        this.sourceFolder = FolderModel.getRandomFolderModel();
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.HTML);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.adminUser).usingRoot().createFolder(this.sourceFolder).and()).usingResource((ContentModel)this.sourceFolder).createFile(this.testFile).and()).assertThat().existsInRepo()).when()).authenticateUser(unauthorizedUser).usingResource((ContentModel)this.sourceFolder).copyTo((ContentModel)this.destinationFolder).assertThat().hasStatus(403).and()).assertThat().doesNotExistInRepo()).then()).usingResource((ContentModel)this.sourceFolder).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can copy a locked file")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManagerShouldCopyLockedFile() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSEXCEL);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo()).lock().copyTo((ContentModel)this.destinationFolder).and()).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).and()).assertThat().hasFiles(new FileModel[]{this.testFile}).and()).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }
}

