/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.alfresco.webdav.WebDavWrapper;
import org.testng.annotations.Test;

public class RequestResponseTests
extends WebDavTest {
    @Bug(id="MNT-17475", status=Bug.Status.FIXED)
    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that the Content-Disposition response header value contains filename as attachment")
    public void contentDispositionResponseHeaderValueIsCorrect() throws Exception {
        FolderModel guestHomeFolder = FolderModel.getGuestHomeFolderModel();
        FileModel testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)guestHomeFolder).createFile(testFile).and()).assertThat().hasStatus(201).and()).assertThat().existsInWebdav().then()).assertThat().hasResponseHeaderValue(WebDavWrapper.RESPONSE_HEADER_CONTENT_TYPE, "text/plain").and()).assertThat().hasResponseHeaderValue(WebDavWrapper.RESPONSE_HEADER_CONTENT_DISPOSITION, "attachment; filename=\"" + testFile.getName() + "\"; filename*=UTF-8'");
    }
}

